/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SafeRunnable.class);
    @Nonnull
    private final String name;
    @Nonnull
    private final Runnable runnable;

    public SafeRunnable(@Nonnull String name, @Nonnull Runnable runnable) {
        this.name = Preconditions.checkNotNull(name);
        this.runnable = Preconditions.checkNotNull(runnable);
    }

    @Override
    public void run() {
        String n = Thread.currentThread().getName();
        Thread.currentThread().setName(this.name);
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            LOG.error("Uncaught exception in {}", (Object)this.name, (Object)e);
            throw e;
        }
        finally {
            Thread.currentThread().setName(n);
        }
    }
}

