/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.segment.file.GCMonitorMBean;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.helpers.MessageFormatter;

public class FileStoreGCMonitor
extends AnnotatedStandardMBean
implements GCMonitor,
GCMonitorMBean {
    private final Clock clock;
    private long lastCompaction;
    private long lastCleanup;
    private long lastRepositorySize;
    private long lastReclaimedSize;
    private String lastError;
    private String status = "NA";

    public FileStoreGCMonitor(@Nonnull Clock clock) {
        super(GCMonitorMBean.class);
        this.clock = Preconditions.checkNotNull(clock);
    }

    @Override
    public void info(String message, Object ... arguments) {
        this.status = MessageFormatter.arrayFormat(message, arguments).getMessage();
    }

    @Override
    public void warn(String message, Object ... arguments) {
        this.status = MessageFormatter.arrayFormat(message, arguments).getMessage();
    }

    @Override
    public void error(String message, Exception exception) {
        StringWriter sw = new StringWriter();
        sw.write(message + ": ");
        exception.printStackTrace(new PrintWriter(sw));
        this.lastError = sw.toString();
    }

    @Override
    public void skipped(String reason, Object ... arguments) {
        this.status = MessageFormatter.arrayFormat(reason, arguments).getMessage();
    }

    @Override
    public void compacted(long[] segmentCounts, long[] recordCounts, long[] compactionMapWeights) {
        this.lastCompaction = this.clock.getTime();
    }

    @Override
    public void cleaned(long reclaimed, long current) {
        this.lastCleanup = this.clock.getTime();
        this.lastReclaimedSize = reclaimed;
        this.lastRepositorySize = current;
    }

    @Override
    public String getLastCompaction() {
        return FileStoreGCMonitor.toString(this.lastCompaction);
    }

    @Override
    public String getLastCleanup() {
        return FileStoreGCMonitor.toString(this.lastCleanup);
    }

    @Override
    public long getLastRepositorySize() {
        return this.lastRepositorySize;
    }

    @Override
    public long getLastReclaimedSize() {
        return this.lastReclaimedSize;
    }

    private static String toString(long timestamp) {
        if (timestamp != 0L) {
            return DateFormat.getDateTimeInstance().format(new Date(timestamp));
        }
        return null;
    }

    @Override
    public String getLastError() {
        return this.lastError;
    }

    @Override
    @Nonnull
    public String getStatus() {
        return this.status;
    }
}

