/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import com.google.common.base.Supplier;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.io.File;
import java.util.UUID;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.segment.RecordIdSet;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.file.GCEstimation;
import org.apache.jackrabbit.oak.segment.file.TarEntryVisitor;
import org.apache.jackrabbit.oak.segment.file.TarReader;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;

class CompactionGainEstimate
implements TarEntryVisitor,
GCEstimation {
    private static final Funnel<UUID> UUID_FUNNEL = new Funnel<UUID>(){

        @Override
        public void funnel(UUID from, PrimitiveSink into) {
            into.putLong(from.getMostSignificantBits());
            into.putLong(from.getLeastSignificantBits());
        }
    };
    private final BloomFilter<UUID> uuids;
    private final int gainThreshold;
    private long totalSize = 0L;
    private long reachableSize = 0L;
    private boolean gcNeeded;
    private String gcInfo = "unknown";
    private boolean finished = false;

    CompactionGainEstimate(SegmentNodeState node, int estimatedBulkCount, Supplier<Boolean> stop, int gainThreshold) {
        this.uuids = BloomFilter.create(UUID_FUNNEL, estimatedBulkCount);
        this.gainThreshold = gainThreshold;
        this.collectReferencedSegments(node, new RecordIdSet(), stop);
    }

    private void collectReferencedSegments(SegmentNodeState node, RecordIdSet visited, Supplier<Boolean> stop) {
        if (!stop.get().booleanValue() && visited.addIfNotPresent(node.getRecordId())) {
            this.collectUUID(node.getRecordId().getSegmentId());
            for (PropertyState propertyState : node.getProperties()) {
                if (propertyState instanceof SegmentPropertyState) {
                    this.collectUUID(((SegmentPropertyState)propertyState).getRecordId().getSegmentId());
                }
                for (Blob blob : propertyState.getValue(Type.BINARIES)) {
                    for (SegmentId id : SegmentBlob.getBulkSegmentIds(blob)) {
                        this.collectUUID(id);
                    }
                }
            }
            for (ChildNodeEntry childNodeEntry : node.getChildNodeEntries()) {
                this.collectReferencedSegments((SegmentNodeState)childNodeEntry.getNodeState(), visited, stop);
            }
        }
    }

    private void collectUUID(SegmentId segmentId) {
        this.uuids.put(new UUID(segmentId.getMostSignificantBits(), segmentId.getLeastSignificantBits()));
    }

    public long estimateCompactionGain() {
        if (this.totalSize == 0L) {
            return 0L;
        }
        return 100L * (this.totalSize - this.reachableSize) / this.totalSize;
    }

    private void run() {
        if (this.finished) {
            return;
        }
        long gain = this.estimateCompactionGain();
        boolean bl = this.gcNeeded = gain >= (long)this.gainThreshold;
        this.gcInfo = this.gcNeeded ? String.format("Gain is %s%% or %s/%s (%s/%s bytes), so running compaction", gain, IOUtils.humanReadableByteCount(this.reachableSize), IOUtils.humanReadableByteCount(this.totalSize), this.reachableSize, this.totalSize) : (this.totalSize == 0L ? "Skipping compaction for now as repository consists of a single tar file only" : String.format("Gain is %s%% or %s/%s (%s/%s bytes), so skipping compaction for now", gain, IOUtils.humanReadableByteCount(this.reachableSize), IOUtils.humanReadableByteCount(this.totalSize), this.reachableSize, this.totalSize));
        this.finished = true;
    }

    @Override
    public boolean gcNeeded() {
        if (!this.finished) {
            this.run();
        }
        return this.gcNeeded;
    }

    @Override
    public String gcLog() {
        if (!this.finished) {
            this.run();
        }
        return this.gcInfo;
    }

    @Override
    public void visit(long msb, long lsb, File file, int offset, int size) {
        UUID uuid = new UUID(msb, lsb);
        int entrySize = TarReader.getEntrySize(size);
        this.totalSize += (long)entrySize;
        if (this.uuids.mightContain(uuid)) {
            this.reachableSize += (long)entrySize;
        }
    }
}

