/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheStats;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.segment.NodeCache;
import org.apache.jackrabbit.oak.segment.RecordCache;
import org.apache.jackrabbit.oak.segment.RecordCacheStats;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.segment.file.PriorityCache;

public abstract class WriterCacheManager {
    public static final int DEFAULT_STRING_CACHE_SIZE = Integer.getInteger("oak.tar.stringsCacheSize", 15000);
    public static final int DEFAULT_TEMPLATE_CACHE_SIZE = Integer.getInteger("oak.tar.templatesCacheSize", 3000);
    public static final int DEFAULT_NODE_CACHE_SIZE = Integer.getInteger("oak.tar.nodeCacheSize", 0x800000);

    @Nonnull
    public abstract RecordCache<String> getStringCache(int var1);

    @Nonnull
    public abstract RecordCache<Template> getTemplateCache(int var1);

    @Nonnull
    public abstract NodeCache getNodeCache(int var1);

    @CheckForNull
    public CacheStatsMBean getStringCacheStats() {
        return null;
    }

    @CheckForNull
    public CacheStatsMBean getTemplateCacheStats() {
        return null;
    }

    @CheckForNull
    public CacheStatsMBean getNodeCacheStats() {
        return null;
    }

    @CheckForNull
    public String getNodeCacheOccupancyInfo() {
        return null;
    }

    public static class Default
    extends WriterCacheManager {
        private final Generations<RecordCache<String>> stringCaches;
        private final Generations<RecordCache<Template>> templateCaches;
        private final Supplier<PriorityCache<String, RecordId>> nodeCache;

        public Default(@Nonnull Supplier<RecordCache<String>> stringCacheFactory, @Nonnull Supplier<RecordCache<Template>> templateCacheFactory, @Nonnull Supplier<PriorityCache<String, RecordId>> nodeCacheFactory) {
            this.stringCaches = new Generations<RecordCache<String>>(stringCacheFactory);
            this.templateCaches = new Generations<RecordCache<Template>>(templateCacheFactory);
            this.nodeCache = Suppliers.memoize(nodeCacheFactory);
        }

        public Default() {
            this(RecordCache.factory(DEFAULT_STRING_CACHE_SIZE), RecordCache.factory(DEFAULT_TEMPLATE_CACHE_SIZE), PriorityCache.factory(DEFAULT_NODE_CACHE_SIZE));
        }

        @Override
        @Nonnull
        public RecordCache<String> getStringCache(int generation) {
            return this.stringCaches.getGeneration(generation);
        }

        @Override
        @Nonnull
        public RecordCache<Template> getTemplateCache(int generation) {
            return this.templateCaches.getGeneration(generation);
        }

        @Override
        @Nonnull
        public NodeCache getNodeCache(final int generation) {
            return new NodeCache(){

                @Override
                public void put(@Nonnull String stableId, @Nonnull RecordId recordId, byte cost) {
                    ((PriorityCache)Default.this.nodeCache.get()).put(stableId, recordId, generation, cost);
                }

                @Override
                @CheckForNull
                public RecordId get(@Nonnull String stableId) {
                    return (RecordId)((PriorityCache)Default.this.nodeCache.get()).get(stableId, generation);
                }
            };
        }

        @Override
        @CheckForNull
        public CacheStatsMBean getStringCacheStats() {
            return new RecordCacheStats("String deduplication cache stats", Default.accumulateRecordCacheStats(this.stringCaches), Default.accumulateRecordCacheSizes(this.stringCaches));
        }

        @Override
        @CheckForNull
        public CacheStatsMBean getTemplateCacheStats() {
            return new RecordCacheStats("Template deduplication cache stats", Default.accumulateRecordCacheStats(this.templateCaches), Default.accumulateRecordCacheSizes(this.templateCaches));
        }

        @Nonnull
        private static <T> Supplier<CacheStats> accumulateRecordCacheStats(final Iterable<RecordCache<T>> caches) {
            return new Supplier<CacheStats>(){

                @Override
                public CacheStats get() {
                    CacheStats stats = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
                    for (RecordCache cache : caches) {
                        stats = stats.plus(cache.getStats());
                    }
                    return stats;
                }
            };
        }

        @Nonnull
        public static <T> Supplier<Long> accumulateRecordCacheSizes(final Iterable<RecordCache<T>> caches) {
            return new Supplier<Long>(){

                @Override
                public Long get() {
                    long size = 0L;
                    for (RecordCache cache : caches) {
                        size += cache.size();
                    }
                    return size;
                }
            };
        }

        @Override
        @CheckForNull
        public CacheStatsMBean getNodeCacheStats() {
            return new RecordCacheStats("Node deduplication cache stats", new Supplier<CacheStats>(){

                @Override
                public CacheStats get() {
                    return ((PriorityCache)Default.this.nodeCache.get()).getStats();
                }
            }, new Supplier<Long>(){

                @Override
                public Long get() {
                    return ((PriorityCache)Default.this.nodeCache.get()).size();
                }
            });
        }

        @Override
        public String getNodeCacheOccupancyInfo() {
            return this.nodeCache.get().toString();
        }

        protected final void evictCaches(Predicate<Integer> generations) {
            this.stringCaches.evictGenerations(generations);
            this.templateCaches.evictGenerations(generations);
            this.nodeCache.get().purgeGenerations(generations);
        }

        private static class Generations<T>
        implements Iterable<T> {
            private final ConcurrentMap<Integer, Supplier<T>> generations = Maps.newConcurrentMap();
            private final Supplier<T> cacheFactory;

            Generations(@Nonnull Supplier<T> cacheFactory) {
                this.cacheFactory = Preconditions.checkNotNull(cacheFactory);
            }

            T getGeneration(int generation) {
                if (!this.generations.containsKey(generation)) {
                    this.generations.putIfAbsent(generation, Suppliers.memoize(this.cacheFactory));
                }
                return ((Supplier)this.generations.get(generation)).get();
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(this.generations.values().iterator(), new Function<Supplier<T>, T>(){

                    @Override
                    @Nullable
                    public T apply(Supplier<T> cacheFactory) {
                        return cacheFactory.get();
                    }
                });
            }

            void evictGenerations(@Nonnull Predicate<Integer> evict) {
                Iterator it = this.generations.keySet().iterator();
                while (it.hasNext()) {
                    if (!evict.apply((Integer)it.next())) continue;
                    it.remove();
                }
            }
        }
    }

    public static class Empty
    extends WriterCacheManager {
        public static final WriterCacheManager INSTANCE = new Empty();
        private final RecordCache<String> stringCache = RecordCache.newRecordCache(0);
        private final RecordCache<Template> templateCache = RecordCache.newRecordCache(0);

        private Empty() {
        }

        @Override
        public RecordCache<String> getStringCache(int generation) {
            return this.stringCache;
        }

        @Override
        public RecordCache<Template> getTemplateCache(int generation) {
            return this.templateCache;
        }

        @Override
        @Nonnull
        public NodeCache getNodeCache(int generation) {
            return new NodeCache(){

                @Override
                public void put(@Nonnull String stableId, @Nonnull RecordId recordId, byte cost) {
                }

                @Override
                @CheckForNull
                public RecordId get(@Nonnull String stableId) {
                    return null;
                }
            };
        }
    }
}

