/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentReader;

public class SegmentPropertyState
extends Record
implements PropertyState {
    @Nonnull
    private final SegmentReader reader;
    @Nonnull
    private final String name;
    @Nonnull
    private final Type<?> type;

    SegmentPropertyState(@Nonnull SegmentReader reader, @Nonnull RecordId id, @Nonnull String name, @Nonnull Type<?> type) {
        super(id);
        this.reader = Preconditions.checkNotNull(reader);
        this.name = Preconditions.checkNotNull(name);
        this.type = Preconditions.checkNotNull(type);
    }

    SegmentPropertyState(@Nonnull SegmentReader reader, @Nonnull RecordId id, @Nonnull PropertyTemplate template) {
        this(reader, id, template.getName(), template.getType());
    }

    private ListRecord getValueList(Segment segment) {
        RecordId listId = this.getRecordId();
        int size = 1;
        if (this.isArray() && (size = segment.readInt(this.getRecordNumber())) > 0) {
            listId = segment.readRecordId(this.getRecordNumber(), 4);
        }
        return new ListRecord(listId, size);
    }

    Map<String, RecordId> getValueRecords() {
        if (this.getType().tag() == 2) {
            return Collections.emptyMap();
        }
        HashMap<String, RecordId> map = Maps.newHashMap();
        Segment segment = this.getSegment();
        ListRecord values = this.getValueList(segment);
        for (int i = 0; i < values.size(); ++i) {
            RecordId valueId = values.getEntry(i);
            String value = this.reader.readString(valueId);
            map.put(value, valueId);
        }
        return map;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Type<?> getType() {
        return this.type;
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public int count() {
        if (this.isArray()) {
            return this.getSegment().readInt(this.getRecordNumber());
        }
        return 1;
    }

    @Override
    @Nonnull
    public <T> T getValue(Type<T> type) {
        Segment segment = this.getSegment();
        if (this.isArray()) {
            Preconditions.checkState(type.isArray());
            ListRecord values = this.getValueList(segment);
            if (values.size() == 0) {
                return (T)Collections.emptyList();
            }
            if (values.size() == 1) {
                return (T)Collections.singletonList(this.getValue(values.getEntry(0), type.getBaseType()));
            }
            Type<?> base = type.getBaseType();
            ArrayList<?> list = Lists.newArrayListWithCapacity(values.size());
            for (RecordId id : values.getEntries()) {
                list.add(this.getValue(id, base));
            }
            return (T)list;
        }
        RecordId id = this.getRecordId();
        if (type.isArray()) {
            return (T)Collections.singletonList(this.getValue(id, type.getBaseType()));
        }
        return this.getValue(id, type);
    }

    @Override
    public long size() {
        return this.size(0);
    }

    @Override
    @Nonnull
    public <T> T getValue(Type<T> type, int index) {
        Preconditions.checkNotNull(type);
        Preconditions.checkArgument(!type.isArray(), "Type must not be an array type");
        Segment segment = this.getSegment();
        ListRecord values = this.getValueList(segment);
        Preconditions.checkElementIndex(index, values.size());
        return this.getValue(values.getEntry(index), type);
    }

    private <T> T getValue(RecordId id, Type<T> type) {
        if (type == Type.BINARY) {
            return (T)this.reader.readBlob(id);
        }
        String value = this.reader.readString(id);
        if (type == Type.STRING || type == Type.URI || type == Type.DATE || type == Type.NAME || type == Type.PATH || type == Type.REFERENCE || type == Type.WEAKREFERENCE) {
            return (T)value;
        }
        Type<?> base = this.getType();
        if (base.isArray()) {
            base = base.getBaseType();
        }
        Conversions.Converter converter = Conversions.convert(value, base);
        if (type == Type.BOOLEAN) {
            return (T)Boolean.valueOf(converter.toBoolean());
        }
        if (type == Type.DECIMAL) {
            return (T)converter.toDecimal();
        }
        if (type == Type.DOUBLE) {
            return (T)Double.valueOf(converter.toDouble());
        }
        if (type == Type.LONG) {
            return (T)Long.valueOf(converter.toLong());
        }
        throw new UnsupportedOperationException("Unknown type: " + type);
    }

    @Override
    public long size(int index) {
        ListRecord values = this.getValueList(this.getSegment());
        Preconditions.checkElementIndex(index, values.size());
        RecordId entry = values.getEntry(index);
        if (this.getType().equals(Type.BINARY) || this.getType().equals(Type.BINARIES)) {
            return this.reader.readBlob(entry).length();
        }
        return this.getSegment().readLength(entry);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentPropertyState) {
            SegmentPropertyState that = (SegmentPropertyState)object;
            if (!this.type.equals(that.type) || !this.name.equals(that.name)) {
                return false;
            }
            if (this.getRecordId().equals(that.getRecordId())) {
                return true;
            }
        }
        return object instanceof PropertyState && AbstractPropertyState.equal(this, (PropertyState)object);
    }

    @Override
    public int hashCode() {
        return AbstractPropertyState.hashCode(this);
    }

    @Override
    public String toString() {
        return AbstractPropertyState.toString(this);
    }
}

