/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreBuilders;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreBuilder;
import org.apache.jackrabbit.oak.segment.file.FileStoreStatsMBean;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.state.ProxyNodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, name="org.apache.jackrabbit.oak.segment.SegmentNodeStoreFactory", configurationFactory=true, metatype=true, label="Apache Jackrabbit Oak Segment-Tar NodeStore Factory", description="Factory allowing configuration of adjacent instances of NodeStore implementation based on Segment model besides a default SegmentNodeStore in same setup.")
public class SegmentNodeStoreFactory
extends ProxyNodeStore {
    public static final String NAME = "name";
    @Property(label="Role", description="As multiple SegmentNodeStores can be configured, this parameter defines the role of 'this' SegmentNodeStore.")
    public static final String ROLE = "nsProvider.role";
    @Property(label="Directory", description="Directory location used to store the segment tar files. If not specified then looks for framework property 'repository.home' otherwise use a subdirectory with name 'tarmk'")
    public static final String DIRECTORY = "repository.home";
    @Property(label="Mode", description="TarMK mode (64 for memory mapping, 32 for normal file access)")
    public static final String MODE = "tarmk.mode";
    @Property(intValue={256}, label="Maximum Tar File Size (MB)", description="TarMK maximum file size (MB)")
    public static final String SIZE = "tarmk.size";
    @Property(intValue={256}, label="Cache size (MB)", description="Cache size for storing most recently used Segments")
    public static final String CACHE = "cache";
    @Property(boolValue={false}, label="Custom BlobStore", description="Boolean value indicating that a custom BlobStore is to be used. By default large binary content would be stored within segment tar files")
    public static final String CUSTOM_BLOB_STORE = "customBlobStore";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private FileStore store;
    private volatile SegmentNodeStore segmentNodeStore;
    private ComponentContext context;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, target="(&(!(split.blobstore=old))(!(split.blobstore=new)))")
    private volatile BlobStore blobStore;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    private ServiceRegistration storeRegistration;
    private Registration fileStoreStatsMBean;
    private WhiteboardExecutor executor;
    private boolean customBlobStore;
    private String role;

    @Override
    protected SegmentNodeStore getNodeStore() {
        Preconditions.checkState(this.segmentNodeStore != null, "service must be activated when used");
        return this.segmentNodeStore;
    }

    @Activate
    public void activate(ComponentContext context) throws IOException {
        this.context = context;
        this.name = PropertiesUtil.toString(context.getProperties().get(NAME), "SegmentNodeStore instance");
        this.role = this.property(ROLE);
        this.customBlobStore = Boolean.parseBoolean(this.property(CUSTOM_BLOB_STORE)) || this.isSecondaryStoreMode();
        this.log.info("activate: SegmentNodeStore '" + this.role + "' starting.");
        if (this.blobStore == null && this.customBlobStore) {
            this.log.info("BlobStore use enabled. SegmentNodeStore would be initialized when BlobStore would be available");
        } else {
            this.registerNodeStore();
        }
    }

    protected void bindBlobStore(BlobStore blobStore) throws IOException {
        this.blobStore = blobStore;
        this.registerNodeStore();
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        this.blobStore = null;
        this.unregisterNodeStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        this.unregisterNodeStore();
        SegmentNodeStoreFactory segmentNodeStoreFactory = this;
        synchronized (segmentNodeStoreFactory) {
            this.segmentNodeStore = null;
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
        }
    }

    private synchronized void registerNodeStore() throws IOException {
        if (this.registerSegmentStore() && this.role != null) {
            this.registerNodeStoreProvider();
        }
    }

    private boolean isSecondaryStoreMode() {
        return "secondary".equals(this.role);
    }

    private void registerNodeStoreProvider() {
        SegmentNodeStore.SegmentNodeStoreBuilder nodeStoreBuilder = SegmentNodeStoreBuilders.builder(this.store);
        this.segmentNodeStore = nodeStoreBuilder.build();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("role", this.role);
        this.storeRegistration = this.context.getBundleContext().registerService(NodeStoreProvider.class.getName(), (Object)new NodeStoreProvider(){

            @Override
            public NodeStore getNodeStore() {
                return SegmentNodeStoreFactory.this;
            }
        }, props);
        this.log.info("Registered NodeStoreProvider backed by SegmentNodeStore of type '{}'", (Object)this.role);
    }

    private boolean registerSegmentStore() throws IOException {
        if (this.context == null) {
            this.log.info("Component still not activated. Ignoring the initialization call");
            return false;
        }
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        FileStoreBuilder builder = FileStoreBuilder.fileStoreBuilder(this.getDirectory()).withSegmentCacheSize(this.getCacheSize()).withMaxFileSize(this.getMaxFileSize()).withMemoryMapping(this.getMode().equals("64")).withStatisticsProvider(this.statisticsProvider);
        if (this.customBlobStore) {
            this.log.info("Initializing SegmentNodeStore with BlobStore [{}]", (Object)this.blobStore);
            builder.withBlobStore(this.blobStore);
        }
        try {
            this.store = builder.build();
        }
        catch (InvalidFileStoreVersionException e) {
            this.log.error("The segment store data is not compatible with the current version. Please use oak-segment-tar or a different version of oak-segment.");
            return false;
        }
        this.executor = new WhiteboardExecutor();
        this.executor.start(whiteboard);
        this.fileStoreStatsMBean = WhiteboardUtils.registerMBean(whiteboard, FileStoreStatsMBean.class, this.store.getStats(), "FileStoreStats", "FileStore '" + this.role + "' statistics");
        return true;
    }

    private void unregisterNodeStore() {
        if (this.storeRegistration != null) {
            this.storeRegistration.unregister();
            this.storeRegistration = null;
        }
        if (this.fileStoreStatsMBean != null) {
            this.fileStoreStatsMBean.unregister();
            this.fileStoreStatsMBean = null;
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
    }

    private File getBaseDirectory() {
        String directory = this.property(DIRECTORY);
        if (directory != null) {
            return new File(directory);
        }
        if (this.role == null) {
            return new File("tarmk");
        }
        return new File("tarmk-" + this.role);
    }

    private File getDirectory() {
        return new File(this.getBaseDirectory(), "segmentstore");
    }

    private String getMode() {
        String mode = this.property(MODE);
        if (mode != null) {
            return mode;
        }
        return System.getProperty(MODE, System.getProperty("sun.arch.data.model", "32"));
    }

    private String getCacheSizeProperty() {
        String cache = this.property(CACHE);
        if (cache != null) {
            return cache;
        }
        return System.getProperty(CACHE);
    }

    private int getCacheSize() {
        return Integer.parseInt(this.getCacheSizeProperty());
    }

    private String getMaxFileSizeProperty() {
        String size = this.property(SIZE);
        if (size != null) {
            return size;
        }
        return System.getProperty(SIZE, "256");
    }

    private int getMaxFileSize() {
        return Integer.parseInt(this.getMaxFileSizeProperty());
    }

    private String property(String name) {
        return OsgiUtil.lookupConfigurationThenFramework(this.context, name);
    }

    public String toString() {
        return this.name + ": " + this.segmentNodeStore + "[role:" + this.role + "]";
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }
}

