/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.json.JsonObject;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentParser;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.FileStore;

public final class SegmentGraph {
    private SegmentGraph() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSegmentGraph(@Nonnull FileStore.ReadOnlyStore fileStore, @Nonnull OutputStream out, @Nonnull Date epoch, @CheckForNull String pattern) throws Exception {
        Preconditions.checkNotNull(epoch);
        try (PrintWriter writer = new PrintWriter(Preconditions.checkNotNull(out));){
            SegmentNodeState root = Preconditions.checkNotNull(fileStore).getHead();
            Predicate<UUID> filter = pattern == null ? Predicates.alwaysTrue() : SegmentGraph.createRegExpFilter(pattern, fileStore);
            Graph<UUID> segmentGraph = SegmentGraph.parseSegmentGraph(fileStore, filter);
            Graph<UUID> headGraph = SegmentGraph.parseHeadGraph(fileStore.getReader(), root.getRecordId());
            writer.write("nodedef>name VARCHAR, label VARCHAR, type VARCHAR, wid VARCHAR, gc INT, t INT, size INT, head BOOLEAN\n");
            for (UUID uUID : segmentGraph.vertices()) {
                SegmentGraph.writeNode(uUID, writer, headGraph.containsVertex(uUID), epoch, fileStore);
            }
            writer.write("edgedef>node1 VARCHAR, node2 VARCHAR, head BOOLEAN\n");
            for (Map.Entry entry : segmentGraph.edges()) {
                UUID from = (UUID)entry.getKey();
                for (UUID to : (Multiset)entry.getValue()) {
                    if (from.equals(to)) continue;
                    Multiset<UUID> he = headGraph.getEdge(from);
                    boolean inHead = he != null && he.contains(to);
                    writer.write(from + "," + to + "," + inHead + "\n");
                }
            }
        }
    }

    public static Predicate<UUID> createRegExpFilter(@Nonnull String pattern, final @Nonnull SegmentStore store) {
        final Pattern regExp = Pattern.compile(Preconditions.checkNotNull(pattern));
        Preconditions.checkNotNull(store);
        return new Predicate<UUID>(){

            @Override
            public boolean apply(UUID segment) {
                try {
                    String info = SegmentGraph.getSegmentInfo(segment, store);
                    if (info == null) {
                        info = "NULL";
                    }
                    return regExp.matcher(info).matches();
                }
                catch (Exception e) {
                    System.err.println("Error accessing segment " + segment + ": " + e);
                    return false;
                }
            }
        };
    }

    @Nonnull
    public static Graph<UUID> parseSegmentGraph(@Nonnull FileStore.ReadOnlyStore fileStore, @Nonnull Predicate<UUID> filter) throws IOException {
        SegmentNodeState root = Preconditions.checkNotNull(fileStore).getHead();
        HashSet<UUID> roots = Sets.newHashSet(root.getRecordId().asUUID());
        return SegmentGraph.parseSegmentGraph(fileStore, roots, filter, Functions.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeGCGraph(@Nonnull FileStore.ReadOnlyStore fileStore, @Nonnull OutputStream out) throws Exception {
        try (PrintWriter writer = new PrintWriter(Preconditions.checkNotNull(out));){
            Graph<String> gcGraph = SegmentGraph.parseGCGraph(Preconditions.checkNotNull(fileStore));
            writer.write("nodedef>name VARCHAR\n");
            for (String string : gcGraph.vertices()) {
                writer.write(string + "\n");
            }
            writer.write("edgedef>node1 VARCHAR, node2 VARCHAR, weight INT\n");
            for (Map.Entry entry : gcGraph.edges()) {
                String from = (String)entry.getKey();
                Multiset tos = (Multiset)entry.getValue();
                for (String to : tos.elementSet()) {
                    if (from.equals(to) || to.isEmpty()) continue;
                    writer.write(from + "," + to + "," + tos.count(to) + "\n");
                }
            }
        }
    }

    @Nonnull
    public static Graph<String> parseGCGraph(final @Nonnull FileStore.ReadOnlyStore fileStore) throws IOException {
        SegmentNodeState root = Preconditions.checkNotNull(fileStore).getHead();
        HashSet<UUID> roots = Sets.newHashSet(root.getRecordId().asUUID());
        return SegmentGraph.parseSegmentGraph(fileStore, roots, Predicates.alwaysTrue(), new Function<UUID, String>(){

            @Override
            @Nullable
            public String apply(UUID segmentId) {
                Map<String, String> info = new SegmentInfo(segmentId, fileStore).getInfoMap();
                String error = info.get("error");
                if (error != null) {
                    return "Error";
                }
                return info.get("gc");
            }
        });
    }

    @Nonnull
    public static <T> Graph<T> parseSegmentGraph(@Nonnull FileStore.ReadOnlyStore fileStore, @Nonnull Set<UUID> roots, final @Nonnull Predicate<UUID> filter, final @Nonnull Function<UUID, T> map) throws IOException {
        final Graph graph = new Graph();
        Preconditions.checkNotNull(filter);
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull(fileStore).traverseSegmentGraph(Preconditions.checkNotNull(roots), new SegmentGraphVisitor(){

            @Override
            public void accept(@Nonnull UUID from, @CheckForNull UUID to) {
                Object fromT = null;
                Object toT = null;
                if (filter.apply(from)) {
                    fromT = map.apply(from);
                    graph.addVertex(fromT);
                }
                if (to != null && filter.apply(to)) {
                    toT = map.apply(to);
                    graph.addVertex(toT);
                }
                if (fromT != null && toT != null) {
                    graph.addEdge(fromT, toT);
                }
            }
        });
        return graph;
    }

    @Nonnull
    public static Graph<UUID> parseHeadGraph(@Nonnull SegmentReader reader, @Nonnull RecordId root) {
        final Graph<UUID> graph = new Graph<UUID>();
        try {
            new SegmentParser(reader){

                private void addEdge(RecordId from, RecordId to) {
                    graph.addVertex(from.asUUID());
                    graph.addVertex(to.asUUID());
                    graph.addEdge(from.asUUID(), to.asUUID());
                }

                @Override
                protected void onNode(RecordId parentId, RecordId nodeId) {
                    super.onNode(parentId, nodeId);
                    this.addEdge(parentId, nodeId);
                }

                @Override
                protected void onTemplate(RecordId parentId, RecordId templateId) {
                    super.onTemplate(parentId, templateId);
                    this.addEdge(parentId, templateId);
                }

                @Override
                protected void onMap(RecordId parentId, RecordId mapId, MapRecord map) {
                    super.onMap(parentId, mapId, map);
                    this.addEdge(parentId, mapId);
                }

                @Override
                protected void onMapDiff(RecordId parentId, RecordId mapId, MapRecord map) {
                    super.onMapDiff(parentId, mapId, map);
                    this.addEdge(parentId, mapId);
                }

                @Override
                protected void onMapLeaf(RecordId parentId, RecordId mapId, MapRecord map) {
                    super.onMapLeaf(parentId, mapId, map);
                    this.addEdge(parentId, mapId);
                }

                @Override
                protected void onMapBranch(RecordId parentId, RecordId mapId, MapRecord map) {
                    super.onMapBranch(parentId, mapId, map);
                    this.addEdge(parentId, mapId);
                }

                @Override
                protected void onProperty(RecordId parentId, RecordId propertyId, PropertyTemplate template) {
                    super.onProperty(parentId, propertyId, template);
                    this.addEdge(parentId, propertyId);
                }

                @Override
                protected void onValue(RecordId parentId, RecordId valueId, Type<?> type) {
                    super.onValue(parentId, valueId, type);
                    this.addEdge(parentId, valueId);
                }

                @Override
                protected void onBlob(RecordId parentId, RecordId blobId) {
                    super.onBlob(parentId, blobId);
                    this.addEdge(parentId, blobId);
                }

                @Override
                protected void onString(RecordId parentId, RecordId stringId) {
                    super.onString(parentId, stringId);
                    this.addEdge(parentId, stringId);
                }

                @Override
                protected void onList(RecordId parentId, RecordId listId, int count) {
                    super.onList(parentId, listId, count);
                    this.addEdge(parentId, listId);
                }

                @Override
                protected void onListBucket(RecordId parentId, RecordId listId, int index, int count, int capacity) {
                    super.onListBucket(parentId, listId, index, count, capacity);
                    this.addEdge(parentId, listId);
                }
            }.parseNode(Preconditions.checkNotNull(root));
        }
        catch (SegmentNotFoundException e) {
            System.err.println("Error head graph parsing: " + e);
        }
        return graph;
    }

    private static void writeNode(UUID node, PrintWriter writer, boolean inHead, Date epoch, SegmentStore store) {
        SegmentInfo segmentInfo = new SegmentInfo(node, store);
        if (!segmentInfo.isData()) {
            writer.write(node + ",b,bulk,b,-1,-1," + inHead + "\n");
        } else {
            Map<String, String> sInfo = segmentInfo.getInfoMap();
            String error = sInfo.get("error");
            if (error != null) {
                writer.write(node + "," + SegmentGraph.firstLine(error) + ",error,e,-1,-1," + inHead + "\n");
            } else {
                long t = SegmentGraph.asLong(sInfo.get("t"));
                long ts = t - epoch.getTime();
                Preconditions.checkArgument(ts >= Integer.MIN_VALUE && ts <= Integer.MAX_VALUE, "Time stamp (" + new Date(t) + ") not in epoch (" + new Date(epoch.getTime() + Integer.MIN_VALUE) + " - " + new Date(epoch.getTime() + Integer.MAX_VALUE) + ")");
                writer.write(node + "," + sInfo.get("sno") + ",data" + "," + sInfo.get("wid") + "," + sInfo.get("gc") + "," + ts + "," + sInfo.get("size") + "," + inHead + "\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String firstLine(String string) {
        BufferedReader reader = new BufferedReader(new StringReader(string));
        try {
            String string2 = reader.readLine();
            return string2;
        }
        catch (IOException e) {
            String string3 = string;
            return string3;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private static long asLong(String string) {
        return Long.valueOf(string);
    }

    private static String getSegmentInfo(UUID segment, SegmentStore store) {
        return new SegmentInfo(segment, store).getInfo();
    }

    private static class SegmentInfo {
        private final UUID uuid;
        private final SegmentStore store;
        private SegmentId id;

        SegmentInfo(UUID uuid, SegmentStore store) {
            this.uuid = uuid;
            this.store = store;
        }

        boolean isData() {
            return SegmentId.isDataSegmentId(this.uuid.getLeastSignificantBits());
        }

        SegmentId getSegmentId() {
            if (this.id == null) {
                long msb = this.uuid.getMostSignificantBits();
                long lsb = this.uuid.getLeastSignificantBits();
                this.id = this.store.newSegmentId(msb, lsb);
            }
            return this.id;
        }

        String getInfo() {
            if (this.isData()) {
                return this.getSegmentId().getSegment().getSegmentInfo();
            }
            return null;
        }

        Map<String, String> getInfoMap() {
            try {
                HashMap<String, String> infoMap = Maps.newHashMap();
                String info = this.getInfo();
                if (info != null) {
                    JsopTokenizer tokenizer = new JsopTokenizer(info);
                    tokenizer.read(123);
                    infoMap.putAll(JsonObject.create(tokenizer).getProperties());
                }
                SegmentId segmentId = this.getSegmentId();
                Segment segment = segmentId.getSegment();
                infoMap.put("size", String.valueOf(segment.size()));
                infoMap.put("gc", String.valueOf(segmentId.getGcGeneration()));
                return infoMap;
            }
            catch (SegmentNotFoundException e) {
                return Collections.singletonMap("error", Throwables.getStackTraceAsString(e));
            }
        }
    }

    public static class Graph<T> {
        private final Set<T> vertices = Sets.newHashSet();
        private final Map<T, Multiset<T>> edges = Maps.newHashMap();

        private void addVertex(T vertex) {
            this.vertices.add(vertex);
        }

        private void addEdge(T from, T to) {
            Multiset<T> tos = this.edges.get(from);
            if (tos == null) {
                tos = HashMultiset.create();
                this.edges.put(from, tos);
            }
            tos.add(to);
        }

        public Iterable<T> vertices() {
            return this.vertices;
        }

        public boolean containsVertex(T vertex) {
            return this.vertices.contains(vertex);
        }

        public Set<Map.Entry<T, Multiset<T>>> edges() {
            return this.edges.entrySet();
        }

        public Multiset<T> getEdge(T from) {
            return this.edges.get(from);
        }
    }

    public static interface SegmentGraphVisitor {
        public void accept(@Nonnull UUID var1, @CheckForNull UUID var2);
    }
}

