/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import javax.jcr.Value;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.oak.api.Descriptors;
import org.apache.jackrabbit.oak.plugins.identifier.ClusterRepositoryInfo;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

class SegmentDiscoveryLiteDescriptors
implements Descriptors {
    private static final String OAK_DISCOVERYLITE_CLUSTERVIEW = "oak.discoverylite.clusterview";
    private final SimpleValueFactory factory = new SimpleValueFactory();
    private final NodeStore store;

    SegmentDiscoveryLiteDescriptors(NodeStore store) {
        this.store = store;
    }

    @Override
    public String[] getKeys() {
        return new String[]{OAK_DISCOVERYLITE_CLUSTERVIEW};
    }

    @Override
    public boolean isStandardDescriptor(String key) {
        return OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
    }

    @Override
    public boolean isSingleValueDescriptor(String key) {
        return OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key);
    }

    @Override
    public Value getValue(String key) {
        if (!OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
            return null;
        }
        return this.factory.createValue(this.getClusterViewAsDescriptorValue());
    }

    @Override
    public Value[] getValues(String key) {
        if (!OAK_DISCOVERYLITE_CLUSTERVIEW.equals(key)) {
            return null;
        }
        return new Value[]{this.getValue(key)};
    }

    private String getClusterViewAsDescriptorValue() {
        String clusterId = ClusterRepositoryInfo.getOrCreateId(this.store);
        return "{\"seq\":1,\"final\":true,\"me\":1,\"id\":\"" + clusterId + "\",\"active\":[1],\"deactivating\":[],\"inactive\":[]}";
    }
}

