/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Date;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.AbstractCheckpointMBean;

public class SegmentCheckpointMBean
extends AbstractCheckpointMBean {
    private final SegmentNodeStore store;

    public SegmentCheckpointMBean(SegmentNodeStore store) {
        this.store = store;
    }

    @Override
    protected void collectCheckpoints(TabularDataSupport tab) throws OpenDataException {
        for (ChildNodeEntry childNodeEntry : this.store.getCheckpoints().getChildNodeEntries()) {
            String id = childNodeEntry.getName();
            NodeState checkpoint = childNodeEntry.getNodeState();
            String created = SegmentCheckpointMBean.getDate(checkpoint, "created");
            String expires = SegmentCheckpointMBean.getDate(checkpoint, "timestamp");
            tab.put(id, this.toCompositeData(id, created, expires, this.store.checkpointInfo(id)));
        }
    }

    private static String getDate(NodeState checkpoint, String name) {
        PropertyState p = checkpoint.getProperty(name);
        if (p == null) {
            return "NA";
        }
        return new Date(p.getValue(Type.LONG)).toString();
    }

    @Override
    public String createCheckpoint(long lifetime) {
        return this.store.checkpoint(lifetime);
    }

    @Override
    public boolean releaseCheckpoint(String checkpoint) {
        return this.store.release(checkpoint);
    }
}

