/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Monitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.SegmentTracker;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;

public class SegmentBufferWriterPool
implements WriteOperationHandler {
    private final Monitor poolMonitor = new Monitor(true);
    private final Map<Object, SegmentBufferWriter> writers = Maps.newHashMap();
    private final Set<SegmentBufferWriter> borrowed = Sets.newHashSet();
    private final Set<SegmentBufferWriter> disposed = Sets.newHashSet();
    @Nonnull
    private final SegmentStore store;
    @Nonnull
    private final SegmentTracker tracker;
    @Nonnull
    private final SegmentReader reader;
    @Nonnull
    private final Supplier<Integer> gcGeneration;
    @Nonnull
    private final String wid;
    private short writerId = (short)-1;

    public SegmentBufferWriterPool(@Nonnull SegmentStore store, @Nonnull SegmentTracker tracker, @Nonnull SegmentReader reader, @Nonnull String wid, @Nonnull Supplier<Integer> gcGeneration) {
        this.store = Preconditions.checkNotNull(store);
        this.tracker = Preconditions.checkNotNull(tracker);
        this.reader = Preconditions.checkNotNull(reader);
        this.wid = Preconditions.checkNotNull(wid);
        this.gcGeneration = Preconditions.checkNotNull(gcGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordId execute(WriteOperationHandler.WriteOperation writeOperation) throws IOException {
        SegmentBufferWriter writer = this.borrowWriter(Thread.currentThread());
        try {
            RecordId recordId = writeOperation.execute(writer);
            return recordId;
        }
        finally {
            this.returnWriter(Thread.currentThread(), writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        ArrayList<SegmentBufferWriter> toFlush = Lists.newArrayList();
        ArrayList<SegmentBufferWriter> toReturn = Lists.newArrayList();
        this.poolMonitor.enter();
        try {
            toFlush.addAll(this.writers.values());
            this.writers.clear();
            toReturn.addAll(this.borrowed);
            this.borrowed.clear();
        }
        finally {
            this.poolMonitor.leave();
        }
        if (SegmentBufferWriterPool.safeEnterWhen(this.poolMonitor, this.allReturned(toReturn))) {
            try {
                toFlush.addAll(toReturn);
                this.disposed.removeAll(toReturn);
            }
            finally {
                this.poolMonitor.leave();
            }
        }
        for (SegmentBufferWriter writer : toFlush) {
            writer.flush();
        }
    }

    @Nonnull
    private Monitor.Guard allReturned(final List<SegmentBufferWriter> toReturn) {
        return new Monitor.Guard(this.poolMonitor){

            @Override
            public boolean isSatisfied() {
                return SegmentBufferWriterPool.this.disposed.containsAll(toReturn);
            }
        };
    }

    private static boolean safeEnterWhen(Monitor monitor, Monitor.Guard guard) {
        try {
            monitor.enterWhen(guard);
            return true;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentBufferWriter borrowWriter(Object key) {
        this.poolMonitor.enter();
        try {
            SegmentBufferWriter writer = this.writers.remove(key);
            if (writer == null) {
                writer = new SegmentBufferWriter(this.store, this.tracker, this.reader, this.getWriterId(this.wid), this.gcGeneration.get());
            } else if (writer.getGeneration() != this.gcGeneration.get().intValue()) {
                this.disposed.add(writer);
                writer = new SegmentBufferWriter(this.store, this.tracker, this.reader, this.getWriterId(this.wid), this.gcGeneration.get());
            }
            this.borrowed.add(writer);
            SegmentBufferWriter segmentBufferWriter = writer;
            return segmentBufferWriter;
        }
        finally {
            this.poolMonitor.leave();
        }
    }

    private void returnWriter(Object key, SegmentBufferWriter writer) {
        this.poolMonitor.enter();
        try {
            if (this.borrowed.remove(writer)) {
                Preconditions.checkState(this.writers.put(key, writer) == null);
            } else {
                this.disposed.add(writer);
            }
        }
        finally {
            this.poolMonitor.leave();
        }
    }

    private String getWriterId(String wid) {
        this.writerId = (short)(this.writerId + 1);
        if (this.writerId > 9999) {
            this.writerId = 0;
        }
        if (this.writerId < 10) {
            return wid + ".000" + this.writerId;
        }
        if (this.writerId < 100) {
            return wid + ".00" + this.writerId;
        }
        if (this.writerId < 1000) {
            return wid + ".0" + this.writerId;
        }
        return wid + "." + this.writerId;
    }
}

