/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.oak.segment.RecordEntry;
import org.apache.jackrabbit.oak.segment.RecordNumbers;
import org.apache.jackrabbit.oak.segment.RecordType;

class RecordNumbersIterator
implements Iterator<RecordNumbers.Entry> {
    private final Iterator<Map.Entry<Integer, RecordEntry>> iterator;

    RecordNumbersIterator(Iterator<Map.Entry<Integer, RecordEntry>> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public RecordNumbers.Entry next() {
        return new Entry(this.iterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class Entry
    implements RecordNumbers.Entry {
        private final Map.Entry<Integer, RecordEntry> entry;

        public Entry(Map.Entry<Integer, RecordEntry> entry) {
            this.entry = entry;
        }

        @Override
        public int getRecordNumber() {
            return this.entry.getKey();
        }

        @Override
        public int getOffset() {
            return this.entry.getValue().getOffset();
        }

        @Override
        public RecordType getType() {
            return this.entry.getValue().getType();
        }
    }
}

