/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheStats;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;

public class RecordCacheStats
extends AnnotatedStandardMBean
implements CacheStatsMBean {
    @Nonnull
    private final String name;
    @Nonnull
    private final Supplier<CacheStats> stats;
    @Nonnull
    private final Supplier<Long> elementCount;
    private CacheStats lastSnapshot;

    public RecordCacheStats(@Nonnull String name, @Nonnull Supplier<CacheStats> stats, @Nonnull Supplier<Long> elementCount) {
        super(CacheStatsMBean.class);
        this.name = Preconditions.checkNotNull(name);
        this.stats = Preconditions.checkNotNull(stats);
        this.elementCount = Preconditions.checkNotNull(elementCount);
        this.lastSnapshot = stats.get();
    }

    private CacheStats stats() {
        return this.stats.get().minus(this.lastSnapshot);
    }

    @Override
    public synchronized void resetStats() {
        this.lastSnapshot = this.stats.get();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public long getRequestCount() {
        return this.stats().requestCount();
    }

    @Override
    public long getHitCount() {
        return this.stats().hitCount();
    }

    @Override
    public double getHitRate() {
        return this.stats().hitRate();
    }

    @Override
    public long getMissCount() {
        return this.stats().missCount();
    }

    @Override
    public double getMissRate() {
        return this.stats().missRate();
    }

    @Override
    public long getLoadCount() {
        return this.stats().loadCount();
    }

    @Override
    public long getLoadSuccessCount() {
        return this.stats().loadSuccessCount();
    }

    @Override
    public long getLoadExceptionCount() {
        return this.stats().loadExceptionCount();
    }

    @Override
    public double getLoadExceptionRate() {
        return this.stats().loadExceptionRate();
    }

    @Override
    public long getTotalLoadTime() {
        return this.stats().totalLoadTime();
    }

    @Override
    public double getAverageLoadPenalty() {
        return this.stats().averageLoadPenalty();
    }

    @Override
    public long getEvictionCount() {
        return this.stats().evictionCount();
    }

    @Override
    public long getElementCount() {
        return this.elementCount.get();
    }

    @Override
    public long getMaxTotalWeight() {
        return -1L;
    }

    @Override
    public long estimateCurrentWeight() {
        return -1L;
    }

    @Override
    public String cacheInfoAsString() {
        return Objects.toStringHelper("CacheStats(" + this.name + ")").add("hitCount", this.getHitCount()).add("hitRate", String.format("%1.2f", this.getHitRate())).add("missCount", this.getMissCount()).add("missRate", String.format("%1.2f", this.getMissRate())).add("requestCount", this.getRequestCount()).add("loadCount", this.getLoadCount()).add("loadSuccessCount", this.getLoadSuccessCount()).add("loadExceptionCount", this.getLoadExceptionCount()).add("totalLoadTime", String.format("%d s", TimeUnit.NANOSECONDS.toSeconds(this.getTotalLoadTime()))).add("averageLoadPenalty ", String.format("%1.2f ns", this.getAverageLoadPenalty())).add("evictionCount", this.getEvictionCount()).add("elementCount", this.getElementCount()).add("totalWeight", IOUtils.humanReadableByteCount(this.estimateCurrentWeight())).add("maxWeight", IOUtils.humanReadableByteCount(this.getMaxTotalWeight())).toString();
    }
}

