/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.segment.RecordEntry;
import org.apache.jackrabbit.oak.segment.RecordNumbers;
import org.apache.jackrabbit.oak.segment.RecordNumbersIterator;
import org.apache.jackrabbit.oak.segment.RecordType;

class MutableRecordNumbers
implements RecordNumbers {
    private final Object lock = new Object();
    private final Map<Integer, RecordEntry> records = Maps.newLinkedHashMap();

    MutableRecordNumbers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOffset(int recordNumber) {
        RecordEntry entry = this.records.get(recordNumber);
        if (entry != null) {
            return entry.getOffset();
        }
        Object object = this.lock;
        synchronized (object) {
            entry = this.records.get(recordNumber);
            if (entry != null) {
                return entry.getOffset();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<RecordNumbers.Entry> iterator() {
        LinkedHashMap<Integer, RecordEntry> recordNumbers;
        Object object = this.lock;
        synchronized (object) {
            recordNumbers = Maps.newLinkedHashMap(this.records);
        }
        return new RecordNumbersIterator(recordNumbers.entrySet().iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.records.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addRecord(RecordType type, int offset) {
        int recordNumber;
        Object object = this.lock;
        synchronized (object) {
            recordNumber = this.records.size();
            this.records.put(recordNumber, new RecordEntry(type, offset));
        }
        return recordNumber;
    }
}

