/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.MapEntry;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class MapRecord
extends Record {
    private static final int M = -554899859;
    private static final int A = 11;
    static final long HASH_MASK = 0xFFFFFFFFL;
    @Nonnull
    private final SegmentReader reader;
    protected static final int BITS_PER_LEVEL = 5;
    protected static final int BUCKETS_PER_LEVEL = 32;
    protected static final int MAX_NUMBER_OF_LEVELS = 7;
    protected static final int LEVEL_BITS = Integer.numberOfTrailingZeros(Integer.highestOneBit(7) << 1);
    protected static final int SIZE_BITS = 32 - LEVEL_BITS;
    protected static final int MAX_SIZE = (1 << SIZE_BITS) - 1;

    static int getHash(String name) {
        return (name.hashCode() ^ 0xDEECE66D) * -554899859 + 11;
    }

    MapRecord(@Nonnull SegmentReader reader, @Nonnull RecordId id) {
        super(id);
        this.reader = Preconditions.checkNotNull(reader);
    }

    boolean isLeaf() {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getRecordNumber());
        if (MapRecord.isDiff(head)) {
            RecordId base = segment.readRecordId(this.getRecordNumber(), 8, 2);
            return this.reader.readMap(base).isLeaf();
        }
        return !MapRecord.isBranch(head);
    }

    public boolean isDiff() {
        return MapRecord.isDiff(this.getSegment().readInt(this.getRecordNumber()));
    }

    MapRecord[] getBuckets() {
        Segment segment = this.getSegment();
        MapRecord[] buckets = new MapRecord[32];
        int bitmap = segment.readInt(this.getRecordNumber(), 4);
        int ids = 0;
        for (int i = 0; i < 32; ++i) {
            buckets[i] = (bitmap & 1 << i) != 0 ? this.reader.readMap(segment.readRecordId(this.getRecordNumber(), 8, ids++)) : null;
        }
        return buckets;
    }

    private List<MapRecord> getBucketList(Segment segment) {
        ArrayList<MapRecord> buckets = Lists.newArrayListWithCapacity(32);
        int bitmap = segment.readInt(this.getRecordNumber(), 4);
        int ids = 0;
        for (int i = 0; i < 32; ++i) {
            if ((bitmap & 1 << i) == 0) continue;
            RecordId id = segment.readRecordId(this.getRecordNumber(), 8, ids++);
            buckets.add(this.reader.readMap(id));
        }
        return buckets;
    }

    int size() {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getRecordNumber());
        if (MapRecord.isDiff(head)) {
            RecordId base = segment.readRecordId(this.getRecordNumber(), 8, 2);
            return this.reader.readMap(base).size();
        }
        return MapRecord.getSize(head);
    }

    MapEntry getEntry(String name) {
        Preconditions.checkNotNull(name);
        int hash = MapRecord.getHash(name);
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getRecordNumber());
        if (MapRecord.isDiff(head)) {
            RecordId key;
            if (hash == segment.readInt(this.getRecordNumber(), 4) && name.equals(this.reader.readString(key = segment.readRecordId(this.getRecordNumber(), 8)))) {
                RecordId value = segment.readRecordId(this.getRecordNumber(), 8, 1);
                return new MapEntry(this.reader, name, key, value);
            }
            RecordId base = segment.readRecordId(this.getRecordNumber(), 8, 2);
            return this.reader.readMap(base).getEntry(name);
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return null;
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            int mask;
            int shift;
            int index;
            int bit;
            int bitmap = segment.readInt(this.getRecordNumber(), 4);
            if ((bitmap & (bit = 1 << (index = hash >> (shift = 32 - (level + 1) * 5) & (mask = 31)))) != 0) {
                int ids = Integer.bitCount(bitmap & bit - 1);
                RecordId id = segment.readRecordId(this.getRecordNumber(), 8, ids);
                return this.reader.readMap(id).getEntry(name);
            }
            return null;
        }
        int shift = 32 - level * 5;
        long mask = -1L << shift;
        long h = (long)hash & 0xFFFFFFFFL;
        int p = 0;
        long pH = h & mask;
        int q = size - 1;
        long qH = pH | mask ^ 0xFFFFFFFFFFFFFFFFL;
        while (p <= q) {
            assert (pH <= qH);
            int i = p + (int)((long)(q - p) * (h - pH) / (qH - pH));
            assert (p <= i && i <= q);
            long iH = (long)segment.readInt(this.getRecordNumber(), 4 + i * 4) & 0xFFFFFFFFL;
            int diff = Long.valueOf(iH).compareTo(h);
            if (diff == 0) {
                RecordId keyId = segment.readRecordId(this.getRecordNumber(), 4 + size * 4, i * 2);
                RecordId valueId = segment.readRecordId(this.getRecordNumber(), 4 + size * 4, i * 2 + 1);
                diff = this.reader.readString(keyId).compareTo(name);
                if (diff == 0) {
                    return new MapEntry(this.reader, name, keyId, valueId);
                }
            }
            if (diff < 0) {
                p = i + 1;
                pH = iH;
                continue;
            }
            q = i - 1;
            qH = iH;
        }
        return null;
    }

    private RecordId getValue(int hash, RecordId key) {
        Preconditions.checkNotNull(key);
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getRecordNumber());
        if (MapRecord.isDiff(head)) {
            if (hash == segment.readInt(this.getRecordNumber(), 4) && key.equals(segment.readRecordId(this.getRecordNumber(), 8))) {
                return segment.readRecordId(this.getRecordNumber(), 8, 1);
            }
            RecordId base = segment.readRecordId(this.getRecordNumber(), 8, 2);
            return this.reader.readMap(base).getValue(hash, key);
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return null;
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            int mask;
            int shift;
            int index;
            int bit;
            int bitmap = segment.readInt(this.getRecordNumber(), 4);
            if ((bitmap & (bit = 1 << (index = hash >> (shift = 32 - (level + 1) * 5) & (mask = 31)))) != 0) {
                int ids = Integer.bitCount(bitmap & bit - 1);
                RecordId id = segment.readRecordId(this.getRecordNumber(), 8, ids);
                return this.reader.readMap(id).getValue(hash, key);
            }
            return null;
        }
        Long h = (long)hash & 0xFFFFFFFFL;
        for (int i = 0; i < size; ++i) {
            int diff = h.compareTo((long)segment.readInt(this.getRecordNumber(), 4 + i * 4) & 0xFFFFFFFFL);
            if (diff > 0) {
                return null;
            }
            if (diff != 0 || !key.equals(segment.readRecordId(this.getRecordNumber(), 4 + size * 4, i * 2))) continue;
            return segment.readRecordId(this.getRecordNumber(), 4 + size * 4, i * 2 + 1);
        }
        return null;
    }

    Iterable<String> getKeys() {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getRecordNumber());
        if (MapRecord.isDiff(head)) {
            RecordId base = segment.readRecordId(this.getRecordNumber(), 8, 2);
            return this.reader.readMap(base).getKeys();
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return Collections.emptyList();
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            List<MapRecord> buckets = this.getBucketList(segment);
            ArrayList<Iterable<String>> keys = Lists.newArrayListWithCapacity(buckets.size());
            for (MapRecord bucket : buckets) {
                keys.add(bucket.getKeys());
            }
            return Iterables.concat(keys);
        }
        RecordId[] ids = new RecordId[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = segment.readRecordId(this.getRecordNumber(), 4 + size * 4, i * 2);
        }
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = this.reader.readString(ids[i]);
        }
        return Arrays.asList(keys);
    }

    Iterable<MapEntry> getEntries() {
        return this.getEntries(null, null);
    }

    private Iterable<MapEntry> getEntries(final RecordId diffKey, final RecordId diffValue) {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getRecordNumber());
        if (MapRecord.isDiff(head)) {
            RecordId key = segment.readRecordId(this.getRecordNumber(), 8);
            RecordId value = segment.readRecordId(this.getRecordNumber(), 8, 1);
            RecordId base = segment.readRecordId(this.getRecordNumber(), 8, 2);
            return this.reader.readMap(base).getEntries(key, value);
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return Collections.emptyList();
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            List<MapRecord> buckets = this.getBucketList(segment);
            ArrayList<1> entries = Lists.newArrayListWithCapacity(buckets.size());
            for (final MapRecord bucket : buckets) {
                entries.add(new Iterable<MapEntry>(){

                    @Override
                    public Iterator<MapEntry> iterator() {
                        return bucket.getEntries(diffKey, diffValue).iterator();
                    }
                });
            }
            return Iterables.concat(entries);
        }
        MapEntry[] entries = new MapEntry[size];
        for (int i = 0; i < size; ++i) {
            RecordId key = segment.readRecordId(this.getRecordNumber(), 4 + size * 4, i * 2);
            RecordId value = key.equals(diffKey) ? diffValue : segment.readRecordId(this.getRecordNumber(), 4 + size * 4, i * 2 + 1);
            String name = this.reader.readString(key);
            entries[i] = new MapEntry(this.reader, name, key, value);
        }
        return Arrays.asList(entries);
    }

    boolean compare(MapRecord before, final NodeStateDiff diff) {
        if (Record.fastEquals((Object)this, (Object)before)) {
            return true;
        }
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getRecordNumber());
        if (MapRecord.isDiff(head)) {
            int hash = segment.readInt(this.getRecordNumber(), 4);
            RecordId keyId = segment.readRecordId(this.getRecordNumber(), 8);
            final String key = this.reader.readString(keyId);
            RecordId value = segment.readRecordId(this.getRecordNumber(), 8, 1);
            MapRecord base = this.reader.readMap(segment.readRecordId(this.getRecordNumber(), 8, 2));
            boolean rv = base.compare(before, new DefaultNodeStateDiff(){

                @Override
                public boolean childNodeAdded(String name, NodeState after) {
                    return name.equals(key) || diff.childNodeAdded(name, after);
                }

                @Override
                public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                    return name.equals(key) || diff.childNodeChanged(name, before, after);
                }

                @Override
                public boolean childNodeDeleted(String name, NodeState before) {
                    return diff.childNodeDeleted(name, before);
                }
            });
            if (rv) {
                MapEntry beforeEntry = before.getEntry(key);
                if (beforeEntry == null) {
                    rv = diff.childNodeAdded(key, this.reader.readNode(value));
                } else if (!value.equals(beforeEntry.getValue())) {
                    rv = diff.childNodeChanged(key, beforeEntry.getNodeState(), this.reader.readNode(value));
                }
            }
            return rv;
        }
        Segment beforeSegment = before.getSegment();
        int beforeHead = beforeSegment.readInt(before.getRecordNumber());
        if (MapRecord.isDiff(beforeHead)) {
            int hash = beforeSegment.readInt(before.getRecordNumber(), 4);
            RecordId keyId = beforeSegment.readRecordId(before.getRecordNumber(), 8);
            final String key = this.reader.readString(keyId);
            RecordId value = beforeSegment.readRecordId(before.getRecordNumber(), 8, 1);
            MapRecord base = this.reader.readMap(beforeSegment.readRecordId(before.getRecordNumber(), 8, 2));
            boolean rv = this.compare(base, new DefaultNodeStateDiff(){

                @Override
                public boolean childNodeAdded(String name, NodeState after) {
                    return diff.childNodeAdded(name, after);
                }

                @Override
                public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                    return name.equals(key) || diff.childNodeChanged(name, before, after);
                }

                @Override
                public boolean childNodeDeleted(String name, NodeState before) {
                    return name.equals(key) || diff.childNodeDeleted(name, before);
                }
            });
            if (rv) {
                MapEntry afterEntry = this.getEntry(key);
                if (afterEntry == null) {
                    rv = diff.childNodeDeleted(key, this.reader.readNode(value));
                } else if (!value.equals(afterEntry.getValue())) {
                    rv = diff.childNodeChanged(key, this.reader.readNode(value), afterEntry.getNodeState());
                }
            }
            return rv;
        }
        if (MapRecord.isBranch(beforeHead) && MapRecord.isBranch(head)) {
            return MapRecord.compareBranch(before, this, diff);
        }
        Iterator<MapEntry> beforeEntries = before.getEntries().iterator();
        Iterator<MapEntry> afterEntries = this.getEntries().iterator();
        MapEntry beforeEntry = MapRecord.nextOrNull(beforeEntries);
        MapEntry afterEntry = MapRecord.nextOrNull(afterEntries);
        while (beforeEntry != null || afterEntry != null) {
            int d = MapRecord.compare(beforeEntry, afterEntry);
            if (d < 0) {
                if (!diff.childNodeDeleted(beforeEntry.getName(), beforeEntry.getNodeState())) {
                    return false;
                }
                beforeEntry = MapRecord.nextOrNull(beforeEntries);
                continue;
            }
            if (d == 0) {
                if (!beforeEntry.getValue().equals(afterEntry.getValue()) && !diff.childNodeChanged(beforeEntry.getName(), beforeEntry.getNodeState(), afterEntry.getNodeState())) {
                    return false;
                }
                beforeEntry = MapRecord.nextOrNull(beforeEntries);
                afterEntry = MapRecord.nextOrNull(afterEntries);
                continue;
            }
            if (!diff.childNodeAdded(afterEntry.getName(), afterEntry.getNodeState())) {
                return false;
            }
            afterEntry = MapRecord.nextOrNull(afterEntries);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder = null;
        for (MapEntry entry : this.getEntries()) {
            if (builder == null) {
                builder = new StringBuilder("{ ");
            } else {
                builder.append(", ");
            }
            builder.append(entry);
        }
        if (builder == null) {
            return "{}";
        }
        builder.append(" }");
        return builder.toString();
    }

    private static boolean compareBranch(MapRecord before, MapRecord after, NodeStateDiff diff) {
        MapRecord[] beforeBuckets = before.getBuckets();
        MapRecord[] afterBuckets = after.getBuckets();
        for (int i = 0; i < 32; ++i) {
            MapRecord bucket;
            if (Objects.equal(beforeBuckets[i], afterBuckets[i])) continue;
            if (beforeBuckets[i] == null) {
                bucket = afterBuckets[i];
                for (MapEntry entry : bucket.getEntries()) {
                    if (diff.childNodeAdded(entry.getName(), entry.getNodeState())) continue;
                    return false;
                }
                continue;
            }
            if (afterBuckets[i] == null) {
                bucket = beforeBuckets[i];
                for (MapEntry entry : bucket.getEntries()) {
                    if (diff.childNodeDeleted(entry.getName(), entry.getNodeState())) continue;
                    return false;
                }
                continue;
            }
            MapRecord afterBucket = afterBuckets[i];
            MapRecord beforeBucket = beforeBuckets[i];
            if (afterBucket.compare(beforeBucket, diff)) continue;
            return false;
        }
        return true;
    }

    private static int getSize(int head) {
        return head & (1 << SIZE_BITS) - 1;
    }

    private static int getLevel(int head) {
        return head >>> SIZE_BITS;
    }

    private static boolean isDiff(int head) {
        return head == -1;
    }

    private static boolean isBranch(int head) {
        return MapRecord.isBranch(MapRecord.getSize(head), MapRecord.getLevel(head));
    }

    private static boolean isBranch(int size, int level) {
        return size > 32 && level < 7;
    }

    private static int compare(MapEntry before, MapEntry after) {
        if (before == null) {
            return 1;
        }
        if (after == null) {
            return -1;
        }
        return ComparisonChain.start().compare((long)before.getHash() & 0xFFFFFFFFL, (long)after.getHash() & 0xFFFFFFFFL).compare((Comparable<?>)((Object)before.getName()), (Comparable<?>)((Object)after.getName())).result();
    }

    private static MapEntry nextOrNull(Iterator<MapEntry> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

