/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.oak.segment.RecordEntry;
import org.apache.jackrabbit.oak.segment.RecordNumbers;
import org.apache.jackrabbit.oak.segment.RecordNumbersIterator;

class ImmutableRecordNumbers
implements RecordNumbers {
    private final Map<Integer, RecordEntry> records;

    ImmutableRecordNumbers(Map<Integer, RecordEntry> records) {
        this.records = Maps.newLinkedHashMap(records);
    }

    @Override
    public int getOffset(int recordNumber) {
        RecordEntry entry = this.records.get(recordNumber);
        if (entry == null) {
            return -1;
        }
        return entry.getOffset();
    }

    @Override
    public Iterator<RecordNumbers.Entry> iterator() {
        return new RecordNumbersIterator(this.records.entrySet().iterator());
    }
}

