/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Function;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.segment.BinaryReferenceConsumer;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.file.FileStore;

public final class BinaryReferences {
    private BinaryReferences() {
    }

    public static BinaryReferenceConsumer newDiscardBinaryReferenceConsumer() {
        return new BinaryReferenceConsumer(){

            @Override
            public void consume(int generation, UUID segmentId, String binaryReference) {
            }
        };
    }

    @Nonnull
    public static String newReference(@Nonnull String blobId) {
        return "I" + blobId;
    }

    @Nonnull
    public static String newReference(@Nonnull RecordId blobId) {
        return "R" + blobId.toString10();
    }

    @Nonnull
    public static Function<String, String> newReferenceReader(final @Nonnull FileStore fileStore) {
        return new Function<String, String>(){

            @Override
            @Nullable
            public String apply(String reference) {
                if (reference.charAt(0) == 'I') {
                    return reference.substring(1);
                }
                return fileStore.getReader().readString(RecordId.fromString(fileStore, reference.substring(1)));
            }
        };
    }
}

