/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.SecureRandom;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;

@Component(metatype=true, label="Apache Jackrabbit Oak Random Authorizable Node Name", description="Generates a random name for the authorizable node.", policy=ConfigurationPolicy.REQUIRE)
@Service(value={AuthorizableNodeName.class})
public class RandomAuthorizableNodeName
implements AuthorizableNodeName {
    private static final char[] VALID_CHARS;
    private static final String PARAM_LENGTH = "length";
    public static final int DEFAULT_LENGTH = 21;
    @Property(name="length", label="Name Length", description="Length of the generated node name.", intValue={21})
    private int length = 21;

    @Override
    @Nonnull
    public String generateNodeName(@Nonnull String authorizableId) {
        SecureRandom random = new SecureRandom();
        char[] chars = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            chars[i] = VALID_CHARS[random.nextInt(VALID_CHARS.length)];
        }
        return new String(chars);
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.length = PropertiesUtil.toInteger(properties.get(PARAM_LENGTH), 21);
    }

    static {
        char i;
        StringBuilder sb = new StringBuilder();
        for (i = 'a'; i <= 'z'; i = (char)(i + '\u0001')) {
            sb.append(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            sb.append(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            sb.append(i);
        }
        sb.append("-_");
        VALID_CHARS = sb.toString().toCharArray();
    }
}

