/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class MembershipWriter {
    private int membershipSizeThreshold = 100;

    public int getMembershipSizeThreshold() {
        return this.membershipSizeThreshold;
    }

    public void setMembershipSizeThreshold(int membershipSizeThreshold) {
        this.membershipSizeThreshold = membershipSizeThreshold;
    }

    boolean addMember(Tree groupTree, String memberContentId) throws RepositoryException {
        HashMap<String, String> m = Maps.newHashMapWithExpectedSize(1);
        m.put(memberContentId, "-");
        return this.addMembers(groupTree, m).isEmpty();
    }

    Set<String> addMembers(@Nonnull Tree groupTree, @Nonnull Map<String, String> memberIds) throws RepositoryException {
        Tree membersList = groupTree.getChild("rep:membersList");
        Iterator<Tree> trees = Iterators.concat(Iterators.singletonIterator(groupTree), membersList.getChildren().iterator());
        HashSet<String> failed = new HashSet<String>(memberIds.size());
        int bestCount = this.membershipSizeThreshold;
        PropertyState bestProperty = null;
        Tree bestTree = null;
        while (trees.hasNext() && !memberIds.isEmpty()) {
            Tree t = trees.next();
            PropertyState refs = t.getProperty("rep:members");
            if (refs == null) continue;
            int numRefs = 0;
            for (String ref : refs.getValue(Type.WEAKREFERENCES)) {
                String id = memberIds.remove(ref);
                if (id != null) {
                    failed.add(id);
                    if (memberIds.isEmpty()) break;
                }
                ++numRefs;
            }
            if (numRefs >= bestCount) continue;
            bestCount = numRefs;
            bestProperty = refs;
            bestTree = t;
        }
        if (!memberIds.isEmpty()) {
            int propCnt;
            PropertyBuilder<String> propertyBuilder;
            if (bestProperty == null) {
                bestTree = !groupTree.hasProperty("rep:members") ? groupTree : MembershipWriter.createMemberRefTree(groupTree, membersList);
                propertyBuilder = PropertyBuilder.array(Type.WEAKREFERENCE, "rep:members");
                propCnt = 0;
            } else {
                propertyBuilder = PropertyBuilder.copy(Type.WEAKREFERENCE, bestProperty);
                propCnt = bestCount;
            }
            if (propCnt + memberIds.size() > this.membershipSizeThreshold) {
                while (!memberIds.isEmpty()) {
                    HashSet<String> s = new HashSet<String>();
                    Iterator<String> it = memberIds.keySet().iterator();
                    while (propCnt < this.membershipSizeThreshold && it.hasNext()) {
                        s.add(it.next());
                        it.remove();
                        ++propCnt;
                    }
                    propertyBuilder.addValues(s);
                    bestTree.setProperty(propertyBuilder.getPropertyState());
                    if (!it.hasNext()) continue;
                    propCnt = 0;
                    bestTree = MembershipWriter.createMemberRefTree(groupTree, membersList);
                    propertyBuilder = PropertyBuilder.array(Type.WEAKREFERENCE, "rep:members");
                }
            } else {
                propertyBuilder.addValues(memberIds.keySet());
                bestTree.setProperty(propertyBuilder.getPropertyState());
            }
        }
        return failed;
    }

    private static Tree createMemberRefTree(@Nonnull Tree groupTree, @Nonnull Tree membersList) {
        if (!membersList.exists()) {
            membersList = groupTree.addChild("rep:membersList");
            membersList.setProperty("jcr:primaryType", "rep:MemberReferencesList", Type.NAME);
        }
        Tree refTree = membersList.addChild(MembershipWriter.nextRefNodeName(membersList));
        refTree.setProperty("jcr:primaryType", "rep:MemberReferences", Type.NAME);
        return refTree;
    }

    private static String nextRefNodeName(@Nonnull Tree membersList) {
        int i = 0;
        String name = String.valueOf(i);
        while (membersList.hasChild(name)) {
            name = String.valueOf(++i);
        }
        return name;
    }

    boolean removeMember(@Nonnull Tree groupTree, @Nonnull String memberContentId) {
        HashMap<String, String> m = Maps.newHashMapWithExpectedSize(1);
        m.put(memberContentId, "-");
        return this.removeMembers(groupTree, m).isEmpty();
    }

    Set<String> removeMembers(@Nonnull Tree groupTree, @Nonnull Map<String, String> memberIds) {
        Tree membersList = groupTree.getChild("rep:membersList");
        Iterator<Tree> trees = Iterators.concat(Iterators.singletonIterator(groupTree), membersList.getChildren().iterator());
        while (trees.hasNext() && !memberIds.isEmpty()) {
            Tree t = trees.next();
            PropertyState refs = t.getProperty("rep:members");
            if (refs == null) continue;
            PropertyBuilder<String> prop = PropertyBuilder.copy(Type.WEAKREFERENCE, refs);
            Iterator<Map.Entry<String, String>> memberEntries = memberIds.entrySet().iterator();
            while (memberEntries.hasNext()) {
                String memberContentId = memberEntries.next().getKey();
                if (!prop.hasValue(memberContentId)) continue;
                prop.removeValue(memberContentId);
                if (prop.isEmpty()) {
                    if (t == groupTree) {
                        t.removeProperty("rep:members");
                    } else {
                        t.remove();
                    }
                } else {
                    t.setProperty(prop.getPropertyState());
                }
                memberEntries.remove();
            }
        }
        return Sets.newHashSet(memberIds.values());
    }

    public void setMembers(@Nonnull NodeBuilder group, @Nonnull Set<String> members) {
        group.removeProperty("rep:members");
        if (group.hasChildNode("rep:members")) {
            group.getChildNode("rep:members").remove();
        }
        PropertyBuilder<String> prop = null;
        NodeBuilder refList = null;
        NodeBuilder node = group;
        int count = 0;
        int numNodes = 0;
        for (String ref : members) {
            if (prop == null) {
                prop = PropertyBuilder.array(Type.WEAKREFERENCE, "rep:members");
            }
            prop.addValue(ref);
            if (++count <= this.membershipSizeThreshold) continue;
            node.setProperty(prop.getPropertyState());
            prop = null;
            if (refList == null) {
                refList = group.child("rep:membersList");
                refList.setProperty("jcr:primaryType", "rep:MemberReferencesList", Type.NAME);
            }
            node = refList.child(String.valueOf(numNodes++));
            node.setProperty("jcr:primaryType", "rep:MemberReferences", Type.NAME);
        }
        if (prop != null) {
            node.setProperty(prop.getPropertyState());
        }
    }
}

