/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.iterator.AbstractLazyIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.user.AuthorizableBaseProvider;
import org.apache.jackrabbit.oak.security.user.MembershipWriter;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MembershipProvider
extends AuthorizableBaseProvider {
    private static final Logger log = LoggerFactory.getLogger(MembershipProvider.class);
    private final MembershipWriter writer = new MembershipWriter();

    MembershipProvider(@Nonnull Root root, @Nonnull ConfigurationParameters config) {
        super(root, config);
    }

    int getMembershipSizeThreshold() {
        return this.writer.getMembershipSizeThreshold();
    }

    void setMembershipSizeThreshold(int membershipSizeThreshold) {
        this.writer.setMembershipSizeThreshold(membershipSizeThreshold);
    }

    @Nonnull
    Iterator<String> getMembership(@Nonnull Tree authorizableTree, boolean includeInherited) {
        return this.getMembership(authorizableTree, includeInherited, new HashSet<String>());
    }

    @Nonnull
    private Iterator<String> getMembership(@Nonnull Tree authorizableTree, final boolean includeInherited, final @Nonnull Set<String> processedPaths) {
        Iterable<String> refPaths = this.identifierManager.getReferences(authorizableTree, "rep:members", "rep:MemberReferences", true);
        return new AbstractMemberIterator(refPaths.iterator()){

            @Override
            protected String internalGetNext(@Nonnull String propPath) {
                String next = null;
                int index = propPath.indexOf("/rep:membersList");
                if (index < 0) {
                    index = propPath.indexOf("/rep:members");
                }
                if (index > 0) {
                    String groupPath = propPath.substring(0, index);
                    if (processedPaths.add(groupPath)) {
                        Tree group;
                        next = groupPath;
                        if (includeInherited && UserUtil.isType(group = MembershipProvider.this.getByPath(groupPath), AuthorizableType.GROUP)) {
                            this.remember(group);
                        }
                    }
                } else {
                    log.debug("Not a membership reference property " + propPath);
                }
                return next;
            }

            @Override
            @Nonnull
            protected Iterator<String> getNextIterator(@Nonnull Tree groupTree) {
                return MembershipProvider.this.getMembership(groupTree, true, processedPaths);
            }
        };
    }

    private boolean hasMembership(@Nonnull Tree authorizableTree, @Nonnull String groupPath) {
        return Iterators.contains(this.getMembership(authorizableTree, true), groupPath);
    }

    @Nonnull
    Iterator<String> getMembers(@Nonnull Tree groupTree, @Nonnull AuthorizableType authorizableType, boolean includeInherited) {
        return this.getMembers(groupTree, authorizableType, includeInherited, new HashSet<String>());
    }

    @Nonnull
    private Iterator<String> getMembers(@Nonnull Tree groupTree, final @Nonnull AuthorizableType authorizableType, final boolean includeInherited, final @Nonnull Set<String> processedRefs) {
        MemberReferenceIterator mrit = new MemberReferenceIterator(groupTree){

            @Override
            protected boolean hasProcessedReference(@Nonnull String value) {
                return processedRefs.add(value);
            }
        };
        return new AbstractMemberIterator(mrit){

            @Override
            protected String internalGetNext(@Nonnull String value) {
                String next = MembershipProvider.this.identifierManager.getPath(PropertyValues.newWeakReference(value));
                if (next != null && (includeInherited || authorizableType != AuthorizableType.AUTHORIZABLE)) {
                    AuthorizableType type;
                    Tree auth = MembershipProvider.this.getByPath(next);
                    AuthorizableType authorizableType2 = type = auth == null ? null : UserUtil.getType(auth);
                    if (includeInherited && type == AuthorizableType.GROUP) {
                        this.remember(auth);
                    }
                    if (authorizableType != AuthorizableType.AUTHORIZABLE && type != authorizableType) {
                        next = null;
                    }
                }
                return next;
            }

            @Override
            @Nonnull
            protected Iterator<String> getNextIterator(@Nonnull Tree groupTree) {
                return MembershipProvider.this.getMembers(groupTree, authorizableType, true, processedRefs);
            }
        };
    }

    boolean isMember(@Nonnull Tree groupTree, @Nonnull Tree authorizableTree) {
        if (!MembershipProvider.hasMembers(groupTree)) {
            return false;
        }
        if (this.pendingChanges(groupTree)) {
            return Iterators.contains(this.getMembers(groupTree, AuthorizableType.AUTHORIZABLE, true), authorizableTree.getPath());
        }
        return this.hasMembership(authorizableTree, groupTree.getPath());
    }

    boolean isDeclaredMember(@Nonnull Tree groupTree, @Nonnull Tree authorizableTree) {
        if (!MembershipProvider.hasMembers(groupTree)) {
            return false;
        }
        String contentId = this.getContentID(authorizableTree);
        MemberReferenceIterator refs = new MemberReferenceIterator(groupTree){

            @Override
            protected boolean hasProcessedReference(@Nonnull String value) {
                return true;
            }
        };
        return Iterators.contains(refs, contentId);
    }

    private static boolean hasMembers(@Nonnull Tree groupTree) {
        return groupTree.getPropertyStatus("rep:members") != null || groupTree.hasChild("rep:membersList");
    }

    private boolean pendingChanges(@Nonnull Tree groupTree) {
        Tree.Status memberPropStatus = groupTree.getPropertyStatus("rep:members");
        return Tree.Status.UNCHANGED != memberPropStatus || this.root.hasPendingChanges();
    }

    boolean addMember(@Nonnull Tree groupTree, @Nonnull Tree newMemberTree) throws RepositoryException {
        return this.writer.addMember(groupTree, this.getContentID(newMemberTree));
    }

    Set<String> addMembers(@Nonnull Tree groupTree, @Nonnull Map<String, String> memberIds) throws RepositoryException {
        return this.writer.addMembers(groupTree, memberIds);
    }

    boolean removeMember(@Nonnull Tree groupTree, @Nonnull Tree memberTree) {
        if (this.writer.removeMember(groupTree, this.getContentID(memberTree))) {
            return true;
        }
        log.debug("Authorizable {} was not member of {}", (Object)memberTree.getName(), (Object)groupTree.getName());
        return false;
    }

    Set<String> removeMembers(@Nonnull Tree groupTree, @Nonnull Map<String, String> memberIds) {
        return this.writer.removeMembers(groupTree, memberIds);
    }

    private abstract class AbstractMemberIterator
    extends AbstractLazyIterator<String> {
        private Iterator<String> references;
        private List<Tree> groupTrees;
        private Iterator<String> parent;

        AbstractMemberIterator(Iterator<String> references) {
            this.references = references;
        }

        @Override
        protected String getNext() {
            String next = null;
            while (next == null) {
                if (this.references.hasNext()) {
                    next = this.internalGetNext(this.references.next());
                    continue;
                }
                if (this.parent != null) {
                    if (this.parent.hasNext()) {
                        next = this.parent.next();
                        continue;
                    }
                    this.parent = null;
                    continue;
                }
                if (this.groupTrees == null || this.groupTrees.isEmpty()) break;
                this.parent = this.getNextIterator(this.groupTrees.remove(0));
            }
            return next;
        }

        protected void remember(@Nonnull Tree groupTree) {
            if (this.groupTrees == null) {
                this.groupTrees = new ArrayList<Tree>();
            }
            this.groupTrees.add(groupTree);
        }

        @CheckForNull
        protected abstract String internalGetNext(@Nonnull String var1);

        @Nonnull
        protected abstract Iterator<String> getNextIterator(@Nonnull Tree var1);
    }

    private abstract class MemberReferenceIterator
    extends AbstractLazyIterator<String> {
        private final Iterator<Tree> trees;
        private Iterator<String> propertyValues;

        private MemberReferenceIterator(Tree groupTree) {
            this.trees = Iterators.concat(Iterators.singletonIterator(groupTree), groupTree.getChild("rep:membersList").getChildren().iterator());
        }

        @Override
        protected String getNext() {
            String next = null;
            while (next == null) {
                if (this.propertyValues == null) {
                    if (!this.trees.hasNext()) break;
                    PropertyState property = this.trees.next().getProperty("rep:members");
                    if (property == null) continue;
                    this.propertyValues = property.getValue(Type.STRINGS).iterator();
                    continue;
                }
                if (!this.propertyValues.hasNext()) {
                    this.propertyValues = null;
                    continue;
                }
                String value = this.propertyValues.next();
                if (!this.hasProcessedReference(value)) continue;
                next = value;
            }
            return next;
        }

        protected abstract boolean hasProcessedReference(@Nonnull String var1);
    }
}

