/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.namepath.PathMapper;
import org.apache.jackrabbit.oak.security.user.TreeBasedPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractGroupPrincipal
extends TreeBasedPrincipal
implements Group {
    private static final Logger log = LoggerFactory.getLogger(AbstractGroupPrincipal.class);

    AbstractGroupPrincipal(@Nonnull String principalName, @Nonnull Tree groupTree, @Nonnull NamePathMapper namePathMapper) {
        super(principalName, groupTree, (PathMapper)namePathMapper);
    }

    AbstractGroupPrincipal(@Nonnull String principalName, @Nonnull String groupPath, @Nonnull NamePathMapper namePathMapper) {
        super(principalName, groupPath, (PathMapper)namePathMapper);
    }

    abstract UserManager getUserManager();

    abstract boolean isEveryone() throws RepositoryException;

    abstract boolean isMember(@Nonnull Authorizable var1) throws RepositoryException;

    @Nonnull
    abstract Iterator<Authorizable> getMembers() throws RepositoryException;

    public boolean isMember(Principal principal) {
        boolean isMember = false;
        try {
            if (this.isEveryone()) {
                isMember = !"everyone".equals(principal.getName());
            } else {
                Authorizable a = this.getUserManager().getAuthorizable(principal);
                if (a != null) {
                    isMember = this.isMember(a);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to determine group membership: {}", (Object)e.getMessage());
        }
        return isMember;
    }

    public Enumeration<? extends Principal> members() {
        Iterator<Authorizable> members;
        try {
            members = this.getMembers();
        }
        catch (RepositoryException e) {
            String msg = "Unable to retrieve Group members: " + e.getMessage();
            log.error(msg);
            throw new IllegalStateException(msg, e);
        }
        Iterator<Principal> principals = Iterators.transform(members, new Function<Authorizable, Principal>(){

            @Override
            public Principal apply(Authorizable authorizable) {
                if (authorizable == null) {
                    return null;
                }
                try {
                    return authorizable.getPrincipal();
                }
                catch (RepositoryException e) {
                    String msg = "Internal error while retrieving principal: " + e.getMessage();
                    log.error(msg);
                    throw new IllegalStateException(msg, e);
                }
            }
        });
        return Iterators.asEnumeration(Iterators.filter(principals, Predicates.notNull()));
    }

    public boolean addMember(Principal principal) {
        throw new UnsupportedOperationException();
    }

    public boolean removeMember(Principal principal) {
        throw new UnsupportedOperationException();
    }
}

