/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import com.google.common.collect.Lists;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.internal.ConfigurationInitializer;
import org.apache.jackrabbit.oak.security.internal.InternalSecurityProvider;
import org.apache.jackrabbit.oak.security.internal.Preconditions;
import org.apache.jackrabbit.oak.security.user.UserConfigurationImpl;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthenticationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.CompositeTokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.principal.CompositePrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalConfiguration;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAuthorizableActionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardAuthorizableNodeName;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardRestrictionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUserAuthenticationFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, label="Apache Jackrabbit Oak SecurityProvider", description="The default SecurityProvider embedded in Apache Jackrabbit Oak")
@Properties(value={@Property(name="requiredServicePids", label="Required Service PIDs", description="The SecurityProvider will not register itself unless the services identified by these PIDs are registered first. Only the PIDs of implementations of the following interfaces are checked: AuthorizationConfiguration, PrincipalConfiguration, TokenConfiguration, AuthorizableActionProvider, RestrictionProvider and UserAuthenticationFactory.", value={"org.apache.jackrabbit.oak.security.authorization.AuthorizationConfigurationImpl", "org.apache.jackrabbit.oak.security.principal.PrincipalConfigurationImpl", "org.apache.jackrabbit.oak.security.authentication.token.TokenConfigurationImpl", "org.apache.jackrabbit.oak.spi.security.user.action.DefaultAuthorizableActionProvider", "org.apache.jackrabbit.oak.security.authorization.restriction.RestrictionProviderImpl", "org.apache.jackrabbit.oak.security.user.UserAuthenticationFactoryImpl"}, unbounded=PropertyUnbounded.ARRAY)})
@References(value={@Reference(name="authorizationConfiguration", referenceInterface=AuthorizationConfiguration.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="principalConfiguration", referenceInterface=PrincipalConfiguration.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="tokenConfiguration", referenceInterface=TokenConfiguration.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="authorizableNodeName", referenceInterface=AuthorizableNodeName.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="authorizableActionProvider", referenceInterface=AuthorizableActionProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="restrictionProvider", referenceInterface=RestrictionProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC), @Reference(name="userAuthenticationFactory", referenceInterface=UserAuthenticationFactory.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class SecurityProviderRegistration {
    private static final Logger log = LoggerFactory.getLogger(SecurityProviderRegistration.class);
    @Reference
    private AuthenticationConfiguration authenticationConfiguration;
    @Reference
    private PrivilegeConfiguration privilegeConfiguration;
    @Reference
    private UserConfiguration userConfiguration;
    private BundleContext context;
    private ServiceRegistration registration;
    private boolean registering;
    private final Preconditions preconditions = new Preconditions();
    private final CompositeAuthorizationConfiguration authorizationConfiguration = new CompositeAuthorizationConfiguration();
    private final CompositePrincipalConfiguration principalConfiguration = new CompositePrincipalConfiguration();
    private final CompositeTokenConfiguration tokenConfiguration = new CompositeTokenConfiguration();
    private final List<AuthorizableNodeName> authorizableNodeNames = Lists.newCopyOnWriteArrayList();
    private final List<AuthorizableActionProvider> authorizableActionProviders = Lists.newCopyOnWriteArrayList();
    private final List<RestrictionProvider> restrictionProviders = Lists.newCopyOnWriteArrayList();
    private final List<UserAuthenticationFactory> userAuthenticationFactories = Lists.newCopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(BundleContext context, Map<String, Object> configuration) {
        String[] requiredServicePids = this.getRequiredServicePids(configuration);
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            for (String pid : requiredServicePids) {
                this.preconditions.addPrecondition(pid);
            }
            this.context = context;
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modified
    public void modified(Map<String, Object> configuration) {
        String[] requiredServicePids = this.getRequiredServicePids(configuration);
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.preconditions.clearPreconditions();
            for (String pid : requiredServicePids) {
                this.preconditions.addPrecondition(pid);
            }
        }
        this.maybeUnregister();
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate() {
        ServiceRegistration registration;
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            registration = this.registration;
            this.registration = null;
            this.registering = false;
            this.context = null;
            this.preconditions.clearPreconditions();
        }
        if (registration != null) {
            registration.unregister();
        }
    }

    public void bindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    public void unbindAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = null;
    }

    public void bindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = privilegeConfiguration;
    }

    public void unbindPrivilegeConfiguration(PrivilegeConfiguration privilegeConfiguration) {
        this.privilegeConfiguration = null;
    }

    public void bindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }

    public void unbindUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = null;
    }

    public void bindAuthorizationConfiguration(AuthorizationConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration(this.authorizationConfiguration, configuration, properties);
    }

    public void unbindAuthorizationConfiguration(AuthorizationConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration(this.authorizationConfiguration, configuration, properties);
    }

    public void bindPrincipalConfiguration(PrincipalConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration(this.principalConfiguration, configuration, properties);
    }

    public void unbindPrincipalConfiguration(PrincipalConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration(this.principalConfiguration, configuration, properties);
    }

    public void bindTokenConfiguration(TokenConfiguration configuration, Map<String, Object> properties) {
        this.bindConfiguration(this.tokenConfiguration, configuration, properties);
    }

    public void unbindTokenConfiguration(TokenConfiguration configuration, Map<String, Object> properties) {
        this.unbindConfiguration(this.tokenConfiguration, configuration, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindConfiguration(@Nonnull CompositeConfiguration composite, @Nonnull SecurityConfiguration configuration, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            composite.addConfiguration(configuration, ConfigurationParameters.of(properties));
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindConfiguration(@Nonnull CompositeConfiguration composite, @Nonnull SecurityConfiguration configuration, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            composite.removeConfiguration(configuration);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindAuthorizableNodeName(AuthorizableNodeName authorizableNodeName, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableNodeNames.add(authorizableNodeName);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthorizableNodeName(AuthorizableNodeName authorizableNodeName, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableNodeNames.remove(authorizableNodeName);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindAuthorizableActionProvider(AuthorizableActionProvider authorizableActionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableActionProviders.add(authorizableActionProvider);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindAuthorizableActionProvider(AuthorizableActionProvider authorizableActionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.authorizableActionProviders.remove(authorizableActionProvider);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindRestrictionProvider(RestrictionProvider restrictionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.restrictionProviders.add(restrictionProvider);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindRestrictionProvider(RestrictionProvider restrictionProvider, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.restrictionProviders.remove(restrictionProvider);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindUserAuthenticationFactory(UserAuthenticationFactory userAuthenticationFactory, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.userAuthenticationFactories.add(userAuthenticationFactory);
            this.addCandidate(properties);
        }
        this.maybeRegister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbindUserAuthenticationFactory(UserAuthenticationFactory userAuthenticationFactory, Map<String, Object> properties) {
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            this.userAuthenticationFactories.remove(userAuthenticationFactory);
            this.removeCandidate(properties);
        }
        this.maybeUnregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRegister() {
        BundleContext context;
        log.info("Trying to register a SecurityProvider...");
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            if (this.context == null) {
                log.info("Aborting: no BundleContext is available");
                return;
            }
            if (!this.preconditions.areSatisfied()) {
                log.info("Aborting: preconditions are not satisfied: {}", (Object)this.preconditions);
                return;
            }
            if (this.registration != null) {
                log.info("Aborting: a SecurityProvider is already registered");
                return;
            }
            if (this.registering) {
                log.info("Aborting: a SecurityProvider is already being registered");
                return;
            }
            this.registering = true;
            context = this.context;
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("type", "default");
        ServiceRegistration registration = context.registerService(SecurityProvider.class.getName(), (Object)this.createSecurityProvider(context), properties);
        SecurityProviderRegistration securityProviderRegistration2 = this;
        synchronized (securityProviderRegistration2) {
            this.registration = registration;
            this.registering = false;
        }
        log.info("SecurityProvider instance registered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUnregister() {
        ServiceRegistration registration;
        log.info("Trying to unregister the SecurityProvider...");
        SecurityProviderRegistration securityProviderRegistration = this;
        synchronized (securityProviderRegistration) {
            if (this.registration == null) {
                log.info("Aborting: no SecurityProvider is registered");
                return;
            }
            if (this.preconditions.areSatisfied()) {
                log.info("Aborting: preconditions are satisfied");
                return;
            }
            registration = this.registration;
            this.registration = null;
        }
        registration.unregister();
        log.info("SecurityProvider instance unregistered");
    }

    private SecurityProvider createSecurityProvider(@Nonnull BundleContext context) {
        InternalSecurityProvider securityProvider = new InternalSecurityProvider();
        securityProvider.setAuthenticationConfiguration(ConfigurationInitializer.initializeConfiguration(securityProvider, this.authenticationConfiguration));
        securityProvider.setPrivilegeConfiguration(ConfigurationInitializer.initializeConfiguration(securityProvider, this.privilegeConfiguration));
        ConfigurationParameters userParams = ConfigurationParameters.of(ConfigurationParameters.of("authorizableActionProvider", this.createWhiteboardAuthorizableActionProvider()), ConfigurationParameters.of("authorizableNodeName", this.createWhiteboardAuthorizableNodeName()), ConfigurationParameters.of("userAuthenticationFactory", this.createWhiteboardUserAuthenticationFactory()));
        securityProvider.setUserConfiguration(ConfigurationInitializer.initializeConfiguration(securityProvider, this.userConfiguration, userParams));
        ConfigurationParameters restrictionParams = ConfigurationParameters.of("restrictionProvider", this.createWhiteboardRestrictionProvider());
        ConfigurationInitializer.initializeConfigurations(securityProvider, this.authorizationConfiguration, restrictionParams);
        securityProvider.setAuthorizationConfiguration(this.authorizationConfiguration);
        ConfigurationInitializer.initializeConfigurations(securityProvider, this.principalConfiguration, ConfigurationParameters.EMPTY);
        securityProvider.setPrincipalConfiguration(this.principalConfiguration);
        ConfigurationInitializer.initializeConfigurations(securityProvider, this.tokenConfiguration, ConfigurationParameters.EMPTY);
        securityProvider.setTokenConfiguration(this.tokenConfiguration);
        securityProvider.setWhiteboard(new OsgiWhiteboard(context));
        return securityProvider;
    }

    private RestrictionProvider createWhiteboardRestrictionProvider() {
        return new WhiteboardRestrictionProvider(){

            @Override
            protected List<RestrictionProvider> getServices() {
                return Lists.newArrayList(SecurityProviderRegistration.this.restrictionProviders);
            }
        };
    }

    private AuthorizableActionProvider createWhiteboardAuthorizableActionProvider() {
        return new WhiteboardAuthorizableActionProvider(){

            @Override
            protected List<AuthorizableActionProvider> getServices() {
                return Lists.newArrayList(SecurityProviderRegistration.this.authorizableActionProviders);
            }
        };
    }

    private AuthorizableNodeName createWhiteboardAuthorizableNodeName() {
        return new WhiteboardAuthorizableNodeName(){

            @Override
            protected List<AuthorizableNodeName> getServices() {
                return Lists.newArrayList(SecurityProviderRegistration.this.authorizableNodeNames);
            }
        };
    }

    private UserAuthenticationFactory createWhiteboardUserAuthenticationFactory() {
        return new WhiteboardUserAuthenticationFactory(UserConfigurationImpl.getDefaultAuthenticationFactory()){

            @Override
            protected List<UserAuthenticationFactory> getServices() {
                return Lists.newArrayList(SecurityProviderRegistration.this.userAuthenticationFactories);
            }
        };
    }

    private void addCandidate(Map<String, Object> properties) {
        String pid = this.getServicePid(properties);
        if (pid == null) {
            return;
        }
        this.preconditions.addCandidate(pid);
    }

    private void removeCandidate(Map<String, Object> properties) {
        String pid = this.getServicePid(properties);
        if (pid == null) {
            return;
        }
        this.preconditions.removeCandidate(pid);
    }

    private String getServicePid(Map<String, Object> properties) {
        return PropertiesUtil.toString(properties.get("service.pid"), null);
    }

    private String[] getRequiredServicePids(Map<String, Object> configuration) {
        return PropertiesUtil.toStringArray(configuration.get("requiredServicePids"), new String[0]);
    }
}

