/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.internal;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;

class ConfigurationInitializer {
    private ConfigurationInitializer() {
    }

    @Nonnull
    static <T extends SecurityConfiguration> T initializeConfiguration(@Nonnull SecurityProvider securityProvider, @Nonnull T configuration) {
        return ConfigurationInitializer.initializeConfiguration(securityProvider, configuration, ConfigurationParameters.EMPTY);
    }

    @Nonnull
    static <T extends SecurityConfiguration> T initializeConfiguration(@Nonnull SecurityProvider securityProvider, @Nonnull T configuration, @Nonnull ConfigurationParameters parameters) {
        if (configuration instanceof ConfigurationBase) {
            ConfigurationBase base = (ConfigurationBase)configuration;
            base.setSecurityProvider(securityProvider);
            base.setParameters(ConfigurationParameters.of(base.getParameters(), parameters));
        }
        return configuration;
    }

    static void initializeConfigurations(@Nonnull SecurityProvider securityProvider, @Nonnull CompositeConfiguration configuration, @Nonnull ConfigurationParameters parameters) {
        configuration.setSecurityProvider(securityProvider);
        List configs = configuration.getConfigurations();
        for (SecurityConfiguration config : configs) {
            ConfigurationInitializer.initializeConfiguration(securityProvider, config, parameters);
        }
    }
}

