/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.security.AccessControlException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.security.authorization.restriction.GlobPattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.ItemNamePattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.NodeTypePattern;
import org.apache.jackrabbit.oak.security.authorization.restriction.PrefixPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.AbstractRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositePattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinitionImpl;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={RestrictionProvider.class})
public class RestrictionProviderImpl
extends AbstractRestrictionProvider {
    private static final Logger log = LoggerFactory.getLogger(RestrictionProviderImpl.class);
    private static final int NUMBER_OF_DEFINITIONS = 3;

    public RestrictionProviderImpl() {
        super(RestrictionProviderImpl.supportedRestrictions());
    }

    private static Map<String, RestrictionDefinition> supportedRestrictions() {
        RestrictionDefinitionImpl glob = new RestrictionDefinitionImpl("rep:glob", Type.STRING, false);
        RestrictionDefinitionImpl nts = new RestrictionDefinitionImpl("rep:ntNames", Type.NAMES, false);
        RestrictionDefinitionImpl pfxs = new RestrictionDefinitionImpl("rep:prefixes", Type.STRINGS, false);
        RestrictionDefinitionImpl names = new RestrictionDefinitionImpl("rep:itemNames", Type.NAMES, false);
        return ImmutableMap.of(glob.getName(), glob, nts.getName(), nts, pfxs.getName(), pfxs, names.getName(), names);
    }

    @Override
    @Nonnull
    public RestrictionPattern getPattern(String oakPath, @Nonnull Tree tree) {
        PropertyState itemNames;
        PropertyState prefixes;
        PropertyState ntNames;
        if (oakPath == null) {
            return RestrictionPattern.EMPTY;
        }
        ArrayList<RestrictionPattern> patterns = new ArrayList<RestrictionPattern>(3);
        PropertyState glob = tree.getProperty("rep:glob");
        if (glob != null) {
            patterns.add(GlobPattern.create(oakPath, glob.getValue(Type.STRING)));
        }
        if ((ntNames = tree.getProperty("rep:ntNames")) != null) {
            patterns.add(new NodeTypePattern(ntNames.getValue(Type.NAMES)));
        }
        if ((prefixes = tree.getProperty("rep:prefixes")) != null) {
            patterns.add(new PrefixPattern(prefixes.getValue(Type.STRINGS)));
        }
        if ((itemNames = tree.getProperty("rep:itemNames")) != null) {
            patterns.add(new ItemNamePattern(itemNames.getValue(Type.NAMES)));
        }
        return CompositePattern.create(patterns);
    }

    @Override
    @Nonnull
    public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Set<Restriction> restrictions) {
        if (oakPath == null || restrictions.isEmpty()) {
            return RestrictionPattern.EMPTY;
        }
        ArrayList<RestrictionPattern> patterns = new ArrayList<RestrictionPattern>(3);
        for (Restriction r : restrictions) {
            String name = r.getDefinition().getName();
            if ("rep:glob".equals(name)) {
                patterns.add(GlobPattern.create(oakPath, r.getProperty().getValue(Type.STRING)));
                continue;
            }
            if ("rep:ntNames".equals(name)) {
                patterns.add(new NodeTypePattern(r.getProperty().getValue(Type.NAMES)));
                continue;
            }
            if ("rep:prefixes".equals(name)) {
                patterns.add(new PrefixPattern(r.getProperty().getValue(Type.STRINGS)));
                continue;
            }
            if ("rep:itemNames".equals(name)) {
                patterns.add(new ItemNamePattern(r.getProperty().getValue(Type.NAMES)));
                continue;
            }
            log.debug("Ignoring unsupported restriction " + name);
        }
        return CompositePattern.create(patterns);
    }

    @Override
    public void validateRestrictions(String oakPath, @Nonnull Tree aceTree) throws AccessControlException {
        super.validateRestrictions(oakPath, aceTree);
        Tree restrictionsTree = this.getRestrictionsTree(aceTree);
        PropertyState glob = restrictionsTree.getProperty("rep:glob");
        if (glob != null) {
            GlobPattern.validate(glob.getValue(Type.STRING));
        }
    }
}

