/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.fulltext.LikePattern;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;

public class ComparisonImpl
extends ConstraintImpl {
    private final DynamicOperandImpl operand1;
    private final Operator operator;
    private final StaticOperandImpl operand2;

    public ComparisonImpl(DynamicOperandImpl operand1, Operator operator, StaticOperandImpl operand2) {
        this.operand1 = operand1;
        this.operator = operator;
        this.operand2 = operand2;
    }

    public DynamicOperandImpl getOperand1() {
        return this.operand1;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public StaticOperandImpl getOperand2() {
        return this.operand2;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        PropertyExistenceImpl p = this.operand1.getPropertyExistence();
        if (p == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(p);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.operand1.getSelectors();
    }

    @Override
    public boolean evaluate() {
        PropertyValue p1 = this.operand1.currentProperty();
        if (p1 == null) {
            return false;
        }
        PropertyValue p2 = this.operand2.currentValue();
        if (p2 == null) {
            return false;
        }
        p2 = this.convertValueToType(p2, p1);
        if (p1.getType().tag() != p2.getType().tag()) {
            int targetType = ComparisonImpl.getCommonType(p1, p2);
            p1 = this.convertToType(p1, targetType);
            p2 = this.convertToType(p2, targetType);
        }
        if (p1.isArray()) {
            Type<?> base = p1.getType().getBaseType();
            for (int i = 0; i < p1.count(); ++i) {
                PropertyState value = PropertyStates.createProperty("value", p1.getValue(base, i), base);
                if (!this.operator.evaluate(PropertyValues.create(value), p2)) continue;
                return true;
            }
            return false;
        }
        return this.operator.evaluate(p1, p2);
    }

    private static int getCommonType(PropertyValue p1, PropertyValue p2) {
        if (p1.getType().tag() == 2 || p2.getType().tag() == 2) {
            return 2;
        }
        return 1;
    }

    private PropertyValue convertToType(PropertyValue v, int targetType) {
        try {
            return PropertyValues.convert(v, targetType, this.query.getNamePathMapper());
        }
        catch (IllegalArgumentException e) {
            return v;
        }
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.operand1 + " " + (Object)((Object)this.operator) + " " + this.operand2;
    }

    @Override
    public void restrict(FilterImpl f) {
        PropertyValue v = this.operand2.currentValue();
        if (!PropertyValues.canConvert(this.operand2.getPropertyType(), this.operand1.getPropertyType())) {
            throw new IllegalArgumentException("Unsupported conversion from property type " + PropertyType.nameFromValue(this.operand2.getPropertyType()) + " to property type " + PropertyType.nameFromValue(this.operand1.getPropertyType()));
        }
        if (v != null) {
            if (this.operator == Operator.LIKE) {
                String pattern = v.getValue(Type.STRING);
                LikePattern p = new LikePattern(pattern);
                String lowerBound = p.getLowerBound();
                if (lowerBound != null) {
                    String upperBound = p.getUpperBound();
                    if (lowerBound.equals(upperBound)) {
                        PropertyValue pv = PropertyValues.newString(lowerBound);
                        this.operand1.restrict(f, Operator.EQUAL, pv);
                    } else if (this.operand1.supportsRangeConditions()) {
                        PropertyValue pv;
                        if (lowerBound != null) {
                            pv = PropertyValues.newString(lowerBound);
                            this.operand1.restrict(f, Operator.GREATER_OR_EQUAL, pv);
                        }
                        if (upperBound != null) {
                            pv = PropertyValues.newString(upperBound);
                            this.operand1.restrict(f, Operator.LESS_OR_EQUAL, pv);
                        }
                    } else {
                        this.operand1.restrict(f, this.operator, v);
                    }
                } else {
                    this.operand1.restrict(f, this.operator, v);
                }
            } else {
                this.operand1.restrict(f, this.operator, v);
            }
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (this.operand2.currentValue() != null && this.operand1.canRestrictSelector(s)) {
            s.restrictSelector(this);
        }
    }

    @Override
    public AstElement copyOf() {
        return new ComparisonImpl(this.operand1.createCopy(), this.operator, this.operand2);
    }
}

