/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.lock.LockConstants;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.VersionConstants;
import org.apache.jackrabbit.oak.plugins.version.VersionExceptionCode;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class VersionEditor
implements Editor {
    private final VersionEditor parent;
    private final ReadWriteVersionManager vMgr;
    private final NodeBuilder node;
    private final String name;
    private Boolean isVersionable = null;
    private NodeState before;
    private NodeState after;
    private boolean isReadOnly;
    private CommitInfo commitInfo;

    public VersionEditor(@Nonnull NodeBuilder versionStore, @Nonnull NodeBuilder workspaceRoot, @Nonnull CommitInfo commitInfo) {
        this(null, new ReadWriteVersionManager(Preconditions.checkNotNull(versionStore), Preconditions.checkNotNull(workspaceRoot)), workspaceRoot, "", commitInfo);
    }

    VersionEditor(@Nullable VersionEditor parent, @Nonnull ReadWriteVersionManager vMgr, @Nonnull NodeBuilder node, @Nonnull String name, @Nonnull CommitInfo commitInfo) {
        this.parent = parent;
        this.vMgr = Preconditions.checkNotNull(vMgr);
        this.node = Preconditions.checkNotNull(node);
        this.name = Preconditions.checkNotNull(name);
        this.commitInfo = commitInfo;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.before = before;
        this.after = after;
        if (this.isVersionable()) {
            this.vMgr.getOrCreateVersionHistory(this.node, this.commitInfo.getInfo());
        }
        this.isReadOnly = after.exists() || this.isVersionable() ? this.wasCheckedIn() && !this.hasNewIdentifier() : this.parent != null && this.parent.isReadOnly;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (after.getName().equals("jcr:baseVersion") && this.after.hasProperty("jcr:versionHistory") && !this.after.hasProperty("jcr:isCheckedOut") && !this.before.exists()) {
            this.vMgr.restore(this.node, after.getValue(Type.REFERENCE), null);
            return;
        }
        if (!this.isReadOnly) {
            return;
        }
        if (after.getName().equals("jcr:lockOwner") || after.getName().equals("jcr:lockIsDeep")) {
            return;
        }
        VersionEditor.throwCheckedIn("Cannot add property " + after.getName() + " on checked in node");
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (!this.isVersionable()) {
            if (!this.isVersionProperty(after) && this.isReadOnly) {
                VersionEditor.throwCheckedIn("Cannot change property " + after.getName() + " on checked in node");
            }
            return;
        }
        String propName = after.getName();
        if (propName.equals("jcr:isCheckedOut")) {
            if (this.wasCheckedIn()) {
                this.vMgr.checkout(this.node);
            } else {
                this.vMgr.checkin(this.node);
            }
        } else if (propName.equals("jcr:baseVersion")) {
            String baseVersion = after.getValue(Type.REFERENCE);
            if (baseVersion.startsWith("restore-")) {
                baseVersion = baseVersion.substring("restore-".length());
                this.node.setProperty("jcr:baseVersion", baseVersion, Type.REFERENCE);
            }
            this.vMgr.restore(this.node, baseVersion, null);
        } else if (this.isVersionProperty(after)) {
            VersionEditor.throwProtected(after.getName());
        } else if (this.isReadOnly) {
            VersionEditor.throwCheckedIn("Cannot change property " + after.getName() + " on checked in node");
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (this.isReadOnly && !this.isVersionProperty(before) && !this.isLockProperty(before)) {
            VersionEditor.throwCheckedIn("Cannot delete property on checked in node");
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) {
        return this.childNodeChanged(name, EmptyNodeState.MISSING_NODE, after);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new VersionEditor(this, this.vMgr, this.node.child(name), name, this.commitInfo);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) {
        return new VersionEditor(this, this.vMgr, EmptyNodeState.MISSING_NODE.builder(), name, this.commitInfo);
    }

    private boolean isVersionable() {
        if (this.isVersionable == null) {
            this.isVersionable = this.vMgr.isVersionable(this.after);
        }
        return this.isVersionable;
    }

    private boolean isVersionProperty(PropertyState state) {
        return VersionConstants.VERSION_PROPERTY_NAMES.contains(state.getName());
    }

    private boolean isLockProperty(PropertyState state) {
        return LockConstants.LOCK_PROPERTY_NAMES.contains(state.getName());
    }

    private boolean wasCheckedIn() {
        PropertyState prop = this.before.getProperty("jcr:isCheckedOut");
        if (prop != null) {
            return prop.getValue(Type.BOOLEAN) == false;
        }
        return this.parent != null && this.parent.wasCheckedIn();
    }

    private boolean hasNewIdentifier() {
        String afterId;
        String beforeId = this.buildBeforeIdentifier(new StringBuilder()).toString();
        return !beforeId.equals(afterId = this.buildAfterIdentifier(new StringBuilder()).toString());
    }

    private StringBuilder buildBeforeIdentifier(StringBuilder identifier) {
        String uuid = this.before.getString("jcr:uuid");
        if (uuid != null) {
            identifier.append(uuid);
        } else if (this.parent != null) {
            this.parent.buildBeforeIdentifier(identifier);
            identifier.append("/").append(this.name);
        }
        return identifier;
    }

    private StringBuilder buildAfterIdentifier(StringBuilder identifier) {
        String uuid = this.after.getString("jcr:uuid");
        if (uuid != null) {
            identifier.append(uuid);
        } else if (this.parent != null) {
            this.parent.buildAfterIdentifier(identifier);
            identifier.append("/").append(this.name);
        }
        return identifier;
    }

    private static void throwCheckedIn(String msg) throws CommitFailedException {
        throw new CommitFailedException("Version", VersionExceptionCode.NODE_CHECKED_IN.ordinal(), msg);
    }

    private static void throwProtected(String name) throws CommitFailedException {
        throw new CommitFailedException("Constraint", 100, "Property is protected: " + name);
    }
}

