/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree.impl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tree.impl.HiddenTree;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;

public abstract class AbstractTree
implements Tree {
    private static final String[] INTERNAL_NODE_NAMES = new String[]{":index", ":references", ":weakreferences", ":conflict"};

    @Nonnull
    protected abstract AbstractTree createChild(@Nonnull String var1) throws IllegalArgumentException;

    @CheckForNull
    protected abstract AbstractTree getParentOrNull();

    @Nonnull
    protected abstract NodeBuilder getNodeBuilder();

    protected boolean isHidden(@Nonnull String name) {
        return NodeStateUtils.isHidden(name);
    }

    @Nonnull
    protected String[] getInternalNodeNames() {
        return INTERNAL_NODE_NAMES;
    }

    @Nonnull
    public NodeState getNodeState() {
        return this.getNodeBuilder().getNodeState();
    }

    protected boolean hasOrderableChildren() {
        return this.getNodeBuilder().hasProperty(":childOrder");
    }

    @Nonnull
    protected Iterable<String> getChildNames() {
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        PropertyState order = nodeBuilder.getProperty(":childOrder");
        if (order != null && order.getType() == Type.NAMES) {
            LinkedHashSet<String> names = Sets.newLinkedHashSet(nodeBuilder.getChildNodeNames());
            ArrayList<String> ordered = Lists.newArrayListWithCapacity(names.size());
            for (String name : order.getValue(Type.NAMES)) {
                if (!names.remove(name)) continue;
                ordered.add(name);
            }
            ordered.addAll(names);
            return ordered;
        }
        return nodeBuilder.getChildNodeNames();
    }

    public String toString() {
        return this.toString(5);
    }

    /*
     * WARNING - void declaration
     */
    private String toString(int childNameCountLimit) {
        void var4_6;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPath()).append(": ");
        sb.append('{');
        for (PropertyState propertyState : this.getProperties()) {
            sb.append(' ').append(propertyState).append(',');
        }
        Iterator<String> names = this.getChildNames().iterator();
        boolean bl = false;
        while (names.hasNext() && ++var4_6 <= childNameCountLimit) {
            sb.append(' ').append(names.next()).append(" = { ... },");
        }
        if (names.hasNext()) {
            sb.append(" ...");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean isRoot() {
        return this.getParentOrNull() == null;
    }

    @Override
    @Nonnull
    public String getPath() {
        if (this.isRoot()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder(128);
        this.buildPath(sb);
        return sb.toString();
    }

    protected void buildPath(@Nonnull StringBuilder sb) {
        AbstractTree parent = this.getParentOrNull();
        if (parent != null) {
            parent.buildPath(sb);
            sb.append('/').append(this.getName());
        }
    }

    @Override
    @Nonnull
    public Tree.Status getStatus() {
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        if (nodeBuilder.isNew() || nodeBuilder.isReplaced()) {
            return Tree.Status.NEW;
        }
        if (nodeBuilder.isModified()) {
            return Tree.Status.MODIFIED;
        }
        return Tree.Status.UNCHANGED;
    }

    @Override
    public boolean exists() {
        return this.getNodeBuilder().exists() && !this.isHidden(this.getName());
    }

    @Override
    @Nonnull
    public AbstractTree getParent() {
        AbstractTree parent = this.getParentOrNull();
        Preconditions.checkState(parent != null, "root tree does not have a parent");
        return parent;
    }

    @Override
    @Nonnull
    public Tree getChild(@Nonnull String name) throws IllegalArgumentException {
        if (!this.isHidden(name)) {
            return this.createChild(name);
        }
        return new HiddenTree(this, name);
    }

    @Override
    @CheckForNull
    public PropertyState getProperty(@Nonnull String name) {
        return !this.isHidden(name) ? this.getNodeBuilder().getProperty(name) : null;
    }

    @Override
    public boolean hasProperty(@Nonnull String name) {
        return !this.isHidden(name) && this.getNodeBuilder().hasProperty(name);
    }

    @Override
    public long getPropertyCount() {
        return Iterables.size(this.getProperties());
    }

    @Override
    @CheckForNull
    public Tree.Status getPropertyStatus(@Nonnull String name) {
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        if (!this.hasProperty(name)) {
            return null;
        }
        if (nodeBuilder.isNew(name)) {
            return Tree.Status.NEW;
        }
        if (nodeBuilder.isReplaced(name)) {
            return Tree.Status.MODIFIED;
        }
        return Tree.Status.UNCHANGED;
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return Iterables.filter(this.getNodeBuilder().getProperties(), new Predicate<PropertyState>(){

            @Override
            public boolean apply(PropertyState propertyState) {
                return !AbstractTree.this.isHidden(propertyState.getName());
            }
        });
    }

    @Override
    public boolean hasChild(@Nonnull String name) {
        return this.getNodeBuilder().hasChildNode(name) && !this.isHidden(name);
    }

    @Override
    public long getChildrenCount(long max) {
        String[] internalNodeNames = this.getInternalNodeNames();
        int len = internalNodeNames.length;
        max = max + (long)len < 0L ? Long.MAX_VALUE : (max += (long)len);
        NodeBuilder nodeBuilder = this.getNodeBuilder();
        long count = nodeBuilder.getChildNodeCount(max);
        if (count > 0L) {
            for (String name : internalNodeNames) {
                if (!nodeBuilder.hasChildNode(name)) continue;
                --count;
            }
        }
        return count;
    }

    @Override
    @Nonnull
    public Iterable<Tree> getChildren() {
        Iterable<Tree> children = Iterables.transform(this.getChildNames(), new Function<String, Tree>(){

            @Override
            public Tree apply(String name) {
                AbstractTree child = AbstractTree.this.createChild(name);
                return child.exists() ? child : null;
            }
        });
        return Iterables.filter(children, Predicates.notNull());
    }
}

