/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.http;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class HttpStore
implements SegmentStore {
    private final SegmentTracker tracker = new SegmentTracker(this);
    private final URL base;

    public HttpStore(URL base) {
        this.base = base;
    }

    @Override
    public SegmentTracker getTracker() {
        return this.tracker;
    }

    protected URLConnection get(String fragment) throws MalformedURLException, IOException {
        URL url = fragment == null ? this.base : new URL(this.base, fragment);
        return url.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentNodeState getHead() {
        SegmentNodeState segmentNodeState;
        URLConnection connection = this.get(null);
        InputStream stream = connection.getInputStream();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, Charsets.UTF_8));
            segmentNodeState = new SegmentNodeState(RecordId.fromString(this.tracker, reader.readLine()));
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return segmentNodeState;
    }

    @Override
    public boolean setHead(SegmentNodeState base, SegmentNodeState head) {
        return true;
    }

    @Override
    public boolean containsSegment(SegmentId id) {
        return id.getTracker() == this.tracker || this.readSegment(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Segment readSegment(SegmentId id) {
        Segment segment;
        URLConnection connection = this.get(id.toString());
        InputStream stream = connection.getInputStream();
        try {
            byte[] data = ByteStreams.toByteArray(stream);
            segment = new Segment(this.tracker, id, ByteBuffer.wrap(data));
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (MalformedURLException e) {
                throw new SegmentNotFoundException(id, (Throwable)e);
            }
            catch (IOException e) {
                throw new SegmentNotFoundException(id, (Throwable)e);
            }
        }
        stream.close();
        return segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSegment(SegmentId id, byte[] bytes, int offset, int length) throws IOException {
        try {
            URLConnection connection = this.get(id.toString());
            connection.setDoInput(false);
            connection.setDoOutput(true);
            try (OutputStream stream = connection.getOutputStream();){
                stream.write(bytes, offset, length);
            }
        }
        catch (MalformedURLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    @CheckForNull
    public Blob readBlob(String reference) {
        return null;
    }

    @Override
    @CheckForNull
    public BlobStore getBlobStore() {
        return null;
    }

    @Override
    public void gc() {
    }
}

