/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.multiplex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.multiplex.MountInfo;
import org.apache.jackrabbit.oak.plugins.multiplex.SimpleMountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak MountInfoProvider")
public class MountInfoProviderService {
    @Property(label="Mounted paths", unbounded=PropertyUnbounded.ARRAY, description="Paths which are part of private mount")
    private static final String PROP_MOUNT_PATHS = "mountedPaths";
    static final String PROP_MOUNT_NAME_DEFAULT = "private";
    @Property(label="Mount name", description="Name of the mount", value={"private"})
    private static final String PROP_MOUNT_NAME = "mountName";
    private static final boolean PROP_MOUNT_READONLY_DEFAULT = false;
    @Property(label="Readonly", description="If enabled then mount would be considered as readonly", boolValue={false})
    private static final String PROP_MOUNT_READONLY = "readOnlyMount";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration reg;

    @Activate
    private void activate(BundleContext bundleContext, Map<String, ?> config) {
        String[] paths = PropertiesUtil.toStringArray(config.get(PROP_MOUNT_PATHS));
        String mountName = PropertiesUtil.toString(config.get(PROP_MOUNT_NAME), PROP_MOUNT_NAME_DEFAULT);
        boolean readOnly = PropertiesUtil.toBoolean(config.get(PROP_MOUNT_READONLY), false);
        MountInfoProvider mip = Mounts.defaultMountInfoProvider();
        if (paths != null) {
            ArrayList<String> trimmedPaths = new ArrayList<String>(paths.length);
            for (String path : paths) {
                trimmedPaths.add(path.trim());
            }
            MountInfo mi = new MountInfo(mountName.trim(), readOnly, false, trimmedPaths);
            mip = new SimpleMountInfoProvider(Collections.singletonList(mi));
            this.log.info("Enabling mount for {}", (Object)mi);
        } else {
            this.log.info("No mount config provided. Mounting would be disabled");
        }
        this.reg = bundleContext.registerService(MountInfoProvider.class.getName(), (Object)mip, null);
    }

    @Deactivate
    private void deactivate() {
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }
}

