/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.multiplex;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.mount.Mount;

final class MountInfo
implements Mount {
    private static final Function<String, String> SANITIZE_PATH = new Function<String, String>(){

        @Override
        public String apply(String input) {
            if (input.endsWith("/") && input.length() > 1) {
                return input.substring(0, input.length() - 1);
            }
            return input;
        }
    };
    private final String name;
    private final boolean readOnly;
    private final boolean defaultMount;
    private final String pathFragmentName;
    private final List<String> includedPaths;

    public MountInfo(String name, boolean readOnly, boolean defaultMount, List<String> includedPaths) {
        this.name = Preconditions.checkNotNull(name, "Mount name must not be null");
        this.readOnly = readOnly;
        this.defaultMount = defaultMount;
        this.pathFragmentName = "oak:mount-" + name;
        this.includedPaths = MountInfo.cleanCopy(includedPaths);
    }

    @Override
    public boolean isUnder(String path) {
        path = SANITIZE_PATH.apply(path);
        for (String includedPath : this.includedPaths) {
            if (!PathUtils.isAncestor(path, includedPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMounted(String path) {
        if (path.contains(this.pathFragmentName)) {
            return true;
        }
        path = SANITIZE_PATH.apply(path);
        for (String includedPath : this.includedPaths) {
            if (!includedPath.equals(path) && !PathUtils.isAncestor(includedPath, path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDefault() {
        return this.defaultMount;
    }

    @Override
    public String getPathFragmentName() {
        return this.pathFragmentName;
    }

    private static ImmutableList<String> cleanCopy(List<String> includedPaths) {
        return ImmutableList.copyOf(Iterables.transform(includedPaths, SANITIZE_PATH));
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String readAttr = this.readOnly ? "r" : "rw";
        String displayName = this.defaultMount ? "default" : this.name;
        pw.print(displayName + "(" + readAttr + ")");
        for (String path : this.includedPaths) {
            pw.printf("\t%s%n", path);
        }
        return sw.toString();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MountInfo other = (MountInfo)obj;
        return this.name.equals(other.name);
    }
}

