/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.PathFilter;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class PropertyIndexPlan {
    public static final double COST_OVERHEAD = 2.0;
    static final int MAX_COST = 100;
    private final NodeState definition;
    private final String name;
    private final Set<String> properties;
    private final Set<IndexStoreStrategy> strategies;
    private final Filter filter;
    private boolean matchesAllTypes;
    private boolean matchesNodeTypes;
    private final double cost;
    private final Set<String> values;
    private final int depth;
    private final PathFilter pathFilter;
    private final boolean unique;

    PropertyIndexPlan(String name, NodeState root, NodeState definition, Filter filter) {
        this(name, root, definition, filter, Mounts.defaultMountInfoProvider());
    }

    PropertyIndexPlan(String name, NodeState root, NodeState definition, Filter filter, MountInfoProvider mountInfoProvider) {
        this.name = name;
        this.unique = definition.getBoolean("unique");
        this.definition = definition;
        this.properties = Sets.newHashSet(definition.getNames("propertyNames"));
        this.pathFilter = PathFilter.from(definition.builder());
        this.strategies = this.getStrategies(definition, mountInfoProvider);
        this.filter = filter;
        Iterable<String> types = definition.getNames("declaringNodeTypes");
        this.matchesAllTypes = !definition.hasProperty("declaringNodeTypes");
        this.matchesNodeTypes = this.matchesAllTypes || Iterables.any(types, Predicates.in(filter.getSupertypes()));
        double bestCost = Double.POSITIVE_INFINITY;
        Set<Object> bestValues = Collections.emptySet();
        int bestDepth = 1;
        if (this.matchesNodeTypes && this.pathFilter.areAllDescendantsIncluded(filter.getPath())) {
            for (String property : this.properties) {
                Filter.PropertyRestriction restriction = filter.getPropertyRestriction(property);
                int depth = 1;
                if (restriction == null) {
                    String suffix = "/" + property;
                    for (Filter.PropertyRestriction relative : filter.getPropertyRestrictions()) {
                        if (!relative.propertyName.endsWith(suffix)) continue;
                        restriction = relative;
                        depth = PathUtils.getDepth(relative.propertyName);
                    }
                }
                if (restriction == null || restriction.isNullRestriction() || depth != 1 && !this.matchesAllTypes) continue;
                Set<String> values = PropertyIndexPlan.getValues(restriction);
                double cost = this.strategies.isEmpty() ? 100.0 : 0.0;
                for (IndexStoreStrategy strategy : this.strategies) {
                    cost += (double)strategy.count(filter, root, definition, values, 100);
                }
                if (this.unique && cost <= 1.0) {
                    cost = 0.0;
                }
                if (!(cost < bestCost)) continue;
                bestDepth = depth;
                bestValues = values;
                bestCost = cost;
                if (bestCost != 0.0) continue;
                break;
            }
        }
        this.depth = bestDepth;
        this.values = bestValues;
        this.cost = 2.0 + bestCost;
    }

    private static Set<String> getValues(Filter.PropertyRestriction restriction) {
        if (restriction.firstIncluding && restriction.lastIncluding && restriction.first != null && restriction.first.equals(restriction.last)) {
            return PropertyIndex.encode(restriction.first);
        }
        if (restriction.list != null) {
            LinkedHashSet<String> values = Sets.newLinkedHashSet();
            for (PropertyValue value : restriction.list) {
                values.addAll(PropertyIndex.encode(value));
            }
            return values;
        }
        return null;
    }

    String getName() {
        return this.name;
    }

    double getCost() {
        return this.cost;
    }

    Cursor execute() {
        QueryEngineSettings settings = this.filter.getQueryEngineSettings();
        ArrayList<Iterable<String>> iterables = Lists.newArrayList();
        for (IndexStoreStrategy s : this.strategies) {
            iterables.add(s.query(this.filter, this.name, this.definition, this.values));
        }
        Cursor cursor = Cursors.newPathCursor(Iterables.concat(iterables), settings);
        if (this.depth > 1) {
            cursor = Cursors.newAncestorCursor(cursor, this.depth - 1, settings);
        }
        return cursor;
    }

    Filter getFilter() {
        return this.filter;
    }

    Set<IndexStoreStrategy> getStrategies(NodeState definition, MountInfoProvider mountInfoProvider) {
        return Multiplexers.getStrategies(this.unique, mountInfoProvider, definition, ":index");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("property ");
        buffer.append(this.name);
        if (this.values == null) {
            buffer.append(" IS NOT NULL");
        } else if (this.values.isEmpty()) {
            buffer.append(" NOT APPLICABLE");
        } else if (this.values.size() == 1) {
            buffer.append(" = ");
            buffer.append(this.values.iterator().next());
        } else {
            buffer.append(" IN (");
            boolean comma = false;
            for (String value : this.values) {
                if (comma) {
                    buffer.append(", ");
                }
                buffer.append(value);
                comma = true;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }
}

