/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.aggregate;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class AggregationCursor
extends Cursors.AbstractCursor {
    private final Cursor cursor;
    private final NodeAggregator aggregator;
    private final NodeState rootState;
    private boolean init;
    private boolean closed;
    private IndexRow currentRow;
    private String currentPath;
    private Iterator<String> aggregates;
    private Set<String> seenPaths = new HashSet<String>();

    public AggregationCursor(Cursor cursor, NodeAggregator aggregator, NodeState rootState) {
        this.cursor = cursor;
        this.aggregator = aggregator;
        this.rootState = rootState;
    }

    @Override
    public boolean hasNext() {
        if (!this.closed && !this.init) {
            this.fetchNext();
            this.init = true;
        }
        return !this.closed;
    }

    private void fetchNext() {
        if (this.aggregates != null && this.aggregates.hasNext()) {
            this.currentPath = this.aggregates.next();
            this.init = true;
            return;
        }
        this.aggregates = null;
        if (this.cursor.hasNext()) {
            this.currentRow = this.cursor.next();
            if (!this.currentRow.isVirtualRow()) {
                String path = this.currentRow.getPath();
                this.aggregates = Iterators.filter(Iterators.concat(Iterators.singletonIterator(path), this.aggregator.getParents(this.rootState, path)), Predicates.not(Predicates.in(this.seenPaths)));
            }
            this.fetchNext();
            return;
        }
        this.closed = true;
    }

    @Override
    public IndexRow next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.seenPaths.add(this.currentPath);
        this.init = false;
        if (this.currentRow.getPath().equals(this.currentPath)) {
            return this.currentRow;
        }
        return new IndexRow(){

            @Override
            public boolean isVirtualRow() {
                return false;
            }

            @Override
            public String getPath() {
                return AggregationCursor.this.currentPath;
            }

            @Override
            public PropertyValue getValue(String columnName) {
                return AggregationCursor.this.currentRow.getValue(columnName);
            }
        };
    }

    @Override
    public long getSize(Result.SizePrecision precision, long max) {
        return this.cursor.getSize(precision, max);
    }
}

