/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;

public class IndexMBeanRegistration
implements Registration {
    private final Whiteboard whiteboard;
    private final List<Registration> regs = Lists.newArrayList();

    public IndexMBeanRegistration(Whiteboard whiteboard) {
        this.whiteboard = whiteboard;
    }

    public void registerAsyncIndexer(AsyncIndexUpdate task, long delayInSeconds) {
        task.setIndexMBeanRegistration(this);
        this.regs.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, task, delayInSeconds, true, true));
        this.regs.add(WhiteboardUtils.registerMBean(this.whiteboard, IndexStatsMBean.class, task.getIndexStats(), "IndexStats", task.getName()));
        this.regs.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, task.getIndexStats(), 1L));
    }

    @Override
    public void unregister() {
        new CompositeRegistration(this.regs).unregister();
    }
}

