/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;

public class ReadOnlyDocumentStoreWrapperFactory {
    private static final Set<String> unsupportedMethods = Sets.newHashSet("remove", "create", "update", "createOrUpdate", "findAndUpdate");

    public static DocumentStore getInstance(final @Nonnull DocumentStore delegate) {
        return (DocumentStore)Proxy.newProxyInstance(DocumentStore.class.getClassLoader(), new Class[]{DocumentStore.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (unsupportedMethods.contains(method.getName())) {
                    throw new UnsupportedOperationException(String.format("Method - %s. Params: %s", method.getName(), Arrays.toString(args)));
                }
                return method.invoke((Object)delegate, args);
            }
        });
    }
}

