/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class MergeSortedIterators<T>
implements Iterator<T> {
    private final List<PeekingIterator<T>> iterators = new ArrayList<PeekingIterator<T>>();
    private final Comparator<T> comparator;
    private T lastPeek;

    public MergeSortedIterators(Comparator<T> comparator) {
        this.comparator = comparator;
        this.fetchNextIterator();
    }

    public abstract Iterator<T> nextIterator();

    public String description() {
        return "";
    }

    @Override
    public boolean hasNext() {
        return !this.iterators.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PeekingIterator<T> it = this.iterators.get(0);
        T next = it.next();
        if (it.hasNext()) {
            this.adjustFirst();
        } else {
            this.iterators.remove(0);
        }
        if (this.comparator.compare(next, this.lastPeek) >= 0) {
            this.fetchNextIterator();
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void fetchNextIterator() {
        Iterator<T> it = this.nextIterator();
        if (it != null && it.hasNext()) {
            PeekingIterator<T> pIt = Iterators.peekingIterator(it);
            if (!this.iterators.isEmpty() && this.comparator.compare(pIt.peek(), this.lastPeek) < 0) {
                throw new IllegalStateException(this.description() + " First element of next iterator (" + pIt.peek() + ")" + " must be after previous iterator (" + this.lastPeek + ")");
            }
            this.lastPeek = pIt.peek();
            this.iterators.add(pIt);
            this.adjustLast();
        }
    }

    private void adjustFirst() {
        int i = 0;
        while (i + 1 < this.iterators.size() && this.comparator.compare(this.iterators.get(i).peek(), this.iterators.get(i + 1).peek()) > 0) {
            Collections.swap(this.iterators, i, i + 1);
            ++i;
        }
    }

    private void adjustLast() {
        int i = this.iterators.size() - 1;
        while (i - 1 >= 0 && this.comparator.compare(this.iterators.get(i - 1).peek(), this.iterators.get(i).peek()) > 0) {
            Collections.swap(this.iterators, i, i - 1);
            --i;
        }
    }
}

