/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.RevisionListener;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDocumentStoreWrapper
implements DocumentStore,
RevisionListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingDocumentStoreWrapper.class);
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("ds.debug", "true"));
    final DocumentStore store;
    private boolean logThread;

    public LoggingDocumentStoreWrapper(DocumentStore store) {
        this.store = store;
    }

    public LoggingDocumentStoreWrapper withThreadNameLogging() {
        this.logThread = true;
        return this;
    }

    @Override
    public <T extends Document> T find(final Collection<T> collection, final String key) {
        try {
            this.logMethod("find", collection, key);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.find(collection, key);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> T find(final Collection<T> collection, final String key, final int maxCacheAge) {
        try {
            this.logMethod("find", collection, key, maxCacheAge);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.find(collection, key, maxCacheAge);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(final Collection<T> collection, final String fromKey, final String toKey, final int limit) {
        try {
            this.logMethod("query", collection, fromKey, toKey, limit);
            return (List)this.logResult(new Callable<List<T>>(){

                @Override
                public List<T> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.query(collection, fromKey, toKey, limit);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(final Collection<T> collection, final String fromKey, final String toKey, final String indexedProperty, final long startValue, final int limit) {
        try {
            this.logMethod("query", collection, fromKey, toKey, indexedProperty, startValue, limit);
            return (List)this.logResult(new Callable<List<T>>(){

                @Override
                public List<T> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.query(collection, fromKey, toKey, indexedProperty, startValue, limit);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        try {
            this.logMethod("remove", collection, key);
            this.store.remove(collection, key);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        try {
            this.logMethod("remove", collection, keys);
            this.store.remove(collection, keys);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> int remove(final Collection<T> collection, final Map<String, Map<UpdateOp.Key, UpdateOp.Condition>> toRemove) {
        try {
            this.logMethod("remove", collection, toRemove);
            return this.logResult(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.remove(collection, toRemove);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> boolean create(final Collection<T> collection, final List<UpdateOp> updateOps) {
        try {
            this.logMethod("create", collection, updateOps);
            return this.logResult(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.create(collection, updateOps);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> void update(final Collection<T> collection, final List<String> keys, final UpdateOp updateOp) {
        try {
            this.logMethod("update", collection, keys, updateOp);
            this.logResult(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LoggingDocumentStoreWrapper.this.store.update(collection, keys, updateOp);
                    return null;
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    @Nonnull
    public <T extends Document> T createOrUpdate(final Collection<T> collection, final UpdateOp update) {
        try {
            this.logMethod("createOrUpdate", collection, update);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.createOrUpdate(collection, update);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> List<T> createOrUpdate(final Collection<T> collection, final List<UpdateOp> updateOps) {
        try {
            this.logMethod("createOrUpdate", collection, updateOps);
            return (List)this.logResult(new Callable<List<T>>(){

                @Override
                public List<T> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.createOrUpdate(collection, updateOps);
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> T findAndUpdate(final Collection<T> collection, final UpdateOp update) {
        try {
            this.logMethod("findAndUpdate", collection, update);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.findAndUpdate(collection, update);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        try {
            this.logMethod("invalidateCache", new Object[0]);
            return this.store.invalidateCache();
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        try {
            this.logMethod("invalidateCache", keys);
            return this.store.invalidateCache(keys);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
        try {
            this.logMethod("invalidateCache", collection, key);
            this.store.invalidateCache(collection, key);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public void dispose() {
        try {
            this.logMethod("dispose", new Object[0]);
            this.store.dispose();
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public <T extends Document> T getIfCached(final Collection<T> collection, final String key) {
        try {
            this.logMethod("getIfCached", collection, key);
            return (T)((Document)this.logResult(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.getIfCached(collection, key);
                }
            }));
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        try {
            this.logMethod("setReadWriteMode", readWriteMode);
            this.store.setReadWriteMode(readWriteMode);
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public Iterable<CacheStats> getCacheStats() {
        try {
            this.logMethod("getCacheStats", new Object[0]);
            return this.logResult(new Callable<Iterable<CacheStats>>(){

                @Override
                public Iterable<CacheStats> call() throws Exception {
                    return LoggingDocumentStoreWrapper.this.store.getCacheStats();
                }
            });
        }
        catch (Exception e) {
            this.logException(e);
            throw this.convert(e);
        }
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.store.getMetadata();
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        this.logMethod("determineServerTimeDifferenceMillis", "start");
        long result = this.store.determineServerTimeDifferenceMillis();
        this.logMethod("determineServerTimeDifferenceMillis", "end", result);
        return result;
    }

    private void logMethod(String methodName, Object ... args) {
        StringBuilder buff = new StringBuilder("ds");
        buff.append('.').append(methodName).append('(');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(LoggingDocumentStoreWrapper.quote(args[i]));
        }
        buff.append(");");
        this.log(buff.toString());
    }

    public static String quote(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return JsopBuilder.encode((String)o);
        }
        return o.toString();
    }

    private RuntimeException convert(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        this.log("// unexpected exception type: " + e.getClass().getName());
        return new DocumentStoreException("Unexpected exception: " + e.toString(), e);
    }

    private void logException(Exception e) {
        this.log("// exception: " + e.toString());
    }

    private <T> T logResult(Callable<T> callable) throws Exception {
        long time = System.nanoTime();
        T result = callable.call();
        time = System.nanoTime() - time;
        this.log("// " + time / 1000L + " us\t" + LoggingDocumentStoreWrapper.quote(result));
        return result;
    }

    private void log(String message) {
        String out;
        String string = out = this.logThread ? Thread.currentThread() + " " + message : message;
        if (DEBUG) {
            System.out.println(out);
        }
        LOG.info(out);
    }

    @Override
    public void updateAccessedRevision(RevisionVector revision) {
        this.logMethod("updateAccessedRevision", revision);
        if (this.store instanceof RevisionListener) {
            ((RevisionListener)((Object)this.store)).updateAccessedRevision(revision);
        }
    }
}

