/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStateCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreBuilder;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreCache;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreObserver;
import org.apache.jackrabbit.oak.plugins.index.PathFilter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Jackrabbit Oak DocumentNodeStateCache Provider", metatype=true, policy=ConfigurationPolicy.REQUIRE, description="Configures a DocumentNodeStateCache based on a secondary NodeStore")
public class SecondaryStoreCacheService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private BlobStore blobStore;
    @Reference(target="(role=secondary)")
    private NodeStoreProvider secondaryStoreProvider;
    @Reference
    private Executor executor;
    @Reference
    private StatisticsProvider statisticsProvider;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private DocumentNodeStore documentNodeStore;
    @Property(unbounded=PropertyUnbounded.ARRAY, label="Included Paths", description="List of paths which are to be included in the secondary store", value={"/"})
    private static final String PROP_INCLUDES = "includedPaths";
    private static final boolean PROP_ASYNC_OBSERVER_DEFAULT = true;
    @Property(boolValue={true}, label="Async Observation", description="Enable async observation processing")
    private static final String PROP_ASYNC_OBSERVER = "enableAsyncObserver";
    private static final int PROP_OBSERVER_QUEUE_SIZE_DEFAULT = 1000;
    @Property(intValue={1000}, label="Observer queue size", description="Observer queue size. Used if 'enableAsyncObserver' is set to true")
    private static final String PROP_OBSERVER_QUEUE_SIZE = "observerQueueSize";
    private final List<Registration> oakRegs = Lists.newArrayList();
    private final List<ServiceRegistration> regs = Lists.newArrayList();
    private Whiteboard whiteboard;
    private BundleContext bundleContext;
    private PathFilter pathFilter;
    private final MultiplexingNodeStateDiffer differ = new MultiplexingNodeStateDiffer();

    @Activate
    private void activate(BundleContext context, Map<String, Object> config) {
        this.bundleContext = context;
        this.whiteboard = new OsgiWhiteboard(context);
        String[] includedPaths = PropertiesUtil.toStringArray(config.get(PROP_INCLUDES), new String[]{"/"});
        this.pathFilter = new PathFilter(Arrays.asList(includedPaths), Collections.emptyList());
        SecondaryStoreBuilder builder = new SecondaryStoreBuilder(this.secondaryStoreProvider.getNodeStore()).differ(this.differ).statisticsProvider(this.statisticsProvider).pathFilter(this.pathFilter);
        SecondaryStoreCache cache = builder.buildCache();
        SecondaryStoreObserver observer = builder.buildObserver(cache);
        this.registerObserver(observer, config);
        this.regs.add(this.bundleContext.registerService(DocumentNodeStateCache.class.getName(), (Object)cache, null));
    }

    @Deactivate
    private void deactivate() {
        for (Registration registration : this.oakRegs) {
            registration.unregister();
        }
        for (ServiceRegistration serviceRegistration : this.regs) {
            serviceRegistration.unregister();
        }
    }

    PathFilter getPathFilter() {
        return this.pathFilter;
    }

    protected void bindDocumentNodeStore(DocumentNodeStore documentNodeStore) {
        this.log.info("Registering DocumentNodeStore as the differ");
        this.differ.setDelegate(documentNodeStore);
    }

    protected void unbindDocumentNodeStore(DocumentNodeStore documentNodeStore) {
        this.differ.setDelegate(NodeStateDiffer.DEFAULT_DIFFER);
    }

    private void registerObserver(Observer observer, Map<String, Object> config) {
        boolean enableAsyncObserver = PropertiesUtil.toBoolean(config.get(PROP_ASYNC_OBSERVER), true);
        int queueSize = PropertiesUtil.toInteger(config.get(PROP_OBSERVER_QUEUE_SIZE), 1000);
        if (enableAsyncObserver) {
            BackgroundObserver bgObserver = new BackgroundObserver(observer, this.executor, queueSize);
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, BackgroundObserverMBean.class, bgObserver.getMBean(), "BackgroundObserverStats", "Secondary NodeStore observer stats"));
            observer = bgObserver;
            this.log.info("Configuring the observer for secondary NodeStore as Background Observer with queue size {}", (Object)queueSize);
        }
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", 10000);
        this.regs.add(this.bundleContext.registerService(Observer.class.getName(), (Object)observer, props));
    }

    protected void bindBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    protected void unbindBlobStore(BlobStore blobStore) {
        if (this.blobStore == blobStore) {
            this.blobStore = null;
        }
    }

    protected void bindSecondaryStoreProvider(NodeStoreProvider nodeStoreProvider) {
        this.secondaryStoreProvider = nodeStoreProvider;
    }

    protected void unbindSecondaryStoreProvider(NodeStoreProvider nodeStoreProvider) {
        if (this.secondaryStoreProvider == nodeStoreProvider) {
            this.secondaryStoreProvider = null;
        }
    }

    protected void bindExecutor(Executor executor) {
        this.executor = executor;
    }

    protected void unbindExecutor(Executor executor) {
        if (this.executor == executor) {
            this.executor = null;
        }
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }

    private static class MultiplexingNodeStateDiffer
    implements NodeStateDiffer {
        private volatile NodeStateDiffer delegate = NodeStateDiffer.DEFAULT_DIFFER;

        private MultiplexingNodeStateDiffer() {
        }

        @Override
        public boolean compare(@Nonnull AbstractDocumentNodeState node, @Nonnull AbstractDocumentNodeState base, @Nonnull NodeStateDiff diff) {
            return this.delegate.compare(node, base, diff);
        }

        public void setDelegate(NodeStateDiffer delegate) {
            this.delegate = delegate;
        }
    }
}

