/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.index.PathFilter;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PathFilteringDiff
extends ApplyDiff {
    private static final Logger logger = LoggerFactory.getLogger(PathFilteringDiff.class);
    private final DiffContext ctx;
    private final AbstractDocumentNodeState parent;

    public PathFilteringDiff(NodeBuilder builder, PathFilter pathFilter, AbstractDocumentNodeState parent) {
        this(builder, new DiffContext(pathFilter), parent);
    }

    private PathFilteringDiff(NodeBuilder builder, DiffContext ctx, AbstractDocumentNodeState parent) {
        super(builder);
        this.ctx = ctx;
        this.parent = parent;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        AbstractDocumentNodeState afterDoc = this.asDocumentState(after, name);
        String nextPath = afterDoc.getPath();
        PathFilter.Result result = this.ctx.pathFilter.filter(nextPath);
        if (result == PathFilter.Result.EXCLUDE) {
            return true;
        }
        this.ctx.traversingNode(nextPath);
        NodeBuilder childBuilder = this.builder.child(name);
        PathFilteringDiff.copyMetaProperties(afterDoc, childBuilder);
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, new PathFilteringDiff(childBuilder, this.ctx, afterDoc));
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        AbstractDocumentNodeState afterDoc = this.asDocumentState(after, name);
        String nextPath = afterDoc.getPath();
        if (this.ctx.pathFilter.filter(nextPath) != PathFilter.Result.EXCLUDE) {
            this.ctx.traversingNode(nextPath);
            NodeBuilder childBuilder = this.builder.getChildNode(name);
            PathFilteringDiff.copyMetaProperties(afterDoc, childBuilder);
            return after.compareAgainstBaseState(before, new PathFilteringDiff(this.builder.getChildNode(name), this.ctx, afterDoc));
        }
        return true;
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        String path = this.asDocumentState(before, name).getPath();
        if (this.ctx.pathFilter.filter(path) != PathFilter.Result.EXCLUDE) {
            return super.childNodeDeleted(name, before);
        }
        return true;
    }

    private AbstractDocumentNodeState asDocumentState(NodeState state, String name) {
        Preconditions.checkArgument(state instanceof AbstractDocumentNodeState, "Node %s (%s) at [%s/%s] is not of expected type i.e. AbstractDocumentNodeState. Parent %s (%s)", state, state.getClass(), this.parent.getPath(), name, this.parent, this.parent.getClass());
        return (AbstractDocumentNodeState)state;
    }

    static void copyMetaProperties(AbstractDocumentNodeState state, NodeBuilder builder) {
        builder.setProperty(PathFilteringDiff.asPropertyState(":doc-rev", state.getRootRevision()));
        builder.setProperty(PathFilteringDiff.asPropertyState(":doc-lastRev", state.getLastRevision()));
        builder.setProperty(PropertyStates.createProperty(":doc-path", state.getPath()));
    }

    private static PropertyState asPropertyState(String name, RevisionVector revision) {
        return PropertyStates.createProperty(name, revision.asString());
    }

    private static class DiffContext {
        private long count;
        final PathFilter pathFilter;

        public DiffContext(PathFilter filter) {
            this.pathFilter = filter;
        }

        public void traversingNode(String path) {
            if (++this.count % 10000L == 0L) {
                logger.info("Updating Secondary Store. Traversed #{} - {}", (Object)this.count, (Object)path);
            }
        }
    }
}

