/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class DelegatingDocumentNodeState
extends AbstractDocumentNodeState {
    static final String PROP_PATH = ":doc-path";
    static final String PROP_REVISION = ":doc-rev";
    static final String PROP_LAST_REV = ":doc-lastRev";
    private static final int META_PROP_COUNT = 3;
    private static final Predicate<PropertyState> NOT_META_PROPS = new Predicate<PropertyState>(){

        @Override
        public boolean apply(PropertyState input) {
            return !input.getName().startsWith(":doc-");
        }
    };
    private final NodeStateDiffer differ;
    private final NodeState delegate;
    private final RevisionVector rootRevision;
    private final boolean fromExternalChange;
    private RevisionVector lastRevision;
    private String path;

    public static NodeState wrapIfPossible(NodeState delegate, NodeStateDiffer differ) {
        if (DelegatingDocumentNodeState.hasMetaProps(delegate)) {
            String revVector = DelegatingDocumentNodeState.getRequiredProp(delegate, PROP_REVISION);
            return new DelegatingDocumentNodeState(delegate, RevisionVector.fromString(revVector), false, differ);
        }
        return delegate;
    }

    public static boolean hasMetaProps(NodeState delegate) {
        return delegate.hasProperty(PROP_REVISION);
    }

    public static AbstractDocumentNodeState wrap(NodeState delegate, NodeStateDiffer differ) {
        String revVector = DelegatingDocumentNodeState.getRequiredProp(delegate, PROP_REVISION);
        return new DelegatingDocumentNodeState(delegate, RevisionVector.fromString(revVector), false, differ);
    }

    private DelegatingDocumentNodeState(NodeState delegate, RevisionVector rootRevision, boolean fromExternalChange, NodeStateDiffer differ) {
        this.differ = differ;
        this.delegate = delegate;
        this.rootRevision = rootRevision;
        this.fromExternalChange = fromExternalChange;
    }

    private DelegatingDocumentNodeState(DelegatingDocumentNodeState original, RevisionVector rootRevision, boolean fromExternalChange) {
        this.differ = original.differ;
        this.delegate = original.delegate;
        this.rootRevision = rootRevision;
        this.fromExternalChange = fromExternalChange;
        this.path = original.path;
        this.lastRevision = original.lastRevision;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.getRequiredProp(PROP_PATH);
        }
        return this.path;
    }

    @Override
    public RevisionVector getLastRevision() {
        if (this.lastRevision == null) {
            this.lastRevision = RevisionVector.fromString(this.getRequiredProp(PROP_LAST_REV));
        }
        return this.lastRevision;
    }

    @Override
    public RevisionVector getRootRevision() {
        return this.rootRevision;
    }

    @Override
    public boolean isFromExternalChange() {
        return this.fromExternalChange;
    }

    @Override
    public AbstractDocumentNodeState withRootRevision(@Nonnull RevisionVector root, boolean externalChange) {
        if (this.rootRevision.equals(root) && this.fromExternalChange == externalChange) {
            return this;
        }
        return new DelegatingDocumentNodeState(this, root, externalChange);
    }

    @Override
    public boolean hasNoChildren() {
        return this.delegate.getChildNodeCount(1L) == 0L;
    }

    @Override
    protected NodeStateDiffer getNodeStateDiffer() {
        return this.differ;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return Iterables.filter(this.delegate.getProperties(), NOT_META_PROPS);
    }

    @Override
    public boolean hasChildNode(@Nonnull String name) {
        return this.delegate.hasChildNode(name);
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) throws IllegalArgumentException {
        return this.decorate(this.delegate.getChildNode(name));
    }

    @Override
    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        return Iterables.transform(this.delegate.getChildNodeEntries(), new Function<ChildNodeEntry, ChildNodeEntry>(){

            @Override
            @Nullable
            public ChildNodeEntry apply(ChildNodeEntry input) {
                return new MemoryChildNodeEntry(input.getName(), DelegatingDocumentNodeState.this.decorate(input.getNodeState()));
            }
        });
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        Preconditions.checkState(!PathUtils.denotesRoot(this.getPath()), "Builder cannot be opened for root path for state of type [%s]", this.delegate.getClass());
        return new MemoryNodeBuilder(this);
    }

    @Override
    public PropertyState getProperty(@Nonnull String name) {
        return this.delegate.getProperty(name);
    }

    @Override
    public long getPropertyCount() {
        return this.delegate.getPropertyCount() - 3L;
    }

    @Override
    public boolean hasProperty(@Nonnull String name) {
        return this.delegate.hasProperty(name);
    }

    @Override
    public boolean getBoolean(@Nonnull String name) {
        return this.delegate.getBoolean(name);
    }

    @Override
    public long getLong(String name) {
        return this.delegate.getLong(name);
    }

    @Override
    public String getString(String name) {
        return this.delegate.getString(name);
    }

    @Override
    @Nonnull
    public Iterable<String> getStrings(@Nonnull String name) {
        return this.delegate.getStrings(name);
    }

    @Override
    public String getName(@Nonnull String name) {
        return this.delegate.getName(name);
    }

    @Override
    @Nonnull
    public Iterable<String> getNames(@Nonnull String name) {
        return this.delegate.getNames(name);
    }

    @Override
    public long getChildNodeCount(long max) {
        return this.delegate.getChildNodeCount(max);
    }

    @Override
    public Iterable<String> getChildNodeNames() {
        return this.delegate.getChildNodeNames();
    }

    private NodeState decorate(NodeState childNode) {
        if (childNode.exists()) {
            return new DelegatingDocumentNodeState(childNode, this.rootRevision, this.fromExternalChange, this.differ);
        }
        return childNode;
    }

    private String getRequiredProp(String name) {
        return DelegatingDocumentNodeState.getRequiredProp(this.delegate, name);
    }

    private static String getRequiredProp(NodeState state, String name) {
        return Preconditions.checkNotNull(state.getString(name), "No property [%s] found in [%s]", name, state);
    }
}

