/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;

public class RDBVersionGCSupport
extends VersionGCSupport {
    private RDBDocumentStore store;

    public RDBVersionGCSupport(RDBDocumentStore store) {
        super(store);
        this.store = store;
    }

    @Override
    public Iterable<NodeDocument> getPossiblyDeletedDocs(long lastModifiedTime) {
        ArrayList<RDBDocumentStore.QueryCondition> conditions = new ArrayList<RDBDocumentStore.QueryCondition>();
        conditions.add(new RDBDocumentStore.QueryCondition("_deletedOnce", "=", 1L));
        conditions.add(new RDBDocumentStore.QueryCondition("_modified", "<", NodeDocument.getModifiedInSecs(lastModifiedTime)));
        return this.getIterator(RDBDocumentStore.EMPTY_KEY_PATTERN, conditions);
    }

    private Iterable<NodeDocument> getSplitDocuments() {
        List<RDBDocumentStore.QueryCondition> conditions = Collections.emptyList();
        List<String> excludeKeyPatterns = Arrays.asList("_:/%", "__:/%", "___:/%");
        return this.getIterator(excludeKeyPatterns, conditions);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(final Set<NodeDocument.SplitDocType> gcTypes, final long oldestRevTimeStamp) {
        return Iterables.filter(this.getSplitDocuments(), new Predicate<NodeDocument>(){

            @Override
            public boolean apply(NodeDocument doc) {
                return gcTypes.contains((Object)doc.getSplitDocType()) && doc.hasAllRevisionLessThan(oldestRevTimeStamp);
            }
        });
    }

    private Iterable<NodeDocument> getIterator(final List<String> excludeKeyPatterns, final List<RDBDocumentStore.QueryCondition> conditions) {
        return new Iterable<NodeDocument>(){

            @Override
            public Iterator<NodeDocument> iterator() {
                return new AbstractIterator<NodeDocument>(){
                    private static final int BATCH_SIZE = 100;
                    private String startId = "0000000";
                    private Iterator<NodeDocument> batch = this.nextBatch();

                    @Override
                    protected NodeDocument computeNext() {
                        NodeDocument doc;
                        if (!this.batch.hasNext()) {
                            this.batch = this.nextBatch();
                        }
                        if (this.batch.hasNext()) {
                            doc = this.batch.next();
                            this.startId = doc.getId();
                        } else {
                            doc = (NodeDocument)this.endOfData();
                        }
                        return doc;
                    }

                    private Iterator<NodeDocument> nextBatch() {
                        List<NodeDocument> result = RDBVersionGCSupport.this.store.query(Collection.NODES, this.startId, ";", excludeKeyPatterns, conditions, 100);
                        return result.iterator();
                    }
                };
            }
        };
    }
}

