/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentSerializer;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDocumentStoreJDBC {
    private static final Logger LOG = LoggerFactory.getLogger(RDBDocumentStoreJDBC.class);
    private static final String COLLISIONSMODCOUNT = "_collisionsModCount";
    private static final String MODCOUNT = "_modCount";
    private static final String MODIFIED = "_modified";
    private final RDBDocumentStoreDB dbInfo;
    private final RDBDocumentSerializer ser;
    private final int queryHitsLimit;
    private final int queryTimeLimit;
    private static final Map<String, String> INDEXED_PROP_MAPPING;
    private static final Set<String> SUPPORTED_OPS;
    private static final Function<Document, String> idExtractor;

    public RDBDocumentStoreJDBC(RDBDocumentStoreDB dbInfo, RDBDocumentSerializer ser, int queryHitsLimit, int queryTimeLimit) {
        this.dbInfo = dbInfo;
        this.ser = ser;
        this.queryHitsLimit = queryHitsLimit;
        this.queryTimeLimit = queryTimeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendingUpdate(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String id, Long modified, boolean setModifiedConditionally, Boolean hasBinary, Boolean deletedOnce, Long modcount, Long cmodcount, Long oldmodcount, String appendData) throws SQLException {
        String appendDataWithComma = "," + appendData;
        RDBJDBCTools.PreparedStatementComponent stringAppend = this.dbInfo.getConcatQuery(appendDataWithComma, tmd.getDataLimitInOctets());
        StringBuilder t = new StringBuilder();
        t.append("update " + tmd.getName() + " set ");
        t.append(setModifiedConditionally ? "MODIFIED = case when ? > MODIFIED then ? else MODIFIED end, " : "MODIFIED = ?, ");
        t.append("HASBINARY = ?, DELETEDONCE = ?, MODCOUNT = ?, CMODCOUNT = ?, DSIZE = DSIZE + ?, ");
        t.append("DATA = " + stringAppend.getStatementComponent() + " ");
        t.append("where ID = ?");
        if (oldmodcount != null) {
            t.append(" and MODCOUNT = ?");
        }
        try (PreparedStatement stmt = connection.prepareStatement(t.toString());){
            int result;
            int si = 1;
            stmt.setObject(si++, (Object)modified, -5);
            if (setModifiedConditionally) {
                stmt.setObject(si++, (Object)modified, -5);
            }
            stmt.setObject(si++, (Object)(hasBinary != false ? 1 : 0), 5);
            stmt.setObject(si++, (Object)(deletedOnce != false ? 1 : 0), 5);
            stmt.setObject(si++, (Object)modcount, -5);
            stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
            stmt.setObject(si++, (Object)appendDataWithComma.length(), -5);
            si = stringAppend.setParameters(stmt, si);
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, id);
            if (oldmodcount != null) {
                stmt.setObject(si++, (Object)oldmodcount, -5);
            }
            if ((result = stmt.executeUpdate()) != 1) {
                LOG.debug("DB append update failed for " + tmd.getName() + "/" + id + " with oldmodcount=" + oldmodcount);
            }
            boolean bl = result == 1;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchedAppendingUpdate(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<String> allIds, Long modified, boolean setModifiedConditionally, String appendData) throws SQLException {
        boolean result = true;
        for (List<String> ids : Lists.partition(allIds, RDBJDBCTools.MAX_IN_CLAUSE)) {
            String appendDataWithComma = "," + appendData;
            RDBJDBCTools.PreparedStatementComponent stringAppend = this.dbInfo.getConcatQuery(appendDataWithComma, tmd.getDataLimitInOctets());
            RDBJDBCTools.PreparedStatementComponent inClause = RDBJDBCTools.createInStatement("ID", ids, tmd.isIdBinary());
            StringBuilder t = new StringBuilder();
            t.append("update " + tmd.getName() + " set ");
            t.append(setModifiedConditionally ? "MODIFIED = case when ? > MODIFIED then ? else MODIFIED end, " : "MODIFIED = ?, ");
            t.append("MODCOUNT = MODCOUNT + 1, DSIZE = DSIZE + ?, ");
            t.append("DATA = " + stringAppend.getStatementComponent() + " ");
            t.append("where ").append(inClause.getStatementComponent());
            try (PreparedStatement stmt = connection.prepareStatement(t.toString());){
                int si = 1;
                stmt.setObject(si++, (Object)modified, -5);
                if (setModifiedConditionally) {
                    stmt.setObject(si++, (Object)modified, -5);
                }
                stmt.setObject(si++, (Object)appendDataWithComma.length(), -5);
                si = stringAppend.setParameters(stmt, si);
                si = inClause.setParameters(stmt, si);
                int count = stmt.executeUpdate();
                if (count == ids.size()) continue;
                LOG.debug("DB update failed: only " + result + " of " + ids.size() + " updated. Table: " + tmd.getName() + ", IDs:" + ids);
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<String> allIds) throws SQLException {
        int count = 0;
        for (List<String> ids : Lists.partition(allIds, RDBJDBCTools.MAX_IN_CLAUSE)) {
            RDBJDBCTools.PreparedStatementComponent inClause = RDBJDBCTools.createInStatement("ID", ids, tmd.isIdBinary());
            String sql = "delete from " + tmd.getName() + " where " + inClause.getStatementComponent();
            try (PreparedStatement stmt = connection.prepareStatement(sql);){
                inClause.setParameters(stmt, 1);
                int result = stmt.executeUpdate();
                if (result != ids.size()) {
                    LOG.debug("DB delete failed for " + tmd.getName() + "/" + ids);
                }
                count += result;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, Map<String, Map<UpdateOp.Key, UpdateOp.Condition>> toDelete) throws SQLException, DocumentStoreException {
        String or = "";
        StringBuilder whereClause = new StringBuilder();
        for (Map.Entry<String, Map<UpdateOp.Key, UpdateOp.Condition>> entry : toDelete.entrySet()) {
            whereClause.append(or);
            or = " or ";
            whereClause.append("ID=?");
            for (Map.Entry<Object, Object> entry2 : entry.getValue().entrySet()) {
                if (!((UpdateOp.Key)entry2.getKey()).getName().equals(MODIFIED)) {
                    throw new DocumentStoreException("Unsupported condition: " + entry2);
                }
                whereClause.append(" and MODIFIED");
                if (((UpdateOp.Condition)entry2.getValue()).type == UpdateOp.Condition.Type.EQUALS && ((UpdateOp.Condition)entry2.getValue()).value instanceof Long) {
                    whereClause.append("=?");
                    continue;
                }
                if (((UpdateOp.Condition)entry2.getValue()).type == UpdateOp.Condition.Type.EXISTS) {
                    whereClause.append(" is not null");
                    continue;
                }
                throw new DocumentStoreException("Unsupported condition: " + entry2);
            }
        }
        try (PreparedStatement stmt = connection.prepareStatement("delete from " + tmd.getName() + " where " + whereClause);){
            int i = 1;
            for (Map.Entry<Object, Object> entry : toDelete.entrySet()) {
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, i++, (String)entry.getKey());
                for (Map.Entry c : ((Map)entry.getValue()).entrySet()) {
                    if (((UpdateOp.Condition)c.getValue()).type != UpdateOp.Condition.Type.EQUALS) continue;
                    stmt.setLong(i++, (Long)((UpdateOp.Condition)c.getValue()).value);
                }
            }
            int n = stmt.executeUpdate();
            return n;
        }
    }

    public long determineServerTimeDifferenceMillis(Connection connection) {
        ResultSet rs;
        PreparedStatement stmt;
        block8: {
            String sql = this.dbInfo.getCurrentTimeStampInSecondsSyntax();
            if (sql.isEmpty()) {
                LOG.debug("{}: unsupported database, skipping DB server time check", (Object)this.dbInfo.toString());
                return 0L;
            }
            stmt = null;
            rs = null;
            stmt = connection.prepareStatement(sql);
            long start = System.currentTimeMillis();
            rs = stmt.executeQuery();
            if (!rs.next()) break block8;
            long roundtrip = System.currentTimeMillis() - start;
            long serverTimeSec = rs.getInt(1);
            long roundedTimeSec = (start + roundtrip / 2L + 500L) / 1000L;
            long resultSec = roundedTimeSec - serverTimeSec;
            String message = String.format("instance timestamp: %d, DB timestamp: %d, difference: %d", roundedTimeSec, serverTimeSec, resultSec);
            if (Math.abs(resultSec) >= 2L) {
                LOG.info(message);
            } else {
                LOG.debug(message);
            }
            long l = resultSec * 1000L;
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
            return l;
        }
        try {
            try {
                throw new DocumentStoreException("failed to determine server timestamp");
            }
            catch (Exception ex) {
                LOG.error("Trying to determine time difference to server", ex);
                throw new DocumentStoreException(ex);
            }
        }
        catch (Throwable throwable) {
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Document> Set<String> insert(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<T> documents) throws SQLException {
        int[] results;
        List<Document> sortedDocs = RDBDocumentStoreJDBC.sortDocuments(documents);
        try (PreparedStatement stmt = connection.prepareStatement("insert into " + tmd.getName() + "(ID, MODIFIED, HASBINARY, DELETEDONCE, MODCOUNT, CMODCOUNT, DSIZE, DATA, BDATA) " + "values (?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            for (Document document : sortedDocs) {
                String data = this.ser.asString(document);
                String id = document.getId();
                Number hasBinary = (Number)document.get("_bin");
                Boolean deletedOnce = (Boolean)document.get("_deletedOnce");
                Long cmodcount = (Long)document.get(COLLISIONSMODCOUNT);
                int si = 1;
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, id);
                stmt.setObject(si++, document.get(MODIFIED), -5);
                stmt.setObject(si++, (Object)(hasBinary != null && (long)hasBinary.intValue() == 1L ? 1 : 0), 5);
                stmt.setObject(si++, (Object)(deletedOnce != null && deletedOnce != false ? 1 : 0), 5);
                stmt.setObject(si++, document.get(MODCOUNT), -5);
                stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
                stmt.setObject(si++, (Object)data.length(), -5);
                if (data.length() < tmd.getDataLimitInOctets() / 3) {
                    stmt.setString(si++, data);
                    stmt.setBinaryStream(si++, (InputStream)null, 0);
                } else {
                    stmt.setString(si++, "\"blob\"");
                    byte[] bytes = RDBDocumentStore.asBytes(data);
                    stmt.setBytes(si++, bytes);
                }
                stmt.addBatch();
            }
            results = stmt.executeBatch();
        }
        HashSet<String> succesfullyInserted = new HashSet<String>();
        for (int i = 0; i < results.length; ++i) {
            int result = results[i];
            if (result != 1 && result != -2) {
                LOG.debug("DB insert failed for {}: {}", (Object)tmd.getName(), (Object)sortedDocs.get(i).getId());
                continue;
            }
            succesfullyInserted.add(sortedDocs.get(i).getId());
        }
        return succesfullyInserted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Document> Set<String> update(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, List<T> documents, boolean upsert) throws SQLException {
        RDBDocumentStoreJDBC.assertNoDuplicatedIds(documents);
        HashSet<String> successfulUpdates = new HashSet<String>();
        ArrayList<String> updatedKeys = new ArrayList<String>();
        int[] batchResults = new int[]{};
        try (PreparedStatement stmt = connection.prepareStatement("update " + tmd.getName() + " set MODIFIED = ?, HASBINARY = ?, DELETEDONCE = ?, MODCOUNT = ?, CMODCOUNT = ?, DSIZE = ?, DATA = ?, BDATA = ? where ID = ? and MODCOUNT = ?");){
            boolean batchIsEmpty = true;
            for (Document document : RDBDocumentStoreJDBC.sortDocuments(documents)) {
                Long modcount = (Long)document.get(MODCOUNT);
                if (modcount == 1L) continue;
                String data = this.ser.asString(document);
                Number hasBinary = (Number)document.get("_bin");
                Boolean deletedOnce = (Boolean)document.get("_deletedOnce");
                Long cmodcount = (Long)document.get(COLLISIONSMODCOUNT);
                int si = 1;
                stmt.setObject(si++, document.get(MODIFIED), -5);
                stmt.setObject(si++, (Object)(hasBinary != null && (long)hasBinary.intValue() == 1L ? 1 : 0), 5);
                stmt.setObject(si++, (Object)(deletedOnce != null && deletedOnce != false ? 1 : 0), 5);
                stmt.setObject(si++, (Object)modcount, -5);
                stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
                stmt.setObject(si++, (Object)data.length(), -5);
                if (data.length() < tmd.getDataLimitInOctets() / 3) {
                    stmt.setString(si++, data);
                    stmt.setBinaryStream(si++, (InputStream)null, 0);
                } else {
                    stmt.setString(si++, "\"blob\"");
                    byte[] bytes = RDBDocumentStore.asBytes(data);
                    stmt.setBytes(si++, bytes);
                }
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, document.getId());
                stmt.setObject(si++, (Object)(modcount - 1L), -5);
                stmt.addBatch();
                updatedKeys.add(document.getId());
                batchIsEmpty = false;
            }
            if (!batchIsEmpty) {
                batchResults = stmt.executeBatch();
                connection.commit();
            }
        }
        for (int i = 0; i < batchResults.length; ++i) {
            int result = batchResults[i];
            if (result != 1 && result != -2) continue;
            successfulUpdates.add((String)updatedKeys.get(i));
        }
        if (upsert) {
            ArrayList<Document> toBeInserted = new ArrayList<Document>(documents.size());
            for (Document doc : documents) {
                if ((Long)doc.get(MODCOUNT) != 1L) continue;
                toBeInserted.add(doc);
            }
            if (!toBeInserted.isEmpty()) {
                for (String id : this.insert(connection, tmd, toBeInserted)) {
                    successfulUpdates.add(id);
                }
            }
        }
        return successfulUpdates;
    }

    private static <T extends Document> void assertNoDuplicatedIds(List<T> documents) {
        if (Sets.newHashSet(Iterables.transform(documents, idExtractor)).size() < documents.size()) {
            throw new IllegalArgumentException("There are duplicated ids in the document list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<RDBRow> query(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String minId, String maxId, List<String> excludeKeyPatterns, List<RDBDocumentStore.QueryCondition> conditions, int limit) throws SQLException {
        long start = System.currentTimeMillis();
        StringBuilder selectClause = new StringBuilder();
        StringBuilder whereClause = new StringBuilder();
        if (limit != Integer.MAX_VALUE && this.dbInfo.getFetchFirstSyntax() == RDBDocumentStoreDB.FETCHFIRSTSYNTAX.TOP) {
            selectClause.append("TOP " + limit + " ");
        }
        selectClause.append("ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, DATA, BDATA from ").append(tmd.getName());
        String whereSep = "";
        if (minId != null) {
            whereClause.append("ID > ?");
            whereSep = " and ";
        }
        if (maxId != null) {
            whereClause.append(whereSep).append("ID < ?");
            whereSep = " and ";
        }
        if (!excludeKeyPatterns.isEmpty()) {
            whereClause.append(whereSep);
            whereSep = " and ";
            whereClause.append("not (");
            for (int i = 0; i < excludeKeyPatterns.size(); ++i) {
                whereClause.append(i == 0 ? "" : " or ");
                whereClause.append("ID like ?");
            }
            whereClause.append(")");
        }
        for (RDBDocumentStore.QueryCondition cond : conditions) {
            String op = cond.getOperator();
            if (!SUPPORTED_OPS.contains(op)) {
                throw new DocumentStoreException("unsupported operator: " + op);
            }
            String indexedProperty = cond.getPropertyName();
            String column = INDEXED_PROP_MAPPING.get(indexedProperty);
            if (column != null) {
                whereClause.append(whereSep).append(column).append(" ").append(op).append(" ?");
                whereSep = " and ";
                continue;
            }
            throw new DocumentStoreException("unsupported indexed property: " + indexedProperty);
        }
        StringBuilder query = new StringBuilder();
        query.append("select ").append((CharSequence)selectClause);
        if (whereClause.length() != 0) {
            query.append(" where ").append((CharSequence)whereClause);
        }
        query.append(" order by ID");
        if (limit != Integer.MAX_VALUE) {
            switch (this.dbInfo.getFetchFirstSyntax()) {
                case LIMIT: {
                    query.append(" LIMIT " + limit);
                    break;
                }
                case FETCHFIRST: {
                    query.append(" FETCH FIRST " + limit + " ROWS ONLY");
                    break;
                }
            }
        }
        PreparedStatement stmt = connection.prepareStatement(query.toString());
        ResultSet rs = null;
        ArrayList<RDBRow> result = new ArrayList<RDBRow>();
        long dataTotal = 0L;
        long bdataTotal = 0L;
        try {
            int si = 1;
            if (minId != null) {
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, minId);
            }
            if (maxId != null) {
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, maxId);
            }
            for (String keyPattern : excludeKeyPatterns) {
                RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, keyPattern);
            }
            for (RDBDocumentStore.QueryCondition cond : conditions) {
                stmt.setLong(si++, cond.getValue());
            }
            if (limit != Integer.MAX_VALUE) {
                stmt.setFetchSize(limit);
            }
            rs = stmt.executeQuery();
            while (rs.next() && result.size() < limit) {
                String id = RDBDocumentStoreJDBC.getIdFromRS(tmd, rs, 1);
                if (minId != null && id.compareTo(minId) < 0 || maxId != null && id.compareTo(maxId) > 0) {
                    throw new DocumentStoreException("unexpected query result: '" + minId + "' < '" + id + "' < '" + maxId + "' - broken DB collation?");
                }
                long modified = RDBDocumentStoreJDBC.readLongFromResultSet(rs, 2);
                long modcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, 3);
                long cmodcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, 4);
                long hasBinary = rs.getLong(5);
                long deletedOnce = rs.getLong(6);
                String data = rs.getString(7);
                byte[] bdata = rs.getBytes(8);
                result.add(new RDBRow(id, hasBinary == 1L, deletedOnce == 1L, modified, modcount, cmodcount, data, bdata));
                dataTotal += (long)data.length();
                bdataTotal += bdata == null ? 0L : (long)bdata.length;
            }
        }
        catch (Throwable throwable) {
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
            throw throwable;
        }
        RDBJDBCTools.closeResultSet(rs);
        RDBJDBCTools.closeStatement(stmt);
        long elapsed = System.currentTimeMillis() - start;
        if (this.queryHitsLimit != 0 && result.size() > this.queryHitsLimit) {
            String message = String.format("Potentially excessive query on %s with %d hits (limited to %d, configured QUERYHITSLIMIT %d), elapsed time %dms, params minid '%s' maxid '%s' excludeKeyPatterns %s condition %s limit %d. Read %d chars from DATA and %d bytes from BDATA. Check calling method.", tmd.getName(), result.size(), limit, this.queryHitsLimit, elapsed, minId, maxId, excludeKeyPatterns, conditions, limit, dataTotal, bdataTotal);
            LOG.info(message, new Exception("call stack"));
        } else if (this.queryTimeLimit != 0 && elapsed > (long)this.queryTimeLimit) {
            String message = String.format("Long running query on %s with %d hits (limited to %d), elapsed time %dms (configured QUERYTIMELIMIT %d), params minid '%s' maxid '%s' excludeKeyPatterns %s conditions %s limit %d. Read %d chars from DATA and %d bytes from BDATA. Check calling method.", tmd.getName(), result.size(), limit, elapsed, this.queryTimeLimit, minId, maxId, excludeKeyPatterns, conditions, limit, dataTotal, bdataTotal);
            LOG.info(message, new Exception("call stack"));
        }
        return result;
    }

    public List<RDBRow> read(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, Collection<String> allKeys) throws SQLException {
        ArrayList<RDBRow> rows = new ArrayList<RDBRow>();
        for (List<String> keys : Iterables.partition(allKeys, RDBJDBCTools.MAX_IN_CLAUSE)) {
            RDBJDBCTools.PreparedStatementComponent inClause = RDBJDBCTools.createInStatement("ID", keys, tmd.isIdBinary());
            StringBuilder query = new StringBuilder();
            query.append("select ID, MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, DATA, BDATA from ");
            query.append(tmd.getName());
            query.append(" where ").append(inClause.getStatementComponent());
            PreparedStatement stmt = connection.prepareStatement(query.toString());
            ResultSet rs = null;
            stmt.setPoolable(false);
            try {
                inClause.setParameters(stmt, 1);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int col = 1;
                    String id = RDBDocumentStoreJDBC.getIdFromRS(tmd, rs, col++);
                    long modified = RDBDocumentStoreJDBC.readLongFromResultSet(rs, col++);
                    long modcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, col++);
                    long cmodcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, col++);
                    long hasBinary = rs.getLong(col++);
                    long deletedOnce = rs.getLong(col++);
                    String data = rs.getString(col++);
                    byte[] bdata = rs.getBytes(col++);
                    RDBRow row = new RDBRow(id, hasBinary == 1L, deletedOnce == 1L, modified, modcount, cmodcount, data, bdata);
                    rows.add(row);
                }
            }
            catch (SQLException ex) {
                block9: {
                    List<RDBRow> list;
                    try {
                        LOG.debug("attempting to read " + keys, ex);
                        if (!"22001".equals(ex.getSQLState())) break block9;
                        try {
                            connection.rollback();
                        }
                        catch (SQLException ex2) {
                            LOG.debug("failed to rollback", ex2);
                        }
                        list = null;
                    }
                    catch (Throwable throwable) {
                        RDBJDBCTools.closeResultSet(rs);
                        RDBJDBCTools.closeStatement(stmt);
                        throw throwable;
                    }
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    return list;
                }
                throw ex;
            }
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
        }
        return rows;
    }

    @CheckForNull
    public RDBRow read(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String id, long lastmodcount, long lastmodified) throws SQLException {
        RDBRow modified2;
        ResultSet rs;
        PreparedStatement stmt;
        block11: {
            boolean useCaseStatement = lastmodcount != -1L && this.dbInfo.allowsCaseInSelect();
            StringBuffer sql = new StringBuffer();
            sql.append("select MODIFIED, MODCOUNT, CMODCOUNT, HASBINARY, DELETEDONCE, ");
            if (useCaseStatement) {
                sql.append("case when (MODCOUNT = ? and MODIFIED = ?) then null else DATA end as DATA, ");
                sql.append("case when (MODCOUNT = ? and MODIFIED = ?) then null else BDATA end as BDATA ");
            } else {
                sql.append("DATA, BDATA ");
            }
            sql.append("from " + tmd.getName() + " where ID = ?");
            stmt = connection.prepareStatement(sql.toString());
            rs = null;
            int si = 1;
            if (useCaseStatement) {
                stmt.setLong(si++, lastmodcount);
                stmt.setLong(si++, lastmodified);
                stmt.setLong(si++, lastmodcount);
                stmt.setLong(si++, lastmodified);
            }
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si, id);
            rs = stmt.executeQuery();
            if (!rs.next()) break block11;
            long modified2 = RDBDocumentStoreJDBC.readLongFromResultSet(rs, 1);
            long modcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, 2);
            long cmodcount = RDBDocumentStoreJDBC.readLongFromResultSet(rs, 3);
            long hasBinary = rs.getLong(4);
            long deletedOnce = rs.getLong(5);
            String data = rs.getString(6);
            byte[] bdata = rs.getBytes(7);
            RDBRow rDBRow = new RDBRow(id, hasBinary == 1L, deletedOnce == 1L, modified2, modcount, cmodcount, data, bdata);
            RDBJDBCTools.closeResultSet(rs);
            RDBJDBCTools.closeStatement(stmt);
            return rDBRow;
        }
        try {
            modified2 = null;
        }
        catch (SQLException ex) {
            block12: {
                RDBRow rDBRow;
                try {
                    LOG.debug("attempting to read " + id + " (id length is " + id.length() + ")", ex);
                    if (!"22001".equals(ex.getSQLState())) break block12;
                    try {
                        connection.rollback();
                    }
                    catch (SQLException ex2) {
                        LOG.debug("failed to rollback", ex2);
                    }
                    rDBRow = null;
                }
                catch (Throwable throwable) {
                    RDBJDBCTools.closeResultSet(rs);
                    RDBJDBCTools.closeStatement(stmt);
                    throw throwable;
                }
                RDBJDBCTools.closeResultSet(rs);
                RDBJDBCTools.closeStatement(stmt);
                return rDBRow;
            }
            throw ex;
        }
        RDBJDBCTools.closeResultSet(rs);
        RDBJDBCTools.closeStatement(stmt);
        return modified2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Connection connection, RDBDocumentStore.RDBTableMetaData tmd, String id, Long modified, Boolean hasBinary, Boolean deletedOnce, Long modcount, Long cmodcount, Long oldmodcount, String data) throws SQLException {
        StringBuilder t = new StringBuilder();
        t.append("update " + tmd.getName() + " set ");
        t.append("MODIFIED = ?, HASBINARY = ?, DELETEDONCE = ?, MODCOUNT = ?, CMODCOUNT = ?, DSIZE = ?, DATA = ?, BDATA = ? ");
        t.append("where ID = ?");
        if (oldmodcount != null) {
            t.append(" and MODCOUNT = ?");
        }
        try (PreparedStatement stmt = connection.prepareStatement(t.toString());){
            int result;
            int si = 1;
            stmt.setObject(si++, (Object)modified, -5);
            stmt.setObject(si++, (Object)(hasBinary != false ? 1 : 0), 5);
            stmt.setObject(si++, (Object)(deletedOnce != false ? 1 : 0), 5);
            stmt.setObject(si++, (Object)modcount, -5);
            stmt.setObject(si++, (Object)(cmodcount == null ? Long.valueOf(0L) : cmodcount), -5);
            stmt.setObject(si++, (Object)data.length(), -5);
            if (data.length() < tmd.getDataLimitInOctets() / 3) {
                stmt.setString(si++, data);
                stmt.setBinaryStream(si++, (InputStream)null, 0);
            } else {
                stmt.setString(si++, "\"blob\"");
                byte[] bytes = RDBDocumentStore.asBytes(data);
                stmt.setBytes(si++, bytes);
            }
            RDBDocumentStoreJDBC.setIdInStatement(tmd, stmt, si++, id);
            if (oldmodcount != null) {
                stmt.setObject(si++, (Object)oldmodcount, -5);
            }
            if ((result = stmt.executeUpdate()) != 1) {
                LOG.debug("DB update failed for " + tmd.getName() + "/" + id + " with oldmodcount=" + oldmodcount);
            }
            boolean bl = result == 1;
            return bl;
        }
    }

    private static String getIdFromRS(RDBDocumentStore.RDBTableMetaData tmd, ResultSet rs, int idx) throws SQLException {
        if (tmd.isIdBinary()) {
            try {
                return new String(rs.getBytes(idx), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("UTF-8 not supported??", ex);
                throw new DocumentStoreException(ex);
            }
        }
        return rs.getString(idx);
    }

    private static void setIdInStatement(RDBDocumentStore.RDBTableMetaData tmd, PreparedStatement stmt, int idx, String id) throws SQLException {
        if (tmd.isIdBinary()) {
            try {
                stmt.setBytes(idx, id.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                LOG.error("UTF-8 not supported??", ex);
                throw new DocumentStoreException(ex);
            }
        } else {
            stmt.setString(idx, id);
        }
    }

    private static long readLongFromResultSet(ResultSet res, int index) throws SQLException {
        long v = res.getLong(index);
        return res.wasNull() ? Long.MIN_VALUE : v;
    }

    private static <T extends Document> List<T> sortDocuments(Collection<T> documents) {
        ArrayList<T> result = new ArrayList<T>(documents);
        Collections.sort(result, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return ((Document)o1).getId().compareTo(((Document)o2).getId());
            }
        });
        return result;
    }

    static {
        Cloneable tmp = new HashMap<String, String>();
        tmp.put(MODIFIED, "MODIFIED");
        tmp.put("_bin", "HASBINARY");
        tmp.put("_deletedOnce", "DELETEDONCE");
        INDEXED_PROP_MAPPING = Collections.unmodifiableMap(tmp);
        tmp = new HashSet();
        tmp.add(">=");
        tmp.add(">");
        tmp.add("<=");
        tmp.add("<");
        tmp.add("=");
        SUPPORTED_OPS = Collections.unmodifiableSet(tmp);
        idExtractor = new Function<Document, String>(){

            @Override
            public String apply(Document input) {
                return input.getId();
            }
        };
    }
}

