/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.rdb;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.zip.GZIPOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.sql.DataSource;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.apache.jackrabbit.oak.plugins.document.cache.NodeDocumentCache;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.locks.StripedNodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBConnectionHandler;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentSerializer;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreDB;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStoreJDBC;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBJDBCTools;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBOptions;
import org.apache.jackrabbit.oak.plugins.document.rdb.RDBRow;
import org.apache.jackrabbit.oak.util.OakVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBDocumentStore
implements DocumentStore {
    private String droppedTables = "";
    private static Map<Collection<? extends Document>, String> TABLEMAP;
    private static List<String> TABLENAMES;
    private final Map<Collection<? extends Document>, RDBTableMetaData> tableMeta = new HashMap<Collection<? extends Document>, RDBTableMetaData>();
    private static final String MODIFIED = "_modified";
    private static final String MODCOUNT = "_modCount";
    public static final String COLLISIONSMODCOUNT = "_collisionsModCount";
    private static final String ID = "_id";
    private static final Logger LOG;
    private Exception callStack;
    private RDBConnectionHandler ch;
    private Set<String> tablesToBeDropped = new HashSet<String>();
    public static final int CHAR2OCTETRATIO = 3;
    private static final int RETRIES = 10;
    protected static final boolean USECMODCOUNT = true;
    private static final UpdateOp.Key MODIFIEDKEY;
    private RDBDocumentStoreDB dbInfo;
    private RDBDocumentStoreJDBC db;
    protected static final List<String> EMPTY_KEY_PATTERN;
    private Map<String, String> metadata;
    private DocumentStoreStatsCollector stats;
    private static final Set<String> INDEXEDPROPERTIES;
    private static final Set<String> REQUIREDCOLUMNS;
    private static final Set<String> COLUMNPROPERTIES;
    private final RDBDocumentSerializer ser = new RDBDocumentSerializer(this, COLUMNPROPERTIES);
    private static final Set<UpdateOp.Key> UNHANDLEDPROPS;
    private static final boolean NOGZIP;
    private static final boolean NOAPPEND;
    private static final int CHUNKSIZE;
    private static final int QUERYHITSLIMIT;
    private static final int QUERYTIMELIMIT;
    private static final boolean BATCHUPDATES;
    private NodeDocumentCache nodesCache;
    private NodeDocumentLocks locks;
    private Map<String, Long> cnUpdates = new ConcurrentHashMap<String, Long>();

    public RDBDocumentStore(DataSource ds, DocumentMK.Builder builder, RDBOptions options) {
        try {
            this.initialize(ds, builder, options);
        }
        catch (Exception ex) {
            throw new DocumentStoreException("initializing RDB document store", ex);
        }
    }

    public RDBDocumentStore(DataSource ds, DocumentMK.Builder builder) {
        this(ds, builder, new RDBOptions());
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String id) {
        return this.find(collection, id, Integer.MAX_VALUE);
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String id, int maxCacheAge) {
        return this.readDocumentCached(collection, id, maxCacheAge);
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        List<QueryCondition> conditions = Collections.emptyList();
        if (indexedProperty != null) {
            conditions = Collections.singletonList(new QueryCondition(indexedProperty, ">=", startValue));
        }
        return this.internalQuery(collection, fromKey, toKey, EMPTY_KEY_PATTERN, conditions, limit);
    }

    @Nonnull
    protected <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, List<String> excludeKeyPatterns, List<QueryCondition> conditions, int limit) {
        return this.internalQuery(collection, fromKey, toKey, excludeKeyPatterns, conditions, limit);
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, String id) {
        this.delete(collection, id);
        this.invalidateCache(collection, id, true);
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> ids) {
        for (String id : ids) {
            this.invalidateCache(collection, id, true);
        }
        this.delete(collection, ids);
    }

    @Override
    public <T extends Document> int remove(Collection<T> collection, Map<String, Map<UpdateOp.Key, UpdateOp.Condition>> toRemove) {
        int num = this.delete(collection, toRemove);
        for (String id : toRemove.keySet()) {
            this.invalidateCache(collection, id, true);
        }
        return num;
    }

    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        return this.internalCreate(collection, updateOps);
    }

    @Override
    public <T extends Document> void update(Collection<T> collection, List<String> keys, UpdateOp updateOp) {
        UpdateUtils.assertUnconditional(updateOp);
        this.internalUpdate(collection, keys, updateOp);
    }

    @Override
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) {
        UpdateUtils.assertUnconditional(update);
        return this.internalCreateOrUpdate(collection, update, true, false);
    }

    @Override
    public <T extends Document> List<T> createOrUpdate(Collection<T> collection, List<UpdateOp> updateOps) {
        if (!BATCHUPDATES) {
            ArrayList<T> results = new ArrayList<T>(updateOps.size());
            for (UpdateOp update : updateOps) {
                results.add(this.createOrUpdate(collection, update));
            }
            return results;
        }
        Stopwatch watch = this.startWatch();
        LinkedHashMap<UpdateOp, T> results = new LinkedHashMap<UpdateOp, T>();
        LinkedHashMap<String, UpdateOp> operationsToCover = new LinkedHashMap<String, UpdateOp>();
        HashSet<UpdateOp> duplicates = new HashSet<UpdateOp>();
        for (UpdateOp updateOp : updateOps) {
            UpdateUtils.assertUnconditional(updateOp);
            if (operationsToCover.containsKey(updateOp.getId())) {
                duplicates.add(updateOp);
                results.put(updateOp, null);
                continue;
            }
            UpdateOp clone = updateOp.copy();
            RDBDocumentStore.addUpdateCounters(clone);
            operationsToCover.put(clone.getId(), clone);
            results.put(clone, null);
        }
        HashMap<String, T> oldDocs = new HashMap<String, T>();
        if (collection == Collection.NODES) {
            oldDocs.putAll(this.readDocumentCached(collection, operationsToCover.keySet()));
        }
        int i = 0;
        while (operationsToCover.size() > 2) {
            boolean upsert;
            boolean bl = upsert = i == 0;
            if (i++ == 3) break;
            for (List<UpdateOp> list : Lists.partition(Lists.newArrayList(operationsToCover.values()), CHUNKSIZE)) {
                Map<UpdateOp, T> successfulUpdates = this.bulkUpdate(collection, list, oldDocs, upsert);
                results.putAll(successfulUpdates);
                operationsToCover.values().removeAll(successfulUpdates.keySet());
            }
        }
        for (UpdateOp updateOp : updateOps) {
            UpdateOp updateOp2 = (UpdateOp)operationsToCover.remove(updateOp.getId());
            if (updateOp2 != null) {
                results.put(updateOp2, this.createOrUpdate(collection, updateOp));
                continue;
            }
            if (!duplicates.contains(updateOp)) continue;
            results.put(updateOp, this.createOrUpdate(collection, updateOp));
        }
        this.stats.doneCreateOrUpdate(watch.elapsed(TimeUnit.NANOSECONDS), collection, Lists.transform(updateOps, new Function<UpdateOp, String>(){

            @Override
            public String apply(UpdateOp input) {
                return input.getId();
            }
        }));
        return new ArrayList(results.values());
    }

    private <T extends Document> Map<String, T> readDocumentCached(Collection<T> collection, Set<String> keys) {
        HashMap<String, T> documents = new HashMap<String, T>();
        if (collection == Collection.NODES) {
            for (String key : keys) {
                NodeDocument cached = this.nodesCache.getIfPresent(key);
                if (cached == null || cached == NodeDocument.NULL) continue;
                Object doc = RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(cached));
                documents.put(((Document)doc).getId(), doc);
            }
        }
        Sets.SetView<String> documentsToRead = Sets.difference(keys, documents.keySet());
        Map<String, T> readDocuments = this.readDocumentsUncached(collection, documentsToRead);
        documents.putAll(readDocuments);
        if (collection == Collection.NODES) {
            for (Object doc : readDocuments.values()) {
                this.nodesCache.putIfAbsent((NodeDocument)doc);
            }
        }
        return documents;
    }

    private <T extends Document> Map<String, T> readDocumentsUncached(Collection<T> collection, Set<String> keys) {
        HashMap<String, T> result = new HashMap<String, T>();
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        try {
            connection = this.ch.getROConnection();
            List<RDBRow> rows = this.db.read(connection, tmd, keys);
            int size = rows.size();
            for (int i = 0; i < size; ++i) {
                RDBRow row = rows.set(i, null);
                T document = this.convertFromDBObject(collection, row);
                result.put(((Document)document).getId(), document);
            }
            connection.commit();
        }
        catch (Exception ex) {
            throw new DocumentStoreException(ex);
        }
        finally {
            this.ch.closeConnection(connection);
        }
        return result;
    }

    private <T extends Document> Map<UpdateOp, T> bulkUpdate(Collection<T> collection, List<UpdateOp> updates, Map<String, T> oldDocs, boolean upsert) {
        HashSet<String> missingDocs = new HashSet<String>();
        for (UpdateOp op : updates) {
            if (oldDocs.containsKey(op.getId())) continue;
            missingDocs.add(op.getId());
        }
        for (Document doc : this.readDocumentsUncached(collection, missingDocs).values()) {
            oldDocs.put(doc.getId(), doc);
            if (collection != Collection.NODES) continue;
            this.nodesCache.putIfAbsent((NodeDocument)doc);
        }
        ArrayList<T> docsToUpdate = new ArrayList<T>(updates.size());
        HashSet<String> keysToUpdate = new HashSet<String>();
        for (UpdateOp update : updates) {
            String id = update.getId();
            T modifiedDoc = collection.newDocument(this);
            if (oldDocs.containsKey(id)) {
                ((Document)oldDocs.get(id)).deepCopy((Document)modifiedDoc);
            }
            UpdateUtils.applyChanges(modifiedDoc, update);
            docsToUpdate.add(modifiedDoc);
            keysToUpdate.add(id);
        }
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        try {
            connection = this.ch.getRWConnection();
            Set<String> successfulUpdates = this.db.update(connection, tmd, docsToUpdate, upsert);
            connection.commit();
            Sets.SetView failedUpdates = Sets.difference(keysToUpdate, successfulUpdates);
            oldDocs.keySet().removeAll(failedUpdates);
            if (collection == Collection.NODES) {
                for (Document doc : docsToUpdate) {
                    String id = doc.getId();
                    if (!successfulUpdates.contains(id)) continue;
                    if (oldDocs.containsKey(id)) {
                        this.nodesCache.replaceCachedDocument((NodeDocument)oldDocs.get(id), (NodeDocument)doc);
                        continue;
                    }
                    this.nodesCache.putIfAbsent((NodeDocument)doc);
                }
            }
            HashMap<UpdateOp, T> result = new HashMap<UpdateOp, T>();
            for (UpdateOp op : updates) {
                if (!successfulUpdates.contains(op.getId())) continue;
                result.put(op, oldDocs.get(op.getId()));
            }
            HashMap<UpdateOp, T> hashMap = result;
            return hashMap;
        }
        catch (SQLException ex) {
            this.ch.rollbackConnection(connection);
            throw this.handleException("update failed for: " + keysToUpdate, (Exception)ex, collection, keysToUpdate);
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) {
        return this.internalCreateOrUpdate(collection, update, false, true);
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        for (CacheValue key : this.nodesCache.keys()) {
            this.invalidateCache(Collection.NODES, key.toString());
        }
        return null;
    }

    @Override
    public CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        for (String key : keys) {
            this.invalidateCache(Collection.NODES, key);
        }
        return null;
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String id) {
        this.invalidateCache(collection, id, false);
    }

    private <T extends Document> void invalidateCache(Collection<T> collection, String id, boolean remove) {
        if (collection == Collection.NODES) {
            this.invalidateNodesCache(id, remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateNodesCache(String id, boolean remove) {
        Lock lock = this.locks.acquire(id);
        try {
            if (remove) {
                this.nodesCache.invalidate(id);
            } else {
                this.nodesCache.markChanged(id);
                NodeDocument entry = this.nodesCache.getIfPresent(id);
                if (entry != null) {
                    entry.markUpToDate(0L);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        Connection connection = null;
        try {
            connection = this.ch.getROConnection();
            long result = this.db.determineServerTimeDifferenceMillis(connection);
            connection.commit();
            long l = result;
            return l;
        }
        catch (SQLException ex) {
            LOG.error("Trying to determine time difference to server", ex);
            throw new DocumentStoreException(ex);
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    public String getDroppedTables() {
        return this.droppedTables;
    }

    public static List<String> getTableNames() {
        return TABLENAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (!this.tablesToBeDropped.isEmpty()) {
            String dropped = "";
            LOG.debug("attempting to drop: " + this.tablesToBeDropped);
            for (String tname : this.tablesToBeDropped) {
                Connection con = null;
                try {
                    con = this.ch.getRWConnection();
                    Statement stmt = null;
                    try {
                        stmt = con.createStatement();
                        stmt.execute("drop table " + tname);
                        stmt.close();
                        con.commit();
                        dropped = dropped + tname + " ";
                    }
                    catch (SQLException ex) {
                        LOG.debug("attempting to drop: " + tname, ex);
                    }
                    finally {
                        RDBJDBCTools.closeStatement(stmt);
                    }
                }
                catch (SQLException ex) {
                    LOG.debug("attempting to drop: " + tname, ex);
                }
                finally {
                    this.ch.closeConnection(con);
                }
            }
            this.droppedTables = dropped.trim();
        }
        try {
            this.ch.close();
        }
        catch (IOException ex) {
            LOG.error("closing connection handler", ex);
        }
        try {
            this.nodesCache.close();
        }
        catch (IOException ex) {
            LOG.warn("Error occurred while closing nodes cache", ex);
        }
        LOG.info("RDBDocumentStore (" + OakVersion.getVersion() + ") disposed" + this.getCnStats() + (this.droppedTables.isEmpty() ? "" : " (tables dropped: " + this.droppedTables + ")"));
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String id) {
        if (collection != Collection.NODES) {
            return null;
        }
        NodeDocument doc = RDBDocumentStore.unwrap(this.nodesCache.getIfPresent(id));
        return RDBDocumentStore.castAsT(doc);
    }

    private <T extends Document> T getIfCached(Collection<T> collection, String id, long modCount) {
        T doc = this.getIfCached(collection, id);
        if (doc != null && ((Document)doc).getModCount() == modCount) {
            return doc;
        }
        return null;
    }

    @Override
    public Iterable<CacheStats> getCacheStats() {
        return this.nodesCache.getCacheStats();
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(DataSource ds, DocumentMK.Builder builder, RDBOptions options) throws Exception {
        this.stats = builder.getDocumentStoreStatsCollector();
        this.tableMeta.put(Collection.NODES, new RDBTableMetaData(RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.NODES))));
        this.tableMeta.put(Collection.CLUSTER_NODES, new RDBTableMetaData(RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.CLUSTER_NODES))));
        this.tableMeta.put(Collection.JOURNAL, new RDBTableMetaData(RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.JOURNAL))));
        this.tableMeta.put(Collection.SETTINGS, new RDBTableMetaData(RDBJDBCTools.createTableName(options.getTablePrefix(), TABLEMAP.get(Collection.SETTINGS))));
        this.ch = new RDBConnectionHandler(ds);
        this.callStack = LOG.isDebugEnabled() ? new Exception("call stack of RDBDocumentStore creation") : null;
        this.locks = new StripedNodeDocumentLocks();
        this.nodesCache = builder.buildNodeDocumentCache(this, this.locks);
        Connection con = this.ch.getRWConnection();
        int isolation = con.getTransactionIsolation();
        String isolationDiags = RDBJDBCTools.isolationLevelToString(isolation);
        if (isolation != 2) {
            LOG.info("Detected transaction isolation level " + isolationDiags + " is " + (isolation < 2 ? "lower" : "higher") + " than expected " + RDBJDBCTools.isolationLevelToString(2) + " - check datasource configuration");
        }
        DatabaseMetaData md = con.getMetaData();
        String dbDesc = String.format("%s %s (%d.%d)", md.getDatabaseProductName(), md.getDatabaseProductVersion(), md.getDatabaseMajorVersion(), md.getDatabaseMinorVersion()).replaceAll("[\r\n\t]", " ").trim();
        String driverDesc = String.format("%s %s (%d.%d)", md.getDriverName(), md.getDriverVersion(), md.getDriverMajorVersion(), md.getDriverMinorVersion()).replaceAll("[\r\n\t]", " ").trim();
        String dbUrl = md.getURL();
        this.dbInfo = RDBDocumentStoreDB.getValue(md.getDatabaseProductName());
        this.db = new RDBDocumentStoreJDBC(this.dbInfo, this.ser, QUERYHITSLIMIT, QUERYTIMELIMIT);
        this.metadata = ImmutableMap.builder().put("type", "rdb").put("db", md.getDatabaseProductName()).put("version", md.getDatabaseProductVersion()).build();
        String versionDiags = this.dbInfo.checkVersion(md);
        if (!versionDiags.isEmpty()) {
            LOG.error(versionDiags);
        }
        if (!"".equals(this.dbInfo.getInitializationStatement())) {
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                stmt.execute(this.dbInfo.getInitializationStatement());
                stmt.close();
                con.commit();
            }
            finally {
                RDBJDBCTools.closeStatement(stmt);
            }
        }
        ArrayList<String> tablesCreated = new ArrayList<String>();
        ArrayList<String> tablesPresent = new ArrayList<String>();
        StringBuilder tableDiags = new StringBuilder();
        try {
            this.createTableFor(con, Collection.CLUSTER_NODES, this.tableMeta.get(Collection.CLUSTER_NODES), tablesCreated, tablesPresent, tableDiags);
            this.createTableFor(con, Collection.NODES, this.tableMeta.get(Collection.NODES), tablesCreated, tablesPresent, tableDiags);
            this.createTableFor(con, Collection.SETTINGS, this.tableMeta.get(Collection.SETTINGS), tablesCreated, tablesPresent, tableDiags);
            this.createTableFor(con, Collection.JOURNAL, this.tableMeta.get(Collection.JOURNAL), tablesCreated, tablesPresent, tableDiags);
        }
        finally {
            con.commit();
            con.close();
        }
        if (options.isDropTablesOnClose()) {
            this.tablesToBeDropped.addAll(tablesCreated);
        }
        if (tableDiags.length() != 0) {
            tableDiags.insert(0, ", ");
        }
        String diag = this.dbInfo.getAdditionalDiagnostics(this.ch, this.tableMeta.get(Collection.NODES).getName());
        LOG.info("RDBDocumentStore (" + OakVersion.getVersion() + ") instantiated for database " + dbDesc + ", using driver: " + driverDesc + ", connecting to: " + dbUrl + (diag.isEmpty() ? "" : ", properties: " + diag) + ", transaction isolation level: " + isolationDiags + tableDiags);
        if (!tablesPresent.isEmpty()) {
            LOG.info("Tables present upon startup: " + tablesPresent);
        }
        if (!tablesCreated.isEmpty()) {
            LOG.info("Tables created upon startup: " + tablesCreated + (options.isDropTablesOnClose() ? " (will be dropped on exit)" : ""));
        }
    }

    private static boolean isBinaryType(int sqlType) {
        return sqlType == -3 || sqlType == -2 || sqlType == -4;
    }

    private void obtainFlagsFromResultSetMeta(ResultSetMetaData met, RDBTableMetaData tmd) throws SQLException {
        for (int i = 1; i <= met.getColumnCount(); ++i) {
            String lcName = met.getColumnName(i).toLowerCase(Locale.ENGLISH);
            if ("id".equals(lcName)) {
                tmd.setIdIsBinary(RDBDocumentStore.isBinaryType(met.getColumnType(i)));
            }
            if (!"data".equals(lcName)) continue;
            tmd.setDataLimitInOctets(met.getPrecision(i));
        }
    }

    private static String asQualifiedDbName(String one, String two) {
        if (one == null && two == null) {
            return null;
        }
        one = one == null ? "" : one.trim();
        two = two == null ? "" : two.trim();
        return one.isEmpty() ? two : one + "." + two;
    }

    private static String indexTypeAsString(int type) {
        switch (type) {
            case 1: {
                return "clustered";
            }
            case 2: {
                return "hashed";
            }
            case 0: {
                return "statistic";
            }
            case 3: {
                return "other";
            }
        }
        return "indexType=" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dumpIndexData(DatabaseMetaData met, ResultSetMetaData rmet, String tableName) {
        String string;
        ResultSet rs = null;
        try {
            String rmetSchemaName;
            String rmetTableName = rmet.getTableName(1);
            if (rmetTableName != null && !rmetTableName.trim().isEmpty()) {
                tableName = rmetTableName.trim();
            }
            rmetSchemaName = (rmetSchemaName = rmet.getSchemaName(1)) == null ? "" : rmetSchemaName.trim();
            TreeMap<String, Map<String, Object>> indices = new TreeMap<String, Map<String, Object>>();
            StringBuilder sb = new StringBuilder();
            rs = met.getIndexInfo(null, null, tableName, false, true);
            this.getIndexInformation(rs, rmetSchemaName, indices);
            if (indices.isEmpty() && !tableName.equals(tableName.toUpperCase(Locale.ENGLISH))) {
                rs = met.getIndexInfo(null, null, tableName.toUpperCase(Locale.ENGLISH), false, true);
                this.getIndexInformation(rs, rmetSchemaName, indices);
            }
            for (Map.Entry index : indices.entrySet()) {
                boolean nonUnique = (Boolean)((Map)index.getValue()).get("nonunique");
                Map fields = (Map)((Map)index.getValue()).get("fields");
                if (fields.isEmpty()) continue;
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(String.format("%sindex %s on %s (", nonUnique ? "" : "unique ", index.getKey(), ((Map)index.getValue()).get("tname")));
                String delim = "";
                for (String field : fields.values()) {
                    sb.append(delim);
                    delim = ", ";
                    sb.append(field);
                }
                sb.append(")");
                sb.append(" ").append(((Map)index.getValue()).get("type"));
            }
            if (sb.length() != 0) {
                sb.insert(0, "/* ").append(" */");
            }
            string = sb.toString();
            RDBJDBCTools.closeResultSet(rs);
        }
        catch (SQLException ex) {
            String string2 = String.format("/* exception while retrieving index information: %s, code %d, state %s */", ex.getMessage(), ex.getErrorCode(), ex.getSQLState());
            return string2;
        }
        finally {
            RDBJDBCTools.closeResultSet(rs);
        }
        return string;
    }

    private void getIndexInformation(ResultSet rs, String rmetSchemaName, Map<String, Map<String, Object>> indices) throws SQLException {
        while (rs.next()) {
            String name = RDBDocumentStore.asQualifiedDbName(rs.getString(5), rs.getString(6));
            if (name == null) continue;
            Map<String, Object> info = indices.get(name);
            if (info == null) {
                info = new HashMap<String, Object>();
                indices.put(name, info);
                info.put("fields", new TreeMap());
            }
            info.put("nonunique", rs.getBoolean(4));
            info.put("type", RDBDocumentStore.indexTypeAsString(rs.getInt(7)));
            String inSchema = rs.getString(2);
            String string = inSchema = inSchema == null ? "" : inSchema.trim();
            if (!rmetSchemaName.isEmpty() && !inSchema.isEmpty() && !rmetSchemaName.equals(inSchema)) continue;
            String tname = RDBDocumentStore.asQualifiedDbName(inSchema, rs.getString(3));
            info.put("tname", tname);
            String cname = rs.getString(9);
            if (cname == null) continue;
            String order = "A".equals(rs.getString(10)) ? " ASC" : ("D".equals(rs.getString(10)) ? " DESC" : "");
            ((Map)info.get("fields")).put(rs.getInt(8), cname + order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTableFor(Connection con, Collection<? extends Document> col, RDBTableMetaData tmd, List<String> tablesCreated, List<String> tablesPresent, StringBuilder diagnostics) throws SQLException {
        String dbname = this.dbInfo.toString();
        if (con.getMetaData().getURL() != null) {
            dbname = dbname + " (" + con.getMetaData().getURL() + ")";
        }
        String tableName = tmd.getName();
        PreparedStatement checkStatement = null;
        ResultSet checkResultSet = null;
        Statement creatStatement = null;
        try {
            checkStatement = con.prepareStatement("select * from " + tableName + " where ID = ?");
            checkStatement.setString(1, "0:/");
            checkResultSet = checkStatement.executeQuery();
            ResultSetMetaData met = checkResultSet.getMetaData();
            this.obtainFlagsFromResultSetMeta(met, tmd);
            HashSet<String> requiredColumns = new HashSet<String>(REQUIREDCOLUMNS);
            HashSet<String> unknownColumns = new HashSet<String>();
            for (int i = 1; i <= met.getColumnCount(); ++i) {
                String cname = met.getColumnName(i).toLowerCase(Locale.ENGLISH);
                if (requiredColumns.remove(cname)) continue;
                unknownColumns.add(cname);
            }
            if (!requiredColumns.isEmpty()) {
                String message = String.format("Table %s: the following required columns are missing: %s", tableName, ((Object)requiredColumns).toString());
                LOG.error(message);
                throw new DocumentStoreException(message);
            }
            if (!unknownColumns.isEmpty()) {
                String message = String.format("Table %s: the following columns are unknown and will not be maintained: %s", tableName, ((Object)unknownColumns).toString());
                LOG.info(message);
            }
            if (col == Collection.NODES) {
                String tableInfo = RDBJDBCTools.dumpResultSetMeta(met);
                diagnostics.append(tableInfo);
                String indexInfo = this.dumpIndexData(con.getMetaData(), met, tableName);
                if (!indexInfo.isEmpty()) {
                    diagnostics.append(" ").append(indexInfo);
                }
            }
            tablesPresent.add(tableName);
        }
        catch (SQLException ex) {
            try {
                ResultSet checkResultSet2;
                PreparedStatement checkStatement2;
                block15: {
                    con.rollback();
                    checkStatement2 = null;
                    checkResultSet2 = null;
                    try {
                        creatStatement = con.createStatement();
                        creatStatement.execute(this.dbInfo.getTableCreationStatement(tableName));
                        creatStatement.close();
                        for (String ic : this.dbInfo.getIndexCreationStatements(tableName)) {
                            creatStatement = con.createStatement();
                            creatStatement.execute(ic);
                            creatStatement.close();
                        }
                        con.commit();
                        tablesCreated.add(tableName);
                        checkStatement2 = con.prepareStatement("select * from " + tableName + " where ID = ?");
                        checkStatement2.setString(1, "0:/");
                        checkResultSet2 = checkStatement2.executeQuery();
                        ResultSetMetaData met = checkResultSet2.getMetaData();
                        this.obtainFlagsFromResultSetMeta(met, tmd);
                        if (col != Collection.NODES) break block15;
                        String tableInfo = RDBJDBCTools.dumpResultSetMeta(met);
                        diagnostics.append(tableInfo);
                        String indexInfo = this.dumpIndexData(con.getMetaData(), met, tableName);
                        if (indexInfo.isEmpty()) break block15;
                        diagnostics.append(" ").append(indexInfo);
                    }
                    catch (SQLException ex2) {
                        try {
                            LOG.error("Failed to create table " + tableName + " in " + dbname, ex2);
                            throw ex2;
                        }
                        catch (Throwable throwable) {
                            RDBJDBCTools.closeResultSet(checkResultSet2);
                            RDBJDBCTools.closeStatement(checkStatement2);
                            throw throwable;
                        }
                    }
                }
                RDBJDBCTools.closeResultSet(checkResultSet2);
                RDBJDBCTools.closeStatement(checkStatement2);
            }
            catch (Throwable throwable) {
                RDBJDBCTools.closeResultSet(checkResultSet);
                RDBJDBCTools.closeStatement(checkStatement);
                RDBJDBCTools.closeStatement(creatStatement);
                throw throwable;
            }
            RDBJDBCTools.closeResultSet(checkResultSet);
            RDBJDBCTools.closeStatement(checkStatement);
            RDBJDBCTools.closeStatement(creatStatement);
        }
        RDBJDBCTools.closeResultSet(checkResultSet);
        RDBJDBCTools.closeStatement(checkStatement);
        RDBJDBCTools.closeStatement(creatStatement);
    }

    protected void finalize() throws Throwable {
        if (!this.ch.isClosed() && this.callStack != null) {
            LOG.debug("finalizing RDBDocumentStore that was not disposed", this.callStack);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Document> T readDocumentCached(final Collection<T> collection, final String id, int maxCacheAge) {
        long lastCheckTime;
        if (collection != Collection.NODES) {
            return this.readDocumentUncached(collection, id, null);
        }
        NodeDocument doc = null;
        if (maxCacheAge > 0 && (doc = this.nodesCache.getIfPresent(id)) != null && (lastCheckTime = doc.getLastCheckTime()) != 0L && (maxCacheAge == Integer.MAX_VALUE || System.currentTimeMillis() - lastCheckTime < (long)maxCacheAge)) {
            this.stats.doneFindCached(Collection.NODES, id);
            return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
        }
        try {
            Lock lock = this.locks.acquire(id);
            try {
                NodeDocument cachedDoc;
                long lastCheckTime2;
                if (maxCacheAge == 0) {
                    this.invalidateNodesCache(id, true);
                    doc = null;
                }
                if ((lastCheckTime2 = (doc = this.nodesCache.get(id, new Callable<NodeDocument>(cachedDoc = doc){
                    final /* synthetic */ NodeDocument val$cachedDoc;
                    {
                        this.val$cachedDoc = nodeDocument;
                    }

                    @Override
                    public NodeDocument call() throws Exception {
                        NodeDocument doc = (NodeDocument)RDBDocumentStore.this.readDocumentUncached(collection, id, this.val$cachedDoc);
                        if (doc != null) {
                            doc.seal();
                        }
                        return RDBDocumentStore.wrap(doc);
                    }
                })).getLastCheckTime()) != 0L) {
                    if (maxCacheAge == 0) return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
                    if (maxCacheAge == Integer.MAX_VALUE) {
                        return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
                    }
                }
                if (lastCheckTime2 != 0L && System.currentTimeMillis() - lastCheckTime2 < (long)maxCacheAge) {
                    return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
                }
                NodeDocument ndoc = (NodeDocument)this.readDocumentUncached(collection, id, cachedDoc);
                if (ndoc != null) {
                    ndoc.seal();
                }
                doc = RDBDocumentStore.wrap(ndoc);
                this.nodesCache.put(doc);
                return RDBDocumentStore.castAsT(RDBDocumentStore.unwrap(doc));
            }
            finally {
                lock.unlock();
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Failed to load document with " + id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private <T extends Document> boolean internalCreate(Collection<T> collection, List<UpdateOp> updates) {
        Stopwatch watch = this.startWatch();
        ArrayList<String> ids = new ArrayList<String>(updates.size());
        boolean success = true;
        try {
            for (List<UpdateOp> chunks : Lists.partition(updates, CHUNKSIZE)) {
                ArrayList<Object> docs = new ArrayList<Object>();
                for (UpdateOp update : chunks) {
                    ids.add(update.getId());
                    this.maintainUpdateStats(collection, update.getId());
                    UpdateUtils.assertUnconditional(update);
                    Object doc = collection.newDocument(this);
                    RDBDocumentStore.addUpdateCounters(update);
                    UpdateUtils.applyChanges(doc, update);
                    if (!update.getId().equals(((Document)doc).getId())) {
                        throw new DocumentStoreException("ID mismatch - UpdateOp: " + update.getId() + ", ID property: " + ((Document)doc).getId());
                    }
                    docs.add(doc);
                }
                boolean done = this.insertDocuments(collection, docs);
                if (done) {
                    if (collection != Collection.NODES) continue;
                    for (Object doc : docs) {
                        this.nodesCache.putIfAbsent((NodeDocument)doc);
                    }
                    continue;
                }
                success = false;
            }
            boolean i$ = success;
            return i$;
        }
        catch (DocumentStoreException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.stats.doneCreate(watch.elapsed(TimeUnit.NANOSECONDS), collection, ids, success);
        }
    }

    @CheckForNull
    private <T extends Document> T internalCreateOrUpdate(Collection<T> collection, UpdateOp update, boolean allowCreate, boolean checkConditions) {
        T oldDoc = this.readDocumentCached(collection, update.getId(), Integer.MAX_VALUE);
        if (oldDoc == null) {
            if (!allowCreate) {
                return null;
            }
            if (!update.isNew()) {
                throw new DocumentStoreException("Document does not exist: " + update.getId());
            }
            T doc = collection.newDocument(this);
            if (checkConditions && !UpdateUtils.checkConditions(doc, update.getConditions())) {
                return null;
            }
            RDBDocumentStore.addUpdateCounters(update);
            UpdateUtils.applyChanges(doc, update);
            try {
                Stopwatch watch = this.startWatch();
                if (!this.insertDocuments(collection, Collections.singletonList(doc))) {
                    throw new DocumentStoreException("Can't insert the document: " + ((Document)doc).getId());
                }
                if (collection == Collection.NODES) {
                    this.nodesCache.putIfAbsent((NodeDocument)doc);
                }
                this.stats.doneFindAndModify(watch.elapsed(TimeUnit.NANOSECONDS), collection, update.getId(), true, true, 0);
                return oldDoc;
            }
            catch (DocumentStoreException ex) {
                oldDoc = this.readDocumentUncached(collection, update.getId(), null);
                if (oldDoc == null) {
                    LOG.error("insert failed, but document " + update.getId() + " is not present, aborting", ex);
                    throw ex;
                }
                return this.internalUpdate(collection, update, oldDoc, checkConditions, 10);
            }
        }
        T result = this.internalUpdate(collection, update, oldDoc, checkConditions, 10);
        if (allowCreate && result == null) {
            LOG.error("update of " + update.getId() + " failed, race condition?");
            throw new DocumentStoreException("update of " + update.getId() + " failed, race condition?");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private <T extends Document> T internalUpdate(Collection<T> collection, UpdateOp update, T oldDoc, boolean checkConditions, int maxRetries) {
        if (checkConditions && !UpdateUtils.checkConditions(oldDoc, update.getConditions())) {
            return null;
        }
        this.maintainUpdateStats(collection, update.getId());
        RDBDocumentStore.addUpdateCounters(update);
        T doc = this.createNewDocument(collection, oldDoc, update);
        Lock l = this.locks.acquire(update.getId());
        Stopwatch watch = this.startWatch();
        boolean success = false;
        int retries = maxRetries;
        try {
            while (!success && retries > 0) {
                long lastmodcount = RDBDocumentStore.modcountOf(oldDoc);
                success = this.updateDocument(collection, doc, update, lastmodcount);
                if (!success) {
                    long newmodcount;
                    --retries;
                    oldDoc = this.readDocumentCached(collection, update.getId(), Integer.MAX_VALUE);
                    if (oldDoc != null && lastmodcount == (newmodcount = RDBDocumentStore.modcountOf(oldDoc))) {
                        oldDoc = this.readDocumentUncached(collection, update.getId(), null);
                    }
                    if (oldDoc == null) {
                        LOG.debug("failed to apply update because document is gone in the meantime: " + update.getId(), new Exception("call stack"));
                        T t = null;
                        return t;
                    }
                    if (checkConditions && !UpdateUtils.checkConditions(oldDoc, update.getConditions())) {
                        T t = null;
                        return t;
                    }
                    RDBDocumentStore.addUpdateCounters(update);
                    doc = this.createNewDocument(collection, oldDoc, update);
                    continue;
                }
                if (collection != Collection.NODES) continue;
                this.nodesCache.replaceCachedDocument((NodeDocument)oldDoc, (NodeDocument)doc);
            }
            if (!success) {
                throw new DocumentStoreException("failed update of " + ((Document)doc).getId() + " (race?) after " + maxRetries + " retries");
            }
            T t = oldDoc;
            return t;
        }
        finally {
            l.unlock();
            int numOfAttempts = maxRetries - retries - 1;
            this.stats.doneFindAndModify(watch.elapsed(TimeUnit.NANOSECONDS), collection, update.getId(), false, success, numOfAttempts);
        }
    }

    @Nonnull
    private <T extends Document> T createNewDocument(Collection<T> collection, T oldDoc, UpdateOp update) {
        T doc = collection.newDocument(this);
        oldDoc.deepCopy((Document)doc);
        UpdateUtils.applyChanges(doc, update);
        ((Document)doc).seal();
        return doc;
    }

    private static void addUpdateCounters(UpdateOp update) {
        if (RDBDocumentStore.hasChangesToCollisions(update)) {
            update.increment(COLLISIONSMODCOUNT, 1L);
        }
        update.increment(MODCOUNT, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private <T extends Document> void internalUpdate(Collection<T> collection, List<String> ids, UpdateOp update) {
        if (RDBDocumentStore.isAppendableUpdate(update, true) && !RDBDocumentStore.requiresPreviousState(update)) {
            UpdateOp.Operation modOperation = update.getChanges().get(MODIFIEDKEY);
            long modified = RDBDocumentStore.getModifiedFromOperation(modOperation);
            boolean modifiedIsConditional = modOperation == null || modOperation.type != UpdateOp.Operation.Type.SET;
            String appendData = this.ser.asString(update);
            for (List<String> chunkedIds : Lists.partition(ids, CHUNKSIZE)) {
                if (collection == Collection.NODES) {
                    for (String key : chunkedIds) {
                        this.nodesCache.invalidate(key);
                    }
                }
                Connection connection = null;
                RDBTableMetaData tmd = this.getTable(collection);
                boolean success = false;
                try {
                    Stopwatch watch = this.startWatch();
                    connection = this.ch.getRWConnection();
                    success = this.db.batchedAppendingUpdate(connection, tmd, chunkedIds, modified, modifiedIsConditional, appendData);
                    connection.commit();
                    this.stats.doneUpdate(watch.elapsed(TimeUnit.NANOSECONDS), collection, chunkedIds.size());
                    this.ch.closeConnection(connection);
                }
                catch (SQLException ex) {
                    try {
                        success = false;
                        this.ch.rollbackConnection(connection);
                        this.ch.closeConnection(connection);
                    }
                    catch (Throwable throwable) {
                        this.ch.closeConnection(connection);
                        throw throwable;
                    }
                }
                if (success) {
                    if (collection != Collection.NODES) continue;
                    for (String id : chunkedIds) {
                        this.nodesCache.invalidate(id);
                    }
                    continue;
                }
                for (String id : chunkedIds) {
                    UpdateOp up = update.copy();
                    up = up.shallowCopy(id);
                    this.internalCreateOrUpdate(collection, up, false, true);
                }
            }
        } else {
            for (String id : ids) {
                UpdateOp up = update.copy();
                up = up.shallowCopy(id);
                this.internalCreateOrUpdate(collection, up, false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private <T extends Document> List<T> internalQuery(Collection<T> collection, String fromKey, String toKey, List<String> excludeKeyPatterns, List<QueryCondition> conditions, int limit) {
        connection = null;
        tmd = this.getTable(collection);
        for (QueryCondition cond : conditions) {
            if (RDBDocumentStore.INDEXEDPROPERTIES.contains(cond.getPropertyName())) continue;
            message = "indexed property " + cond.getPropertyName() + " not supported, query was '" + cond.getOperator() + "'" + cond.getValue() + "'; supported properties are " + RDBDocumentStore.INDEXEDPROPERTIES;
            RDBDocumentStore.LOG.info(message);
            throw new DocumentStoreException(message);
        }
        watch = this.startWatch();
        resultSize = 0;
        tracker = null;
        try {
            if (collection == Collection.NODES) {
                tracker = this.nodesCache.registerTracker(fromKey, toKey);
            }
            now = System.currentTimeMillis();
            connection = this.ch.getROConnection();
            from = collection == Collection.NODES && "0000000".equals(fromKey) != false ? null : fromKey;
            to = collection == Collection.NODES && ";".equals(toKey) != false ? null : toKey;
            dbresult = this.db.query(connection, tmd, from, to, excludeKeyPatterns, conditions, limit);
            connection.commit();
            size = dbresult.size();
            result = new ArrayList<T>(size);
            for (i = 0; i < size; ++i) {
                row = dbresult.set(i, null);
                doc = this.getIfCached(collection, row.getId(), row.getModcount());
                if (doc == null) {
                    doc = this.convertFromDBObject(collection, row);
                } else {
                    lastmodified = RDBDocumentStore.modifiedOf(doc);
                    if (lastmodified == row.getModified() && lastmodified >= 1L) {
                        lock = this.locks.acquire(row.getId());
                        try {
                            if (tracker.mightBeenAffected(row.getId())) ** GOTO lbl39
                            ((NodeDocument)doc).markUpToDate(now);
                        }
                        finally {
                            lock.unlock();
                        }
                    } else {
                        doc = this.convertFromDBObject(collection, row);
                    }
                }
lbl39:
                // 4 sources

                result.add(doc);
            }
            if (collection == Collection.NODES) {
                this.nodesCache.putNonConflictingDocs(tracker, RDBDocumentStore.castAsNodeDocumentList(result));
            }
            resultSize = result.size();
            var19_22 = result;
            if (tracker != null) {
                tracker.close();
            }
            this.ch.closeConnection(connection);
            this.stats.doneQuery(watch.elapsed(TimeUnit.NANOSECONDS), collection, fromKey, toKey, conditions.isEmpty() == false, resultSize, -1L, false);
            return var19_22;
        }
        catch (Exception ex) {
            try {
                RDBDocumentStore.LOG.error("SQL exception on query", ex);
                throw new DocumentStoreException(ex);
            }
            catch (Throwable var26_28) {
                if (tracker != null) {
                    tracker.close();
                }
                this.ch.closeConnection(connection);
                this.stats.doneQuery(watch.elapsed(TimeUnit.NANOSECONDS), collection, fromKey, toKey, conditions.isEmpty() == false, resultSize, -1L, false);
                throw var26_28;
            }
        }
    }

    @Nonnull
    protected <T extends Document> RDBTableMetaData getTable(Collection<T> collection) {
        RDBTableMetaData tmd = this.tableMeta.get(collection);
        if (tmd != null) {
            return tmd;
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    @CheckForNull
    private <T extends Document> T readDocumentUncached(Collection<T> collection, String id, NodeDocument cachedDoc) {
        T t;
        RDBRow row;
        boolean docFound;
        Stopwatch watch;
        Connection connection;
        block8: {
            long lastmodified;
            long lastmodcount;
            block7: {
                connection = null;
                RDBTableMetaData tmd = this.getTable(collection);
                watch = this.startWatch();
                docFound = true;
                lastmodcount = -1L;
                lastmodified = -1L;
                if (cachedDoc != null) {
                    lastmodcount = RDBDocumentStore.modcountOf(cachedDoc);
                    lastmodified = RDBDocumentStore.modifiedOf(cachedDoc);
                }
                connection = this.ch.getROConnection();
                row = this.db.read(connection, tmd, id, lastmodcount, lastmodified);
                connection.commit();
                if (row != null) break block7;
                docFound = false;
                T t2 = null;
                this.ch.closeConnection(connection);
                this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
                return t2;
            }
            if (lastmodcount != row.getModcount() || lastmodified != row.getModified() || lastmodified < 1L) break block8;
            cachedDoc.markUpToDate(System.currentTimeMillis());
            T t3 = RDBDocumentStore.castAsT(cachedDoc);
            this.ch.closeConnection(connection);
            this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
            return t3;
        }
        try {
            t = this.convertFromDBObject(collection, row);
            this.ch.closeConnection(connection);
            this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
        }
        catch (Exception ex) {
            try {
                throw new DocumentStoreException(ex);
            }
            catch (Throwable throwable) {
                this.ch.closeConnection(connection);
                this.stats.doneFindUncached(watch.elapsed(TimeUnit.NANOSECONDS), collection, id, docFound, false);
                throw throwable;
            }
        }
        return t;
    }

    private <T extends Document> void delete(Collection<T> collection, String id) {
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        try {
            connection = this.ch.getRWConnection();
            this.db.delete(connection, tmd, Collections.singletonList(id));
            connection.commit();
        }
        catch (Exception ex) {
            throw this.handleException("removing " + id, ex, collection, id);
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    private <T extends Document> int delete(Collection<T> collection, List<String> ids) {
        int numDeleted = 0;
        RDBTableMetaData tmd = this.getTable(collection);
        for (List<String> sublist : Lists.partition(ids, 64)) {
            Connection connection = null;
            try {
                connection = this.ch.getRWConnection();
                numDeleted += this.db.delete(connection, tmd, sublist);
                connection.commit();
            }
            catch (Exception ex) {
                throw this.handleException("removing " + ids, ex, collection, ids);
            }
            finally {
                this.ch.closeConnection(connection);
            }
        }
        return numDeleted;
    }

    private <T extends Document> int delete(Collection<T> collection, Map<String, Map<UpdateOp.Key, UpdateOp.Condition>> toRemove) {
        int numDeleted = 0;
        RDBTableMetaData tmd = this.getTable(collection);
        HashMap<String, Map<UpdateOp.Key, UpdateOp.Condition>> subMap = Maps.newHashMap();
        Iterator<Map.Entry<String, Map<UpdateOp.Key, UpdateOp.Condition>>> it = toRemove.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map<UpdateOp.Key, UpdateOp.Condition>> entry = it.next();
            subMap.put(entry.getKey(), entry.getValue());
            if (subMap.size() != 64 && it.hasNext()) continue;
            Connection connection = null;
            try {
                connection = this.ch.getRWConnection();
                numDeleted += this.db.delete(connection, tmd, subMap);
                connection.commit();
            }
            catch (Exception ex) {
                Set<String> ids = subMap.keySet();
                throw this.handleException("deleting " + ids, ex, collection, ids);
            }
            finally {
                this.ch.closeConnection(connection);
            }
            subMap.clear();
        }
        return numDeleted;
    }

    private <T extends Document> boolean updateDocument(@Nonnull Collection<T> collection, @Nonnull T document, @Nonnull UpdateOp update, Long oldmodcount) {
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        String data = null;
        try {
            String appendData;
            connection = this.ch.getRWConnection();
            Number flagB = (Number)document.get("_bin");
            Boolean hasBinary = flagB != null && (long)flagB.intValue() == 1L;
            Boolean flagD = (Boolean)document.get("_deletedOnce");
            Boolean deletedOnce = flagD != null && flagD != false;
            Long modcount = (Long)document.get(MODCOUNT);
            Long cmodcount = (Long)document.get(COLLISIONSMODCOUNT);
            boolean success = false;
            boolean shouldRetry = true;
            if (RDBDocumentStore.isAppendableUpdate(update, false) && modcount % 16L != 0L && (appendData = this.ser.asString(update)).length() < tmd.getDataLimitInOctets() / 3) {
                try {
                    UpdateOp.Operation modOperation = update.getChanges().get(MODIFIEDKEY);
                    long modified = RDBDocumentStore.getModifiedFromOperation(modOperation);
                    boolean modifiedIsConditional = modOperation == null || modOperation.type != UpdateOp.Operation.Type.SET;
                    success = this.db.appendingUpdate(connection, tmd, document.getId(), modified, modifiedIsConditional, hasBinary, deletedOnce, modcount, cmodcount, oldmodcount, appendData);
                    shouldRetry = false;
                    connection.commit();
                }
                catch (SQLException ex) {
                    RDBDocumentStore.continueIfStringOverflow(ex);
                    this.ch.rollbackConnection(connection);
                    success = false;
                }
            }
            if (!success && shouldRetry) {
                data = this.ser.asString(document);
                Object m = document.get(MODIFIED);
                long modified = m instanceof Long ? (Long)m : 0L;
                success = this.db.update(connection, tmd, document.getId(), modified, hasBinary, deletedOnce, modcount, cmodcount, oldmodcount, data);
                connection.commit();
            }
            boolean bl = success;
            return bl;
        }
        catch (SQLException ex) {
            this.ch.rollbackConnection(connection);
            String addDiags = "";
            if (RDBJDBCTools.matchesSQLState(ex, "22", "72")) {
                byte[] bytes = RDBDocumentStore.asBytes(data);
                addDiags = String.format(" (DATA size in Java characters: %d, in octets: %d, computed character limit: %d)", data.length(), bytes.length, tmd.getDataLimitInOctets() / 3);
            }
            String message = String.format("Update for %s failed%s", document.getId(), addDiags);
            LOG.debug(message, ex);
            throw this.handleException(message, (Exception)ex, collection, document.getId());
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    private static void continueIfStringOverflow(SQLException ex) throws SQLException {
        String state = ex.getSQLState();
        if (!("22001".equals(state) || "72000".equals(state) && 1489 == ex.getErrorCode())) {
            throw ex;
        }
    }

    private static boolean isAppendableUpdate(UpdateOp update, boolean batched) {
        if (NOAPPEND) {
            return false;
        }
        if (batched) {
            for (UpdateOp.Key key : update.getChanges().keySet()) {
                if (!UNHANDLEDPROPS.contains(key)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean requiresPreviousState(UpdateOp update) {
        return !update.getConditions().isEmpty();
    }

    private static long getModifiedFromOperation(UpdateOp.Operation op) {
        return op == null ? 0L : Long.parseLong(op.value.toString());
    }

    private <T extends Document> boolean insertDocuments(Collection<T> collection, List<T> documents) {
        Connection connection = null;
        RDBTableMetaData tmd = this.getTable(collection);
        try {
            connection = this.ch.getRWConnection();
            Set<String> insertedKeys = this.db.insert(connection, tmd, documents);
            connection.commit();
            boolean bl = insertedKeys.size() == documents.size();
            return bl;
        }
        catch (SQLException ex) {
            this.ch.rollbackConnection(connection);
            ArrayList<String> ids = new ArrayList<String>();
            for (Document doc : documents) {
                ids.add(doc.getId());
            }
            String message = String.format("insert of %s failed", ids);
            LOG.debug(message, ex);
            String messages = LOG.isDebugEnabled() ? RDBJDBCTools.getAdditionalMessages(ex) : "";
            boolean dataRelated = false;
            for (SQLException walk = ex; walk != null && !dataRelated; walk = walk.getNextException()) {
                dataRelated = RDBJDBCTools.matchesSQLState(walk, "22", "72");
            }
            if (dataRelated) {
                String id = null;
                int longest = 0;
                int longestChars = 0;
                for (Document d : documents) {
                    String data = this.ser.asString(d);
                    byte[] bytes = RDBDocumentStore.asBytes(data);
                    if (bytes.length <= longest) continue;
                    longest = bytes.length;
                    longestChars = data.length();
                    id = d.getId();
                }
                String m = String.format(" (potential cause: long data for ID %s - longest octet DATA size in Java characters: %d, in octets: %d, computed character limit: %d)", id, longest, longestChars, tmd.getDataLimitInOctets() / 3);
                messages = messages + m;
            }
            if (!messages.isEmpty()) {
                LOG.debug("additional diagnostics: " + messages);
            }
            throw this.handleException(message, (Exception)ex, collection, ids);
        }
        finally {
            this.ch.closeConnection(connection);
        }
    }

    public static byte[] asBytes(String data) {
        byte[] bytes;
        try {
            bytes = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("UTF-8 not supported??", ex);
            throw new DocumentStoreException(ex);
        }
        if (NOGZIP) {
            return bytes;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length());
            GZIPOutputStream gos = new GZIPOutputStream(bos){
                {
                    this.def.setLevel(1);
                }
            };
            gos.write(bytes);
            gos.close();
            return bos.toByteArray();
        }
        catch (IOException ex) {
            LOG.error("Error while gzipping contents", ex);
            throw new DocumentStoreException(ex);
        }
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
    }

    public void setStatsCollector(DocumentStoreStatsCollector stats) {
        this.stats = stats;
    }

    private static <T extends Document> T castAsT(NodeDocument doc) {
        return (T)doc;
    }

    private static <T extends Document> List<NodeDocument> castAsNodeDocumentList(List<T> list) {
        return list;
    }

    @CheckForNull
    private static NodeDocument unwrap(@Nonnull NodeDocument doc) {
        return doc == NodeDocument.NULL ? null : doc;
    }

    @Nonnull
    private static NodeDocument wrap(@CheckForNull NodeDocument doc) {
        return doc == null ? NodeDocument.NULL : doc;
    }

    @Nonnull
    private static String idOf(@Nonnull Document doc) {
        String id = doc.getId();
        if (id == null) {
            throw new IllegalArgumentException("non-null ID expected");
        }
        return id;
    }

    private static long modcountOf(@Nonnull Document doc) {
        Long n = doc.getModCount();
        return n != null ? n : -1L;
    }

    private static long modifiedOf(@Nonnull Document doc) {
        Object l = doc.get(MODIFIED);
        return l instanceof Long ? (Long)l : -1L;
    }

    @Nonnull
    protected <T extends Document> T convertFromDBObject(@Nonnull Collection<T> collection, @Nonnull RDBRow row) {
        return this.ser.fromRow(collection, row);
    }

    private static boolean hasChangesToCollisions(UpdateOp update) {
        for (Map.Entry<UpdateOp.Key, UpdateOp.Operation> e : Preconditions.checkNotNull(update).getChanges().entrySet()) {
            UpdateOp.Key k = e.getKey();
            UpdateOp.Operation op = e.getValue();
            if (op.type != UpdateOp.Operation.Type.SET_MAP_ENTRY || !"_collisions".equals(k.getName())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Document> void maintainUpdateStats(Collection<T> collection, String key) {
        if (collection == Collection.CLUSTER_NODES) {
            RDBDocumentStore rDBDocumentStore = this;
            synchronized (rDBDocumentStore) {
                Long old = this.cnUpdates.get(key);
                old = old == null ? Long.valueOf(1L) : old + 1L;
                this.cnUpdates.put(key, old);
            }
        }
    }

    private String getCnStats() {
        if (this.cnUpdates.isEmpty()) {
            return "";
        }
        ArrayList<Map.Entry<String, Long>> tmp = new ArrayList<Map.Entry<String, Long>>();
        tmp.addAll(this.cnUpdates.entrySet());
        Collections.sort(tmp, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return " (Cluster Node updates: " + ((Object)tmp).toString() + ")";
    }

    private Stopwatch startWatch() {
        return Stopwatch.createStarted();
    }

    protected NodeDocumentCache getNodeDocumentCache() {
        return this.nodesCache;
    }

    private <T extends Document> DocumentStoreException handleException(String message, Exception ex, Collection<T> collection, java.util.Collection<String> ids) {
        if (collection == Collection.NODES) {
            for (String id : ids) {
                this.invalidateCache(collection, id, false);
            }
        }
        return DocumentStoreException.convert(ex, message);
    }

    private <T extends Document> DocumentStoreException handleException(String message, Exception ex, Collection<T> collection, String id) {
        return this.handleException(message, ex, collection, Collections.singleton(id));
    }

    static {
        HashMap<Collection<Document>, String> tmp = new HashMap<Collection<Document>, String>();
        tmp.put(Collection.CLUSTER_NODES, "CLUSTERNODES");
        tmp.put(Collection.JOURNAL, "JOURNAL");
        tmp.put(Collection.NODES, "NODES");
        tmp.put(Collection.SETTINGS, "SETTINGS");
        TABLEMAP = Collections.unmodifiableMap(tmp);
        ArrayList<String> tl = new ArrayList<String>(TABLEMAP.values());
        Collections.sort(tl);
        TABLENAMES = Collections.unmodifiableList(tl);
        LOG = LoggerFactory.getLogger(RDBDocumentStore.class);
        MODIFIEDKEY = new UpdateOp.Key(MODIFIED, null);
        EMPTY_KEY_PATTERN = Collections.emptyList();
        INDEXEDPROPERTIES = new HashSet<String>(Arrays.asList(MODIFIED, "_bin", "_deletedOnce"));
        REQUIREDCOLUMNS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("id", "dsize", "deletedonce", "bdata", "data", "cmodcount", "modcount", "hasbinary", "modified")));
        COLUMNPROPERTIES = new HashSet<String>(Arrays.asList(ID, "_bin", "_deletedOnce", COLLISIONSMODCOUNT, MODIFIED, MODCOUNT));
        UNHANDLEDPROPS = new HashSet<UpdateOp.Key>(Arrays.asList(new UpdateOp.Key("_bin", null), new UpdateOp.Key("_deletedOnce", null)));
        NOGZIP = Boolean.getBoolean("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.NOGZIP");
        NOAPPEND = Boolean.getBoolean("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.NOAPPEND");
        CHUNKSIZE = Integer.getInteger("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.CHUNKSIZE", 64);
        QUERYHITSLIMIT = Integer.getInteger("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.QUERYHITSLIMIT", 4096);
        QUERYTIMELIMIT = Integer.getInteger("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.QUERYTIMELIMIT", 10000);
        BATCHUPDATES = Boolean.parseBoolean(System.getProperty("org.apache.jackrabbit.oak.plugins.document.rdb.RDBDocumentStore.BATCHUPDATES", "true"));
    }

    protected static class QueryCondition {
        private final String propertyName;
        private final String operator;
        private final long value;

        public QueryCondition(String propertyName, String operator, long value) {
            this.propertyName = propertyName;
            this.operator = operator;
            this.value = value;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getOperator() {
            return this.operator;
        }

        public long getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s %s %d", this.propertyName, this.operator, this.value);
        }
    }

    static class RDBTableMetaData {
        private final String name;
        private boolean idIsBinary = false;
        private int dataLimitInOctets = 16384;

        public RDBTableMetaData(String name) {
            this.name = name;
        }

        public int getDataLimitInOctets() {
            return this.dataLimitInOctets;
        }

        public String getName() {
            return this.name;
        }

        public boolean isIdBinary() {
            return this.idIsBinary;
        }

        public void setIdIsBinary(boolean idIsBinary) {
            this.idIsBinary = idIsBinary;
        }

        public void setDataLimitInOctets(int dataLimitInOctets) {
            this.dataLimitInOctets = dataLimitInOctets;
        }
    }
}

