/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalCause;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.CacheType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.EvictionListener;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.KeyDataType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.MultiGenerationMap;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCache;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.PersistentCacheStats;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.ValueDataType;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheActionDispatcher;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.async.CacheWriteQueue;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeCache<K, V>
implements Cache<K, V>,
PersistentCache.GenerationCache,
EvictionListener<K, V> {
    static final Logger LOG = LoggerFactory.getLogger(NodeCache.class);
    private static final Set<RemovalCause> EVICTION_CAUSES = ImmutableSet.of(RemovalCause.COLLECTED, RemovalCause.EXPIRED, RemovalCause.SIZE);
    private static final boolean ASYNC_CACHE = Boolean.getBoolean("oak.cache.asynchronous");
    private final PersistentCache cache;
    private final PersistentCacheStats stats;
    private final Cache<K, V> memCache;
    private final MultiGenerationMap<K, V> map;
    private final CacheType type;
    private final DataType keyType;
    private final DataType valueType;
    private final CacheWriteQueue<K, V> writerQueue;

    NodeCache(PersistentCache cache, Cache<K, V> memCache, DocumentNodeStore docNodeStore, DocumentStore docStore, CacheType type, CacheActionDispatcher dispatcher, StatisticsProvider statisticsProvider) {
        this.cache = cache;
        this.memCache = memCache;
        this.type = type;
        PersistentCache.LOG.info("wrapping map " + (Object)((Object)this.type));
        this.map = new MultiGenerationMap();
        this.keyType = new KeyDataType(type);
        this.valueType = new ValueDataType(docNodeStore, docStore, type);
        if (ASYNC_CACHE) {
            this.writerQueue = new CacheWriteQueue<K, V>(dispatcher, cache, this.map);
            LOG.info("The persistent cache writes will be asynchronous");
        } else {
            this.writerQueue = null;
            LOG.info("The persistent cache writes will be synchronous");
        }
        this.stats = new PersistentCacheStats(type, statisticsProvider);
    }

    @Override
    public CacheType getType() {
        return this.type;
    }

    @Override
    public void addGeneration(int generation, boolean readOnly) {
        MVMap.Builder b = new MVMap.Builder().keyType(this.keyType).valueType(this.valueType);
        String mapName = this.type.name();
        CacheMap m = this.cache.openMap(generation, mapName, b);
        this.map.addReadMap(generation, m);
        if (!readOnly) {
            this.map.setWriteMap(m);
            this.stats.addWriteGeneration(generation);
        }
    }

    @Override
    public void removeGeneration(int generation) {
        this.map.removeReadMap(generation);
        this.stats.removeReadGeneration(generation);
    }

    private V readIfPresent(K key) {
        if (ASYNC_CACHE && this.writerQueue.waitsForInvalidation(key)) {
            return null;
        }
        this.cache.switchGenerationIfNeeded();
        TimerStats.Context ctx = this.stats.startReadTimer();
        V v = this.map.get(key);
        ctx.stop();
        return v;
    }

    private void broadcast(final K key, final V value) {
        this.cache.broadcast(this.type, new Function<WriteBuffer, Void>(){

            @Override
            @Nullable
            public Void apply(@Nullable WriteBuffer buffer) {
                NodeCache.this.keyType.write(buffer, key);
                if (value == null) {
                    buffer.put((byte)0);
                } else {
                    buffer.put((byte)1);
                    NodeCache.this.valueType.write(buffer, value);
                }
                return null;
            }
        });
    }

    private void write(K key, V value) {
        this.cache.switchGenerationIfNeeded();
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
            long memory = 0L;
            memory += key == null ? 0L : (long)this.keyType.getMemory(key);
            this.stats.markBytesWritten(memory += value == null ? 0L : (long)this.valueType.getMemory(value));
            this.stats.markPut();
        }
    }

    @Override
    @Nullable
    public V getIfPresent(Object key) {
        V value = this.memCache.getIfPresent(key);
        if (value != null) {
            return value;
        }
        this.stats.markRequest();
        value = this.readIfPresent(key);
        if (value != null) {
            this.memCache.put(key, value);
            this.stats.markHit();
        }
        return value;
    }

    @Override
    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        V value = this.getIfPresent(key);
        if (value != null) {
            return value;
        }
        TimerStats.Context ctx = this.stats.startLoaderTimer();
        try {
            value = this.memCache.get(key, valueLoader);
            ctx.stop();
            if (!ASYNC_CACHE) {
                this.write(key, value);
            }
            this.broadcast(key, value);
            return value;
        }
        catch (ExecutionException e) {
            this.stats.markException();
            throw e;
        }
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        return this.memCache.getAllPresent(keys);
    }

    @Override
    public void put(K key, V value) {
        this.memCache.put(key, value);
        if (!ASYNC_CACHE) {
            this.write(key, value);
        }
        this.broadcast(key, value);
    }

    @Override
    public void invalidate(Object key) {
        this.memCache.invalidate(key);
        if (ASYNC_CACHE) {
            this.writerQueue.addInvalidate(Collections.singleton(key));
        } else {
            this.write(key, null);
        }
        this.broadcast(key, null);
        this.stats.markInvalidateOne();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.memCache.putAll(m);
    }

    @Override
    public void invalidateAll(Iterable<?> keys) {
        this.memCache.invalidateAll(keys);
    }

    @Override
    public void invalidateAll() {
        this.memCache.invalidateAll();
        this.map.clear();
        this.stats.markInvalidateAll();
    }

    @Override
    public long size() {
        return this.memCache.size();
    }

    @Override
    public CacheStats stats() {
        return this.memCache.stats();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this.memCache.asMap();
    }

    @Override
    public void cleanUp() {
        this.memCache.cleanUp();
    }

    @Override
    public void receive(ByteBuffer buff) {
        Object value;
        Object key = this.keyType.read(buff);
        if (buff.get() == 0) {
            value = null;
            this.memCache.invalidate(key);
        } else {
            value = this.valueType.read(buff);
            this.memCache.put(key, value);
        }
        this.stats.markRecvBroadcast();
        if (!ASYNC_CACHE) {
            this.write(key, value);
        }
    }

    @Override
    public void evicted(K key, V value, RemovalCause cause) {
        if (ASYNC_CACHE && EVICTION_CAUSES.contains((Object)cause) && value != null) {
            this.writerQueue.addPut(key, value);
            long memory = 0L;
            memory += key == null ? 0L : (long)this.keyType.getMemory(key);
            this.stats.markBytesWritten(memory += value == null ? 0L : (long)this.valueType.getMemory(value));
            this.stats.markPut();
        }
    }

    public PersistentCacheStats getPersistentCacheStats() {
        return this.stats;
    }
}

