/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.MapFactory;
import org.h2.mvstore.MVMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheMap<K, V> {
    static final Logger LOG = LoggerFactory.getLogger(CacheMap.class);
    private final MapFactory factory;
    private final String name;
    private final MVMap.Builder<K, V> builder;
    private int openCount;
    private volatile Map<K, V> map;
    private volatile boolean closed;

    public CacheMap(MapFactory factory, String name, MVMap.Builder<K, V> builder) {
        this.factory = factory;
        this.name = name;
        this.builder = builder;
        this.openMap();
    }

    private void reopen(int i, Exception e) {
        if (i > 10) {
            LOG.warn("Too many re-opens; disabling this cache map", e);
            this.closed = true;
            return;
        }
        Thread.interrupted();
        if (i == 0) {
            LOG.warn("Re-opening map " + this.name, e);
        } else {
            LOG.debug("Re-opening map " + this.name + " again", e);
            LOG.warn("Re-opening map " + this.name + " again");
        }
        this.openMap();
    }

    public V put(K key, V value) {
        int i = 0;
        while (!this.closed) {
            try {
                return this.map.put(key, value);
            }
            catch (Exception e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
        return null;
    }

    public V get(Object key) {
        int i = 0;
        while (!this.closed) {
            try {
                return this.map.get(key);
            }
            catch (Exception e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        int i = 0;
        while (!this.closed) {
            try {
                return this.map.containsKey(key);
            }
            catch (Exception e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
        return false;
    }

    public V remove(Object key) {
        int i = 0;
        while (!this.closed) {
            try {
                return this.map.remove(key);
            }
            catch (Exception e) {
                this.reopen(i, e);
                ++i;
                continue;
            }
            break;
        }
        return null;
    }

    public void clear() {
        int i = 0;
        while (!this.closed) {
            try {
                this.map.clear();
            }
            catch (Exception e) {
                this.reopen(i, e);
            }
            ++i;
        }
        return;
    }

    void openMap() {
        this.openCount = this.factory.reopenStoreIfNeeded(this.openCount);
        Map<K, V> m2 = this.factory.openMap(this.name, this.builder);
        if (m2 != null) {
            this.map = m2;
        }
    }
}

