/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.replica;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.replica.GetRootRevisionsCallable;
import org.apache.jackrabbit.oak.plugins.document.mongo.replica.NodeCollectionProvider;
import org.apache.jackrabbit.oak.plugins.document.mongo.replica.ReplicaSetInfoListener;
import org.apache.jackrabbit.oak.plugins.document.mongo.replica.Timestamped;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.bson.BasicBSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaSetInfo
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaSetInfo.class);
    private final DB adminDb;
    private final long pullFrequencyMillis;
    private final long maxReplicationLagMillis;
    private final Executor executor;
    private final NodeCollectionProvider nodeCollections;
    private final Clock clock;
    private final Object stopMonitor = new Object();
    protected final List<ReplicaSetInfoListener> listeners = new CopyOnWriteArrayList<ReplicaSetInfoListener>();
    protected volatile RevisionVector rootRevisions;
    volatile long secondariesSafeTimestamp;
    List<String> hiddenMembers;
    private volatile boolean stop;

    public ReplicaSetInfo(Clock clock, DB db, String originalMongoUri, long pullFrequencyMillis, long maxReplicationLagMillis, Executor executor) {
        this.executor = executor;
        this.clock = clock;
        this.adminDb = db.getSisterDB("admin");
        this.pullFrequencyMillis = pullFrequencyMillis;
        this.maxReplicationLagMillis = maxReplicationLagMillis;
        this.nodeCollections = new NodeCollectionProvider(originalMongoUri, db.getName());
    }

    public void addListener(ReplicaSetInfoListener listener) {
        this.listeners.add(listener);
    }

    public boolean isMoreRecentThan(RevisionVector revisions) {
        RevisionVector localRootRevisions = this.rootRevisions;
        if (localRootRevisions == null) {
            return false;
        }
        return Utils.isGreaterOrEquals(localRootRevisions, revisions);
    }

    public long getLag() {
        long localTS = this.secondariesSafeTimestamp;
        if (localTS == 0L) {
            return this.maxReplicationLagMillis;
        }
        return this.clock.getTime() - localTS;
    }

    @Nullable
    public RevisionVector getMinimumRootRevisions() {
        return this.rootRevisions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.stopMonitor;
        synchronized (object) {
            this.stop = true;
            this.stopMonitor.notify();
        }
    }

    @Override
    public void run() {
        try {
            this.updateLoop();
        }
        catch (Exception e) {
            LOG.error("Exception in the ReplicaSetInfo thread", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLoop() {
        while (!this.stop) {
            if (this.hiddenMembers == null) {
                this.hiddenMembers = this.getHiddenMembers();
            } else {
                this.updateReplicaStatus();
                for (ReplicaSetInfoListener listener : this.listeners) {
                    listener.gotRootRevisions(this.rootRevisions);
                }
            }
            Object object = this.stopMonitor;
            synchronized (object) {
                block9: {
                    try {
                        if (this.stop) break block9;
                        this.stopMonitor.wait(this.pullFrequencyMillis);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
        LOG.debug("Stopping the replica set info");
        this.nodeCollections.close();
    }

    void updateReplicaStatus() {
        BasicDBObject result;
        try {
            result = this.getReplicaStatus();
        }
        catch (MongoException e) {
            LOG.error("Can't get replica status", e);
            this.rootRevisions = null;
            this.secondariesSafeTimestamp = 0L;
            return;
        }
        List<BasicBSONObject> members = (List<BasicBSONObject>)result.get("members");
        if (members == null) {
            members = Collections.emptyList();
        }
        this.updateRevisions(members);
    }

    List<String> getHiddenMembers() {
        BasicDBObject result;
        try {
            result = this.getReplicaConfig();
        }
        catch (MongoException e) {
            LOG.error("Can't get replica configuration", e);
            return null;
        }
        List<BasicBSONObject> members = (List<BasicBSONObject>)result.get("members");
        if (members == null) {
            members = Collections.emptyList();
        }
        ArrayList<String> hiddenMembers = new ArrayList<String>();
        for (BasicBSONObject member : members) {
            if (!member.getBoolean("hidden")) continue;
            hiddenMembers.add(member.getString("host"));
        }
        return hiddenMembers;
    }

    protected BasicDBObject getReplicaConfig() {
        return this.adminDb.command("replSetGetConfig", ReadPreference.primary());
    }

    protected BasicDBObject getReplicaStatus() {
        return this.adminDb.command("replSetGetStatus", ReadPreference.primary());
    }

    private void updateRevisions(Iterable<BasicBSONObject> members) {
        HashSet<String> secondaries = new HashSet<String>();
        boolean unknownState = false;
        String primary = null;
        block7: for (BasicBSONObject member : members) {
            MemberState state;
            try {
                state = MemberState.valueOf(member.getString("stateStr"));
            }
            catch (IllegalArgumentException e) {
                state = MemberState.UNKNOWN;
            }
            String name = member.getString("name");
            if (this.hiddenMembers.contains(name)) continue;
            switch (state) {
                case PRIMARY: {
                    primary = name;
                    continue block7;
                }
                case SECONDARY: {
                    secondaries.add(name);
                    continue block7;
                }
                case ARBITER: {
                    continue block7;
                }
            }
            LOG.debug("Invalid state {} for instance {}", (Object)state, (Object)name);
            unknownState = true;
        }
        if (secondaries.isEmpty()) {
            LOG.debug("No secondaries found: {}", (Object)members);
            unknownState = true;
        }
        if (primary == null) {
            LOG.debug("No primary found: {}", (Object)members);
            unknownState = true;
        }
        Map<String, Timestamped<RevisionVector>> vectors = null;
        if (!unknownState && (vectors = this.getRootRevisions(Sets.union(secondaries, ImmutableSet.of(primary)))).containsValue(null)) {
            unknownState = true;
        }
        if (unknownState) {
            this.rootRevisions = null;
            this.secondariesSafeTimestamp = 0L;
        } else {
            Timestamped primaryRevision = (Timestamped)vectors.get(primary);
            Collection<Timestamped<RevisionVector>> secondaryRevisions = Maps.filterKeys(vectors, Predicates.in(secondaries)).values();
            this.rootRevisions = ReplicaSetInfo.pmin(Iterables.transform(secondaryRevisions, Timestamped.getExtractFunction()));
            this.secondariesSafeTimestamp = this.rootRevisions == null || primaryRevision == null || Iterables.isEmpty(secondaryRevisions) ? 0L : this.getSecondariesSafeTimestamp(primaryRevision, secondaryRevisions);
        }
        LOG.debug("Minimum root revisions: {}. Current lag: {}", (Object)this.rootRevisions, (Object)this.getLag());
        this.nodeCollections.retain(secondaries);
    }

    private long getSecondariesSafeTimestamp(Timestamped<RevisionVector> primary, Iterable<Timestamped<RevisionVector>> secondaries) {
        RevisionVector priRev = primary.getValue();
        Long oldestNotReplicated = null;
        for (Timestamped<RevisionVector> v : secondaries) {
            RevisionVector secRev = v.getValue();
            if (secRev.equals(priRev)) continue;
            for (Revision pr : priRev) {
                Revision sr;
                if (pr.equals(sr = secRev.getRevision(pr.getClusterId())) || oldestNotReplicated != null && oldestNotReplicated <= pr.getTimestamp()) continue;
                oldestNotReplicated = pr.getTimestamp();
            }
        }
        if (oldestNotReplicated == null) {
            long minOpTimestamp = primary.getOperationTimestamp();
            for (Timestamped<RevisionVector> v : secondaries) {
                if (v.getOperationTimestamp() >= minOpTimestamp) continue;
                minOpTimestamp = v.getOperationTimestamp();
            }
            return minOpTimestamp;
        }
        return oldestNotReplicated;
    }

    protected Map<String, Timestamped<RevisionVector>> getRootRevisions(Iterable<String> hosts) {
        HashMap<String, FutureTask<Timestamped<RevisionVector>>> futures = new HashMap<String, FutureTask<Timestamped<RevisionVector>>>();
        for (String hostName : hosts) {
            GetRootRevisionsCallable callable = new GetRootRevisionsCallable(this.clock, hostName, this.nodeCollections);
            FutureTask<Timestamped<RevisionVector>> futureTask = new FutureTask<Timestamped<RevisionVector>>(callable);
            futures.put(hostName, futureTask);
            this.executor.execute(futureTask);
        }
        HashMap<String, Timestamped<RevisionVector>> result = new HashMap<String, Timestamped<RevisionVector>>();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                result.put((String)entry.getKey(), (Timestamped<RevisionVector>)((Future)entry.getValue()).get());
            }
            catch (Exception e) {
                LOG.error("Can't connect to the Mongo instance", e);
            }
        }
        return result;
    }

    private static RevisionVector pmin(Iterable<RevisionVector> vectors) {
        RevisionVector minimum = null;
        for (RevisionVector v : vectors) {
            if (v == null) {
                return null;
            }
            if (minimum == null) {
                minimum = v;
                continue;
            }
            minimum = minimum.pmin(v);
        }
        return minimum;
    }

    public static enum MemberState {
        STARTUP,
        PRIMARY,
        SECONDARY,
        RECOVERING,
        STARTUP2,
        UNKNOWN,
        ARBITER,
        DOWN,
        ROLLBACK,
        REMOVED;

    }
}

