/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo.replica;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.mongo.replica.NodeCollectionProvider;
import org.apache.jackrabbit.oak.plugins.document.mongo.replica.Timestamped;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRootRevisionsCallable
implements Callable<Timestamped<RevisionVector>> {
    private static final Logger LOG = LoggerFactory.getLogger(GetRootRevisionsCallable.class);
    private final String hostName;
    private final NodeCollectionProvider nodeCollections;
    private final Clock clock;

    public GetRootRevisionsCallable(Clock clock, String hostName, NodeCollectionProvider nodeCollections) {
        this.hostName = hostName;
        this.nodeCollections = nodeCollections;
        this.clock = clock;
    }

    @Override
    public Timestamped<RevisionVector> call() throws Exception {
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        DBCollection collection = this.nodeCollections.get(this.hostName);
        long start = this.clock.getTime();
        DBObject root = collection.findOne(new BasicDBObject("_id", "0:/"));
        long end = this.clock.getTime();
        long mid = (start + end) / 2L;
        if (root == null) {
            LOG.warn("Can't get the root document on {}", (Object)this.hostName);
            return null;
        }
        DBObject lastRev = (DBObject)root.get("_lastRev");
        for (String clusterId : lastRev.keySet()) {
            String rev = (String)lastRev.get(clusterId);
            revisions.add(Revision.fromString(rev));
        }
        LOG.debug("Got /_lastRev from {}: {}", (Object)this.hostName, (Object)lastRev);
        return new Timestamped<RevisionVector>(new RevisionVector(revisions), mid);
    }
}

