/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.ReadPreference;
import java.util.Set;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoVersionGCSupport
extends VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoVersionGCSupport.class);
    private final MongoDocumentStore store;
    private final boolean disableIndexHint = Boolean.getBoolean("oak.mongo.disableVersionGCIndexHint");
    private final int batchSize = Integer.getInteger("oak.mongo.queryDeletedDocsBatchSize", 1000);

    public MongoVersionGCSupport(MongoDocumentStore store) {
        super(store);
        this.store = store;
    }

    public CloseableIterable<NodeDocument> getPossiblyDeletedDocs(long lastModifiedTime) {
        DBObject query = QueryBuilder.start("_deletedOnce").is(Boolean.TRUE).put("_modified").lessThan(NodeDocument.getModifiedInSecs(lastModifiedTime)).get();
        DBCursor cursor = this.getNodeCollection().find(query).setReadPreference(ReadPreference.secondaryPreferred());
        cursor.batchSize(this.batchSize);
        if (!this.disableIndexHint) {
            cursor.hint(new BasicDBObject("_deletedOnce", (Object)1));
        }
        return CloseableIterable.wrap(Iterables.transform(cursor, new Function<DBObject, NodeDocument>(){

            @Override
            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        }), cursor);
    }

    @Override
    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new MongoSplitDocCleanUp(gcTypes, oldestRevTimeStamp, stats);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp) {
        return Iterables.transform(this.getNodeCollection().find(this.createQuery(gcTypes, oldestRevTimeStamp)), new Function<DBObject, NodeDocument>(){

            @Override
            public NodeDocument apply(DBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, input);
            }
        });
    }

    private DBObject createQuery(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp) {
        QueryBuilder orClause = QueryBuilder.start();
        for (NodeDocument.SplitDocType type : gcTypes) {
            orClause.or(QueryBuilder.start("_sdType").is(type.typeCode()).get());
        }
        return QueryBuilder.start().and(orClause.get(), QueryBuilder.start("_sdMaxRevTime").lessThan(NodeDocument.getModifiedInSecs(oldestRevTimeStamp)).get()).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logSplitDocIdsTobeDeleted(DBObject query) {
        ImmutableList<String> ids;
        BasicDBObject keys = new BasicDBObject("_id", (Object)1);
        try (DBCursor cursor = this.getNodeCollection().find(query, keys).setReadPreference(this.store.getConfiguredReadPreference(Collection.NODES));){
            ids = ImmutableList.copyOf(Iterables.transform(cursor, new Function<DBObject, String>(){

                @Override
                public String apply(DBObject input) {
                    return (String)input.get("_id");
                }
            }));
        }
        StringBuilder sb = new StringBuilder("Split documents with following ids were deleted as part of GC \n");
        Joiner.on(StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, (Iterable<?>)ids);
        LOG.debug(sb.toString());
    }

    private DBCollection getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES);
    }

    private class MongoSplitDocCleanUp
    extends SplitDocumentCleanUp {
        protected final Set<NodeDocument.SplitDocType> gcTypes;
        protected final long oldestRevTimeStamp;

        protected MongoSplitDocCleanUp(Set<NodeDocument.SplitDocType> gcTypes, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
            super(MongoVersionGCSupport.this.store, stats, MongoVersionGCSupport.this.identifyGarbage(gcTypes, oldestRevTimeStamp));
            this.gcTypes = gcTypes;
            this.oldestRevTimeStamp = oldestRevTimeStamp;
        }

        @Override
        protected int deleteSplitDocuments() {
            DBObject query = MongoVersionGCSupport.this.createQuery(this.gcTypes, this.oldestRevTimeStamp);
            if (LOG.isDebugEnabled()) {
                MongoVersionGCSupport.this.logSplitDocIdsTobeDeleted(query);
            }
            return MongoVersionGCSupport.this.getNodeCollection().remove(query).getN();
        }
    }
}

