/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.cache;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheChangesTracker;
import org.apache.jackrabbit.oak.plugins.document.cache.ModificationStamp;
import org.apache.jackrabbit.oak.plugins.document.locks.NodeDocumentLocks;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;

public class NodeDocumentCache
implements Closeable {
    private final Cache<CacheValue, NodeDocument> nodeDocumentsCache;
    private final CacheStats nodeDocumentsCacheStats;
    private final Cache<StringValue, NodeDocument> prevDocumentsCache;
    private final CacheStats prevDocumentsCacheStats;
    private final NodeDocumentLocks locks;
    private final List<CacheChangesTracker> changeTrackers;

    public NodeDocumentCache(@Nonnull Cache<CacheValue, NodeDocument> nodeDocumentsCache, @Nonnull CacheStats nodeDocumentsCacheStats, @Nonnull Cache<StringValue, NodeDocument> prevDocumentsCache, @Nonnull CacheStats prevDocumentsCacheStats, @Nonnull NodeDocumentLocks locks) {
        this.nodeDocumentsCache = nodeDocumentsCache;
        this.nodeDocumentsCacheStats = nodeDocumentsCacheStats;
        this.prevDocumentsCache = prevDocumentsCache;
        this.prevDocumentsCacheStats = prevDocumentsCacheStats;
        this.locks = locks;
        this.changeTrackers = new CopyOnWriteArrayList<CacheChangesTracker>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(@Nonnull String key) {
        Lock lock = this.locks.acquire(key);
        try {
            if (Utils.isLeafPreviousDocId(key)) {
                this.prevDocumentsCache.invalidate(new StringValue(key));
            } else {
                this.nodeDocumentsCache.invalidate(new StringValue(key));
            }
            this.internalMarkChanged(key);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChanged(@Nonnull String key) {
        Lock lock = this.locks.acquire(key);
        try {
            this.internalMarkChanged(key);
        }
        finally {
            lock.unlock();
        }
    }

    @Nonnegative
    public int invalidateOutdated(@Nonnull Map<String, ModificationStamp> modStamps) {
        int invalidatedCount = 0;
        for (Map.Entry<String, ModificationStamp> e : modStamps.entrySet()) {
            String id = e.getKey();
            ModificationStamp stamp = e.getValue();
            NodeDocument doc = this.getIfPresent(id);
            if (doc == null || Objects.equal(stamp.modCount, doc.getModCount()) && Objects.equal(stamp.modified, doc.getModified())) continue;
            this.invalidate(id);
            ++invalidatedCount;
        }
        return invalidatedCount;
    }

    @CheckForNull
    public NodeDocument getIfPresent(@Nonnull String key) {
        if (Utils.isLeafPreviousDocId(key)) {
            return this.prevDocumentsCache.getIfPresent(new StringValue(key));
        }
        return this.nodeDocumentsCache.getIfPresent(new StringValue(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public NodeDocument get(final @Nonnull String key, final @Nonnull Callable<NodeDocument> valueLoader) throws ExecutionException {
        Callable<NodeDocument> wrappedLoader = new Callable<NodeDocument>(){

            @Override
            public NodeDocument call() throws Exception {
                for (CacheChangesTracker tracker : NodeDocumentCache.this.changeTrackers) {
                    tracker.putDocument(key);
                }
                return (NodeDocument)valueLoader.call();
            }
        };
        Lock lock = this.locks.acquire(key);
        try {
            if (Utils.isLeafPreviousDocId(key)) {
                NodeDocument nodeDocument = this.prevDocumentsCache.get(new StringValue(key), wrappedLoader);
                return nodeDocument;
            }
            NodeDocument nodeDocument = this.nodeDocumentsCache.get(new StringValue(key), wrappedLoader);
            return nodeDocument;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@Nonnull NodeDocument doc) {
        if (doc != NodeDocument.NULL) {
            Lock lock = this.locks.acquire(doc.getId());
            try {
                this.putInternal(doc);
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public NodeDocument putIfNewer(@Nonnull NodeDocument doc) {
        NodeDocument newerDoc;
        if (doc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        doc.seal();
        String id = doc.getId();
        Lock lock = this.locks.acquire(id);
        try {
            NodeDocument cachedDoc = this.getIfPresent(id);
            if (this.isNewer(cachedDoc, doc)) {
                newerDoc = doc;
                this.putInternal(doc);
            } else {
                newerDoc = cachedDoc;
            }
        }
        finally {
            lock.unlock();
        }
        return newerDoc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public NodeDocument putIfAbsent(final @Nonnull NodeDocument doc) {
        if (doc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        doc.seal();
        String id = doc.getId();
        Lock lock = this.locks.acquire(id);
        try {
            while (true) {
                NodeDocument cached;
                if ((cached = this.get(id, new Callable<NodeDocument>(){

                    @Override
                    public NodeDocument call() {
                        return doc;
                    }
                })) != NodeDocument.NULL) {
                    NodeDocument nodeDocument = cached;
                    return nodeDocument;
                }
                this.invalidate(id);
                continue;
                break;
            }
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCachedDocument(@Nonnull NodeDocument oldDoc, @Nonnull NodeDocument newDoc) {
        if (newDoc == NodeDocument.NULL) {
            throw new IllegalArgumentException("doc must not be NULL document");
        }
        String key = oldDoc.getId();
        Lock lock = this.locks.acquire(key);
        try {
            NodeDocument cached = this.getIfPresent(key);
            if (cached != null) {
                if (Objects.equal(cached.getModCount(), oldDoc.getModCount())) {
                    this.putInternal(newDoc);
                } else {
                    this.invalidate(key);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Iterable<CacheValue> keys() {
        return Iterables.concat(this.nodeDocumentsCache.asMap().keySet(), this.prevDocumentsCache.asMap().keySet());
    }

    public Iterable<NodeDocument> values() {
        return Iterables.concat(this.nodeDocumentsCache.asMap().values(), this.prevDocumentsCache.asMap().values());
    }

    public Iterable<CacheStats> getCacheStats() {
        return Lists.newArrayList(this.nodeDocumentsCacheStats, this.prevDocumentsCacheStats);
    }

    @Override
    public void close() throws IOException {
        if (this.prevDocumentsCache instanceof Closeable) {
            ((Closeable)((Object)this.prevDocumentsCache)).close();
        }
        if (this.nodeDocumentsCache instanceof Closeable) {
            ((Closeable)((Object)this.nodeDocumentsCache)).close();
        }
    }

    public CacheChangesTracker registerTracker(final String fromKey, final String toKey) {
        int bloomFilterSize = toKey.equals(";") ? 10000 : 1000;
        return new CacheChangesTracker(new Predicate<String>(){

            @Override
            public boolean apply(@Nullable String input) {
                return input != null && fromKey.compareTo(input) < 0 && toKey.compareTo(input) > 0;
            }

            public String toString() {
                return String.format("key range: <%s, %s>", fromKey, toKey);
            }
        }, this.changeTrackers, bloomFilterSize);
    }

    public CacheChangesTracker registerTracker(final Set<String> keys) {
        return new CacheChangesTracker(new Predicate<String>(){

            @Override
            public boolean apply(@Nullable String input) {
                return input != null && keys.contains(input);
            }

            public String toString() {
                StringBuilder builder = new StringBuilder("key set [");
                Iterator it = keys.iterator();
                int i = 0;
                while (it.hasNext() && i++ < 3) {
                    builder.append((String)it.next());
                    if (!it.hasNext()) continue;
                    builder.append(", ");
                }
                if (it.hasNext()) {
                    builder.append("...");
                }
                builder.append("]").append(" (").append(keys.size()).append(" elements)");
                return builder.toString();
            }
        }, this.changeTrackers, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putNonConflictingDocs(CacheChangesTracker tracker, Iterable<NodeDocument> docs) {
        for (NodeDocument d : docs) {
            if (d == null || d == NodeDocument.NULL) continue;
            String id = d.getId();
            Lock lock = this.locks.acquire(id);
            try {
                NodeDocument cachedDoc = this.getIfPresent(id);
                if (cachedDoc != null && this.isNewer(cachedDoc, d)) {
                    this.putInternal(d);
                    continue;
                }
                if (cachedDoc != null || tracker.mightBeenAffected(id)) continue;
                this.putInternal(d);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void internalMarkChanged(String key) {
        for (CacheChangesTracker tracker : this.changeTrackers) {
            tracker.invalidateDocument(key);
        }
    }

    protected final void putInternal(@Nonnull NodeDocument doc) {
        if (Utils.isLeafPreviousDocId(doc.getId())) {
            this.prevDocumentsCache.put(new StringValue(doc.getId()), doc);
        } else {
            this.nodeDocumentsCache.put(new StringValue(doc.getId()), doc);
        }
        for (CacheChangesTracker tracker : this.changeTrackers) {
            tracker.putDocument(doc.getId());
        }
    }

    private boolean isNewer(@Nullable NodeDocument cachedDoc, @Nonnull NodeDocument doc) {
        if (cachedDoc == null || cachedDoc == NodeDocument.NULL) {
            return true;
        }
        Long cachedModCount = cachedDoc.getModCount();
        Long modCount = doc.getModCount();
        if (cachedModCount == null || modCount == null) {
            throw new IllegalStateException("Missing _modCount");
        }
        return modCount > cachedModCount;
    }
}

