/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionContext;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnmergedBranches {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<Branch> branches = new CopyOnWriteArrayList<Branch>();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    UnmergedBranches() {
    }

    void init(DocumentStore store, RevisionContext context) {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new IllegalStateException("already initialized");
        }
        NodeDocument doc = store.find(Collection.NODES, Utils.getIdFromPath("/"));
        if (doc == null) {
            return;
        }
        int purgeCount = doc.purgeUncommittedRevisions(context);
        if (purgeCount > 0) {
            this.log.info("Purged [{}] uncommitted branch revision entries", (Object)purgeCount);
        }
        if ((purgeCount = doc.purgeCollisionMarkers(context)) > 0) {
            this.log.info("Purged [{}] collision markers", (Object)purgeCount);
        }
    }

    @Nonnull
    Branch create(@Nonnull RevisionVector base, @Nonnull Revision initial, @Nullable Object guard) {
        Preconditions.checkArgument(!Preconditions.checkNotNull(base).isBranch(), "base is not a trunk revision: %s", base);
        Preconditions.checkArgument(Preconditions.checkNotNull(initial).isBranch(), "initial is not a branch revision: %s", initial);
        TreeSet<Revision> commits = new TreeSet<Revision>(StableRevisionComparator.INSTANCE);
        commits.add(initial);
        Branch b = new Branch(commits, base, this.queue, guard);
        this.branches.add(b);
        return b;
    }

    @CheckForNull
    Branch getBranch(@Nonnull RevisionVector r) {
        if (!r.isBranch()) {
            return null;
        }
        Revision branchRev = r.getBranchRevision();
        for (Branch b : this.branches) {
            if (!b.containsCommit(branchRev)) continue;
            return b;
        }
        return null;
    }

    boolean isBranchBase(@Nonnull RevisionVector r) {
        if (!r.isBranch()) {
            return false;
        }
        RevisionVector base = r.asTrunkRevision();
        for (Branch b : this.branches) {
            if (!b.getBase().equals(base)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    Branch.BranchCommit getBranchCommit(@Nonnull Revision r) {
        for (Branch b : this.branches) {
            Branch.BranchCommit c = b.getCommit(r);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    void remove(Branch b) {
        this.branches.remove(b);
    }

    int size() {
        return this.branches.size();
    }

    Branch pollOrphanedBranch() {
        Branch.BranchReference ref = (Branch.BranchReference)this.queue.poll();
        if (ref != null && this.branches.remove(ref.getBranch())) {
            return ref.getBranch();
        }
        return null;
    }
}

