/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MemoryDiffCache;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;

class TieredDiffCache
extends DiffCache {
    private final DiffCache localCache;
    private final DiffCache memoryCache;

    TieredDiffCache(DocumentMK.Builder builder) {
        this.localCache = new LocalDiffCache(builder);
        this.memoryCache = new MemoryDiffCache(builder);
    }

    @Override
    public String getChanges(@Nonnull RevisionVector from, @Nonnull RevisionVector to, @Nonnull String path, @Nullable DiffCache.Loader loader) {
        String changes = this.localCache.getChanges(from, to, path, null);
        if (changes != null) {
            return changes;
        }
        return this.memoryCache.getChanges(from, to, path, loader);
    }

    @Override
    @Nonnull
    public DiffCache.Entry newEntry(@Nonnull RevisionVector from, @Nonnull RevisionVector to, boolean local) {
        if (local) {
            return this.localCache.newEntry(from, to, true);
        }
        return this.memoryCache.newEntry(from, to, false);
    }

    @Override
    @Nonnull
    public Iterable<CacheStats> getStats() {
        return Iterables.concat(this.localCache.getStats(), this.memoryCache.getStats());
    }
}

