/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

class ResetDiff
implements NodeStateDiff {
    private final Revision revision;
    private final String path;
    private final Map<String, UpdateOp> operations;
    private UpdateOp update;

    ResetDiff(@Nonnull Revision revision, @Nonnull Map<String, UpdateOp> operations) {
        this(revision, "/", operations);
    }

    private ResetDiff(@Nonnull Revision revision, @Nonnull String path, @Nonnull Map<String, UpdateOp> operations) {
        this.revision = Preconditions.checkNotNull(revision);
        this.path = Preconditions.checkNotNull(path);
        this.operations = Preconditions.checkNotNull(operations);
    }

    @Override
    public boolean propertyAdded(PropertyState after) {
        this.getUpdateOp().removeMapEntry(after.getName(), this.revision);
        return true;
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.getUpdateOp().removeMapEntry(after.getName(), this.revision);
        return true;
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        this.getUpdateOp().removeMapEntry(before.getName(), this.revision);
        return true;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        NodeDocument.removeCommitRoot(this.getUpdateOp(), this.revision);
        String p = PathUtils.concat(this.path, name);
        ResetDiff diff = new ResetDiff(this.revision, p, this.operations);
        UpdateOp op = diff.getUpdateOp();
        NodeDocument.removeDeleted(op, this.revision);
        return after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, diff);
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        String p = PathUtils.concat(this.path, name);
        return after.compareAgainstBaseState(before, new ResetDiff(this.revision, p, this.operations));
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        String p = PathUtils.concat(this.path, name);
        ResetDiff diff = new ResetDiff(this.revision, p, this.operations);
        NodeDocument.removeDeleted(diff.getUpdateOp(), this.revision);
        return EmptyNodeState.MISSING_NODE.compareAgainstBaseState(before, diff);
    }

    Map<String, UpdateOp> getOperations() {
        return this.operations;
    }

    private UpdateOp getUpdateOp() {
        if (this.update == null) {
            this.update = this.operations.get(this.path);
            if (this.update == null) {
                String id = Utils.getIdFromPath(this.path);
                this.update = new UpdateOp(id, false);
                this.operations.put(this.path, this.update);
            }
            NodeDocument.removeRevision(this.update, this.revision);
            NodeDocument.removeCommitRoot(this.update, this.revision);
        }
        return this.update;
    }
}

